/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.JsFunction;
import com.cdp4j.JsObjectReleaseMode;
import com.cdp4j.JsonLibrary;
import com.cdp4j.Options;
import com.cdp4j.SelectorEngine;
import com.cdp4j.annotation.Experimental;
import com.cdp4j.annotation.Optional;
import com.cdp4j.channel.Channel;
import com.cdp4j.command.Emulation;
import com.cdp4j.command.Page;
import com.cdp4j.event.Events;
import com.cdp4j.event.log.EntryAdded;
import com.cdp4j.event.network.ResponseReceived;
import com.cdp4j.event.page.LifecycleEvent;
import com.cdp4j.event.runtime.ConsoleAPICalled;
import com.cdp4j.exception.CdpException;
import com.cdp4j.exception.CdpTimeoutException;
import com.cdp4j.exception.DestinationUnreachableException;
import com.cdp4j.exception.LoadTimeoutException;
import com.cdp4j.listener.EventListener;
import com.cdp4j.logger.CdpLogger;
import com.cdp4j.logger.LoggerFactory;
import com.cdp4j.serialization.DefaultEventParser;
import com.cdp4j.serialization.EventParser;
import com.cdp4j.serialization.JsonMapper;
import com.cdp4j.session.AsyncCommand;
import com.cdp4j.session.CdpFrame;
import com.cdp4j.session.CiscoOpenH264VideoRecorder;
import com.cdp4j.session.CloseListener;
import com.cdp4j.session.Command;
import com.cdp4j.session.Context;
import com.cdp4j.session.Dom;
import com.cdp4j.session.FFmpegVideoRecorder;
import com.cdp4j.session.GsonSessionInvocationHandler;
import com.cdp4j.session.JacksonSessionInvocationHandler;
import com.cdp4j.session.JavaScript;
import com.cdp4j.session.Keyboard;
import com.cdp4j.session.Mouse;
import com.cdp4j.session.Navigator;
import com.cdp4j.session.Selector;
import com.cdp4j.session.SessionFactory;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.session.VideoRecorder;
import com.cdp4j.session.VideoRecorderOptions;
import com.cdp4j.session.WaitUntil;
import com.cdp4j.type.constant.ImageFormat;
import com.cdp4j.type.dom.Rect;
import com.cdp4j.type.log.LogEntry;
import com.cdp4j.type.network.ResourceType;
import com.cdp4j.type.network.Response;
import com.cdp4j.type.page.Frame;
import com.cdp4j.type.page.FrameTree;
import com.cdp4j.type.page.GetLayoutMetricsResult;
import com.cdp4j.type.page.NavigateResult;
import com.cdp4j.type.page.PrintToPDFResult;
import com.cdp4j.type.page.ReferrerPolicy;
import com.cdp4j.type.page.TransitionType;
import com.cdp4j.type.page.Viewport;
import com.cdp4j.type.runtime.RemoteObject;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

public class Session
implements AutoCloseable,
Selector,
Keyboard,
Mouse,
Navigator,
JavaScript,
Dom {
    public final List<CdpFrame> frames;
    private final AtomicBoolean connected = new AtomicBoolean(true);
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private EventParser eventParser = new DefaultEventParser();
    private final JsonMapper mapper;
    private final List<EventListener> listeners;
    private final List<EventListener> syncListeners;
    private final SessionInvocationHandler invocationHandler;
    private final SessionFactory sesessionFactory;
    private final Channel channel;
    private final CdpLogger log;
    private final CdpLogger logFlow;
    private final String targetId;
    private final String sessionId;
    private final Boolean multiFrameMode;
    private final ReentrantLock lock = new ReentrantLock(true);
    private String browserContextId;
    private Command command;
    private AsyncCommand asyncCommand;
    private volatile String frameId;
    private volatile Integer executionContextId;
    private volatile Integer childFrameExecutionContextId;
    private volatile String childFrameId;
    private final Map<Class<?>, Object> jsFunctions;
    private final Map<Integer, Context> contexts;
    private final SelectorEngine selectorEngine;
    private final JsObjectReleaseMode jsObjectReleaseMode;
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private volatile EnumSet<Events> registeredEventListeners = EnumSet.allOf(Events.class);
    private final LoggerFactory loggerFactory;
    private static final AtomicBoolean ENABLE_ENTRY_EXIT_LOG = new AtomicBoolean(true);

    Session(Options options, JsonMapper mapper, String sessionId, String targetId, String browserContextId, Channel channel, Map<Integer, Context> contexts, SessionFactory sessionFactory, List<EventListener> eventListeners, LoggerFactory loggerFactory, Boolean multiFrameMode, SelectorEngine selectorEngine) {
        this.mapper = mapper;
        this.sessionId = sessionId;
        this.browserContextId = browserContextId;
        this.contexts = contexts;
        this.invocationHandler = JsonLibrary.Jackson.equals((Object)options.jsonLibrary()) ? new JacksonSessionInvocationHandler(mapper, channel, contexts, this, loggerFactory.getLogger("cdp4j.ws.request"), sessionId, options.readTimeout(), options.readTimeoutExceptionHandler(), options.waitingStrategy(), options.workerThreadPool()) : new GsonSessionInvocationHandler(mapper, channel, contexts, this, loggerFactory.getLogger("cdp4j.ws.request"), sessionId, options.readTimeout(), options.readTimeoutExceptionHandler(), options.waitingStrategy(), options.workerThreadPool());
        this.targetId = targetId;
        this.sesessionFactory = sessionFactory;
        this.listeners = eventListeners;
        this.syncListeners = new CopyOnWriteArrayList<EventListener>();
        this.channel = channel;
        this.log = loggerFactory.getLogger("cdp4j.session");
        this.logFlow = loggerFactory.getLogger("cdp4j.flow");
        this.jsFunctions = new ConcurrentHashMap();
        this.command = new Command(this.invocationHandler);
        this.asyncCommand = new AsyncCommand(this.invocationHandler);
        this.selectorEngine = selectorEngine;
        this.multiFrameMode = multiFrameMode;
        this.frames = multiFrameMode != false ? new CopyOnWriteArrayList() : Collections.emptyList();
        this.jsObjectReleaseMode = options.jsObjectReleaseMode();
        this.loggerFactory = loggerFactory;
    }

    public String getId() {
        return this.sessionId;
    }

    @Override
    public void close() {
        this.logEntry("close");
        if (this.connected.get()) {
            if (this.channel.isOpen()) {
                try {
                    this.sesessionFactory.close(this);
                }
                finally {
                    this.connected.set(false);
                }
            } else {
                this.dispose();
            }
        }
    }

    public void remove() {
        this.logEntry("close");
        if (this.connected.get()) {
            if (this.channel.isOpen()) {
                try {
                    this.sesessionFactory.remove(this);
                }
                finally {
                    this.connected.set(false);
                }
            } else {
                this.dispose();
            }
        }
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void activate() {
        this.logEntry("activate");
        this.sesessionFactory.activate(this.sessionId);
    }

    public void addEventListener(EventListener eventListener) {
        this.listeners.add(eventListener);
    }

    public void removeEventEventListener(EventListener eventListener) {
        if (eventListener != null) {
            this.listeners.remove(eventListener);
        }
    }

    public void addSyncEventListener(EventListener eventListener) {
        this.syncListeners.add(eventListener);
    }

    public void removeSyncEventEventListener(EventListener eventListener) {
        if (eventListener != null) {
            this.syncListeners.remove(eventListener);
        }
    }

    public Session waitDocumentReady() {
        return this.waitDocumentReady(10000);
    }

    public Session waitDocumentReady(int timeout) {
        return this.navigateAndWait(null, WaitUntil.DomReady, timeout);
    }

    public boolean waitUntil(Predicate<Session> predicate) {
        return this.waitUntil(predicate, 10000, 100);
    }

    public boolean waitUntil(Predicate<Session> predicate, int timeout) {
        return this.waitUntil(predicate, timeout, 100, true);
    }

    public boolean waitUntil(Predicate<Session> predicate, int timeout, int period) {
        return this.waitUntil(predicate, timeout, period, true);
    }

    public boolean waitUntil(Predicate<Session> predicate, int timeout, int period, boolean log) {
        int count = (int)Math.floor(timeout / period);
        for (int i = 0; i < count; ++i) {
            boolean wakeup = predicate.test(this.getThis());
            if (wakeup) {
                return true;
            }
            if (!this.isConnected()) {
                return false;
            }
            this.wait(period, log);
        }
        return false;
    }

    public Session navigate(String url) {
        return this.navigate(url, null, null, null, null);
    }

    public Session navigate(String url, String referrer, TransitionType transitionType, String frameId, ReferrerPolicy referrerPolicy) {
        return this.navigate(url, referrer, transitionType, frameId, referrerPolicy, this.command.getPage());
    }

    public Session navigate(String url, String referrer, TransitionType transitionType, String frameId, ReferrerPolicy referrerPolicy, Page pageCommand) {
        this.logEntry("navigate", url);
        NavigateResult navigate = pageCommand.navigate(url, referrer, transitionType, frameId, referrerPolicy);
        if (navigate == null) {
            throw new DestinationUnreachableException(url);
        }
        this.frameId = navigate.getFrameId();
        return this;
    }

    public Session waitUntil(WaitUntil condition) {
        return this.navigateAndWait(null, condition);
    }

    public Session waitUntil(WaitUntil condition, int timeout) {
        return this.navigateAndWait(null, condition, timeout);
    }

    public Session navigateAndWait(String url, WaitUntil condition) {
        return this.navigateAndWait(url, condition, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session navigateAndWait(String url, WaitUntil condition, int timeout) {
        WaitUntil waitUntil;
        long start = System.currentTimeMillis();
        WaitUntil waitUntil2 = waitUntil = WaitUntil.DomReady.equals((Object)condition) ? WaitUntil.Load : condition;
        if (url != null) {
            this.logEntry("navigateAndWait", String.format("[url=%s, waitUntil=%s, timeout=%d]", url, condition.name(), timeout));
            NavigateResult result = this.command.getPage().navigate(url);
            if (result != null) {
                this.frameId = result.getFrameId();
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        EventListener loadListener = (e, d) -> {
            LifecycleEvent le;
            if (Events.PageLifecycleEvent.equals((Object)e) && waitUntil.value.equals((le = (LifecycleEvent)d).getName())) {
                if (this.frameId == null) {
                    this.frameId = le.getFrameId();
                }
                latch.countDown();
            }
        };
        this.addSyncEventListener(loadListener);
        try {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            throw new LoadTimeoutException(e2);
        }
        finally {
            this.removeEventEventListener(loadListener);
        }
        long elapsedTime = System.currentTimeMillis() - start;
        if (elapsedTime > (long)timeout) {
            if (url != null) {
                throw new LoadTimeoutException("Page not loaded within " + timeout + " ms");
            }
            throw new CdpTimeoutException(timeout + " ms");
        }
        if (url != null && this.frameId == null) {
            FrameTree tree = this.getThis().getCommand().getPage().getFrameTree();
            if (tree != null && tree.getFrame() != null && tree.getFrame().getId() != null) {
                this.frameId = tree.getFrame().getId();
            } else {
                throw new DestinationUnreachableException(url);
            }
        }
        if (WaitUntil.DomReady.equals((Object)condition) && !this.isDomReady()) {
            try {
                this.disableFlowLog();
                boolean ready = this.waitUntil(p -> this.isDomReady(), timeout - (int)elapsedTime, 10);
                if (!ready) {
                    throw new LoadTimeoutException("Page not loaded within " + timeout + " ms");
                }
            }
            finally {
                this.enableFlowLog();
            }
        }
        return this;
    }

    public Session enableConsoleLog() {
        if (!this.getRegisteredEventListeners().contains((Object)Events.RuntimeConsoleAPICalled)) {
            throw new CdpException("Register RuntimeConsoleAPICalled to enable console log. tip: call session.setRegisteredEventListeners(EnumSet.of(RuntimeConsoleAPICalled))");
        }
        this.getCommand().getRuntime().enable();
        this.addEventListener((e, d) -> {
            if (Events.RuntimeConsoleAPICalled.equals((Object)e)) {
                ConsoleAPICalled ca = (ConsoleAPICalled)d;
                for (RemoteObject next : ca.getArgs()) {
                    Object value = next.getValue();
                    String type = ca.getType().toString().toUpperCase(Locale.ENGLISH);
                    switch (ca.getType()) {
                        case Log: 
                        case Info: {
                            this.log.info("[console] [{}] {}", type, String.valueOf(value));
                            break;
                        }
                        case Error: {
                            this.log.info("[console] [{}] {}", type, String.valueOf(value));
                            break;
                        }
                        case Warning: {
                            this.log.info("[console] [{}] {}", type, String.valueOf(value));
                            break;
                        }
                    }
                }
            }
        });
        return this.getThis();
    }

    public Session enableDetailLog() {
        if (!this.getRegisteredEventListeners().contains((Object)Events.LogEntryAdded)) {
            throw new CdpException("Register LogEntryAdded to enable detail log. tip: call session.setRegisteredEventListeners(EnumSet.of(LogEntryAdded))");
        }
        this.getCommand().getLog().enable();
        this.addEventListener((e, d) -> {
            if (Events.LogEntryAdded.equals((Object)e)) {
                EntryAdded entryAdded = (EntryAdded)d;
                LogEntry entry = entryAdded.getEntry();
                String level = entry.getLevel().toString().toUpperCase(Locale.ENGLISH);
                switch (entry.getLevel()) {
                    case Verbose: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                        break;
                    }
                    case Info: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                        break;
                    }
                    case Warning: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                        break;
                    }
                    case Error: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                    }
                }
            }
        });
        return this.getThis();
    }

    public Session enableNetworkLog() {
        if (!this.getRegisteredEventListeners().contains((Object)Events.NetworkResponseReceived)) {
            throw new CdpException("Register NetworkResponseReceived to enable network log. tip: call session.setRegisteredEventListeners(EnumSet.of(NetworkResponseReceived))");
        }
        this.getCommand().getNetwork().enable();
        this.addEventListener((e, d) -> {
            if (Events.NetworkResponseReceived.equals((Object)e)) {
                ResponseReceived rr = (ResponseReceived)d;
                Response response = rr.getResponse();
                String url = response.getUrl();
                int status = response.getStatus();
                String mimeType = response.getMimeType();
                if (ResourceType.Document.equals((Object)rr.getType()) || ResourceType.XHR.equals((Object)rr.getType())) {
                    this.log.info("[{}] [{}] [{}] [{}] [{}]", rr.getType().toString().toUpperCase(Locale.ENGLISH), rr.getResponse().getProtocol().toUpperCase(Locale.ENGLISH), status, mimeType, url);
                }
            }
        });
        return this.getThis();
    }

    @Override
    public Session getThis() {
        return this;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public byte[] captureScreenshot() {
        return this.captureScreenshot(ImageFormat.Png, null, null, true);
    }

    public byte[] captureScreenshot(@Optional ImageFormat format, @Optional Integer quality, @Optional Viewport clip, @Experimental @Optional Boolean fromSurface) {
        Page page = this.getThis().getCommand().getPage();
        GetLayoutMetricsResult metrics = page.getLayoutMetrics();
        Rect cs = metrics.getCssContentSize();
        Emulation emulation = this.getThis().getCommand().getEmulation();
        emulation.setDeviceMetricsOverride(cs.getWidth().intValue(), cs.getHeight().intValue(), 0.0, false);
        byte[] data = page.captureScreenshot(format, quality, clip, fromSurface, Boolean.TRUE, null);
        emulation.clearDeviceMetricsOverride();
        emulation.resetPageScaleFactor();
        return data;
    }

    public byte[] printToPDF() {
        PrintToPDFResult result = this.getCommand().getPage().printToPDF();
        return result.getData();
    }

    /*
     * Exception decompiling
     */
    public void printToPDF(Path file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Session wait(int timeout) {
        return this.wait(timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session wait(int timeout, boolean log) {
        if (!this.lock.tryLock()) throw new CdpException("Unable to acquire lock");
        Condition condition = this.lock.newCondition();
        try {
            if (log) {
                this.logEntry("wait", timeout + "ms");
            }
            condition.await(timeout, TimeUnit.MILLISECONDS);
            return this.getThis();
        }
        catch (InterruptedException e) {
            if (!this.channel.isOpen() || !this.connected.get()) return this.getThis();
            throw new CdpException(e);
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public AsyncCommand getAsyncCommand() {
        return this.asyncCommand;
    }

    private void getFrames(List<Frame> frames, FrameTree child) {
        frames.add(child.getFrame());
        for (FrameTree next : child.getChildFrames()) {
            this.getFrames(frames, next);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)obj;
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }

    void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            for (CloseListener next : this.closeListeners) {
                next.closed();
            }
            this.frames.clear();
            this.listeners.clear();
            this.jsFunctions.clear();
            this.invocationHandler.dispose();
            this.listeners.clear();
            this.closeListeners.clear();
            this.registeredEventListeners.clear();
        }
    }

    void info(String message, Object ... args) {
        this.log.info(message, args);
    }

    void error(String message, Object ... args) {
        this.log.error(message, args);
    }

    void logEntry(String method) {
        this.logEntry(method, null);
    }

    void logEntry(String method, String args) {
        if (!ENABLE_ENTRY_EXIT_LOG.get()) {
            return;
        }
        boolean hasArgs = args != null;
        this.logFlow.info("{}({}{}{})", method, hasArgs ? "\"" : "", hasArgs ? args : "", hasArgs ? "\"" : "");
    }

    void logExit(String method, Object retValue) {
        this.logExit(method, null, retValue);
    }

    void logExit(String method, String args, Object retValue) {
        if (!ENABLE_ENTRY_EXIT_LOG.get()) {
            return;
        }
        boolean hasArgs = args != null;
        this.logFlow.info("{}({}{}{}): {}", method, hasArgs ? "\"" : "", hasArgs ? args : "", hasArgs ? "\"" : "", retValue);
    }

    void disableFlowLog() {
        ENABLE_ENTRY_EXIT_LOG.set(Boolean.FALSE);
    }

    void enableFlowLog() {
        ENABLE_ENTRY_EXIT_LOG.set(Boolean.TRUE);
    }

    Context pullContext(Integer id) {
        return this.contexts.remove(id);
    }

    List<EventListener> getListeners() {
        return this.listeners;
    }

    List<EventListener> getSyncListeners() {
        return this.syncListeners;
    }

    boolean addFrame(CdpFrame frame) {
        if (!this.frames.contains(frame)) {
            return this.frames.add(frame);
        }
        return false;
    }

    boolean removeFrame(int executionContextId) {
        CdpFrame found = null;
        for (CdpFrame next : this.frames) {
            if (!next.getExecutionContextId().equals(executionContextId)) continue;
            found = next;
            break;
        }
        if (found != null) {
            return this.frames.remove(found);
        }
        return false;
    }

    public boolean switchFrame(Frame frame) {
        return this.switchFrame(frame == null ? null : frame.getId());
    }

    public boolean switchFrame(String frameId) {
        if (Boolean.FALSE == this.multiFrameMode) {
            throw new CdpException("Iframe support is not enabled. Please create a session with iframe support.");
        }
        if (frameId == null) {
            return false;
        }
        if (this.frameId.equals(frameId)) {
            this.switchToRootFrame();
            return true;
        }
        int idx = this.frames.indexOf(new CdpFrame(frameId));
        if (idx >= 0) {
            CdpFrame found = this.frames.get(idx);
            this.childFrameId = found.getId();
            this.childFrameExecutionContextId = found.getExecutionContextId();
            return true;
        }
        return false;
    }

    public String getChildFrameId() {
        return this.childFrameId;
    }

    public Integer getChildFrameExecutionContextId() {
        return this.childFrameExecutionContextId;
    }

    public void switchToRootFrame() {
        this.childFrameId = null;
        this.childFrameExecutionContextId = null;
    }

    public boolean isRootFrame() {
        if (this.multiFrameMode.booleanValue()) {
            return this.childFrameId == null;
        }
        return true;
    }

    public List<Frame> getFrames() {
        ArrayList<Frame> list = new ArrayList<Frame>();
        FrameTree tree = this.getCommand().getPage().getFrameTree();
        for (FrameTree next : tree.getChildFrames()) {
            this.getFrames(list, next);
        }
        return list;
    }

    public <T> T registerJsFunction(Class<T> klass) {
        if (!klass.isInterface()) {
            throw new CdpException("Class must be interface: " + klass.getName());
        }
        if (Arrays.asList(klass.getMethods()).stream().filter(p -> p.isAnnotationPresent(JsFunction.class)).count() == 0L) {
            throw new CdpException("Interface must be contain at least one @JsFunction");
        }
        if (this.jsFunctions.containsKey(klass)) {
            throw new CdpException("Duplicate Registration is not allowed: " + klass);
        }
        if (this.jsFunctions.keySet().stream().filter(p -> p.getSimpleName().equals(klass.getSimpleName())).count() > 0L) {
            throw new CdpException("Duplicate class name is not allowed: " + klass.getSimpleName());
        }
        Method[] methods = klass.getMethods();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("document.%s = document.%s || {};", klass.getSimpleName(), klass.getSimpleName()));
        for (Method next : methods) {
            JsFunction function = next.getAnnotation(JsFunction.class);
            if (function == null) continue;
            StringBuilder jsMethod = new StringBuilder();
            jsMethod.append("document.");
            jsMethod.append(klass.getSimpleName());
            jsMethod.append(".");
            jsMethod.append(next.getName());
            jsMethod.append(" = function(");
            int count = next.getParameterCount();
            StringJoiner joiner = new StringJoiner(", ");
            for (int i = 0; i < count; ++i) {
                Parameter parameter = next.getParameters()[i];
                joiner.add(parameter.getName());
            }
            jsMethod.append(joiner.toString());
            jsMethod.append(") { ");
            jsMethod.append(function.value());
            jsMethod.append(" };");
            builder.append(jsMethod.toString());
        }
        Page page = this.getCommand().getPage();
        page.addScriptToEvaluateOnNewDocument(builder.toString());
        Object instance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{klass}, (proxy, method, args) -> {
            String className = method.getDeclaringClass().getSimpleName();
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if ((Void.TYPE.equals(returnType) || Void.class.equals(returnType)) && (args == null || args.length == 0)) {
                this.callFunction("document." + className + "." + methodName);
                return null;
            }
            Object result = this.callFunction("document." + className + "." + methodName, returnType, args);
            return result;
        });
        this.jsFunctions.put(klass, instance);
        return (T)instance;
    }

    public <T> T getJsFunction(Class<T> klass) {
        return (T)this.jsFunctions.get(klass);
    }

    boolean isPrimitive(Class<?> klass) {
        if (String.class.equals(klass)) {
            return true;
        }
        if (Boolean.TYPE.equals(klass) || Boolean.class.equals(klass)) {
            return true;
        }
        if (Void.TYPE.equals(klass) || Void.class.equals(klass)) {
            return true;
        }
        if (Integer.TYPE.equals(klass) || Integer.class.equals(klass)) {
            return true;
        }
        if (Double.TYPE.equals(klass) || Double.class.equals(klass)) {
            return true;
        }
        if (Long.TYPE.equals(klass) || Long.class.equals(klass)) {
            return true;
        }
        if (Float.TYPE.equals(klass) || Float.class.equals(klass)) {
            return true;
        }
        if (Character.TYPE.equals(klass) || Character.class.equals(klass)) {
            return true;
        }
        if (Byte.TYPE.equals(klass) || Byte.class.equals(klass)) {
            return true;
        }
        return Short.TYPE.equals(klass) || Short.class.equals(klass);
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getBrowserContextId() {
        return this.browserContextId;
    }

    public Integer getExecutionContextId() {
        if (Boolean.FALSE == this.multiFrameMode) {
            return this.executionContextId;
        }
        if (this.childFrameId == null) {
            return this.executionContextId;
        }
        return this.childFrameExecutionContextId;
    }

    void setExecutionContextId(Integer executionContextId) {
        this.executionContextId = executionContextId;
    }

    public SelectorEngine getSelectorEngine() {
        return this.selectorEngine;
    }

    public boolean addCloseListener(CloseListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.closeListeners.contains(listener)) {
            return false;
        }
        return this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        return this.closeListeners.remove(listener);
    }

    public JsonMapper getJsonMapper() {
        return this.mapper;
    }

    public Boolean isMultiFrameMode() {
        return this.multiFrameMode;
    }

    public void setRegisteredEventListeners(EnumSet<Events> registeredEventListeners) {
        this.registeredEventListeners = registeredEventListeners;
    }

    public EnumSet<Events> getRegisteredEventListeners() {
        return this.registeredEventListeners;
    }

    JsObjectReleaseMode jsObjectReleaseMode() {
        return this.jsObjectReleaseMode;
    }

    public VideoRecorder createVideoRecoder(VideoRecorderOptions options) {
        return new FFmpegVideoRecorder(this, options, this.loggerFactory.getLogger("cdp4j.videoRecorder"));
    }

    public VideoRecorder createRealtimeVideoRecoder(VideoRecorderOptions options) {
        int start = options.videoFileName().indexOf(46);
        String extension = options.videoFileName().substring(start + 1);
        if (!"mp4".equals(extension)) {
            throw new CdpException("invalid video file extension[" + extension + "]. File extension must be [mp4]");
        }
        return new CiscoOpenH264VideoRecorder(this.getThis(), options, this.loggerFactory.getLogger("cdp4j.realtimeVideoRecorder"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public EventParser getEventParser() {
        return this.eventParser;
    }

    public void setEventParser(EventParser eventParser) {
        this.eventParser = eventParser;
    }

    public String toString() {
        return "Session [sessionId=" + this.sessionId + "]";
    }

    public int getReadTimeout() {
        return this.invocationHandler.getReadTimeout();
    }

    public void setReadTimeout(int readTimeout) {
        this.invocationHandler.setReadTimeout(readTimeout);
    }
}

