/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.JsonLibrary;
import com.cdp4j.Options;
import com.cdp4j.ProtocolVersion;
import com.cdp4j.SelectorEngine;
import com.cdp4j.channel.Channel;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.DevToolsConnection;
import com.cdp4j.command.Page;
import com.cdp4j.command.Target;
import com.cdp4j.event.Events;
import com.cdp4j.event.runtime.ExecutionContextCreated;
import com.cdp4j.event.runtime.ExecutionContextDestroyed;
import com.cdp4j.event.target.TargetCreated;
import com.cdp4j.exception.CdpException;
import com.cdp4j.listener.EventListener;
import com.cdp4j.logger.CdpLogger;
import com.cdp4j.logger.CdpLoggerFactory;
import com.cdp4j.logger.CdpLoggerType;
import com.cdp4j.logger.LoggerFactory;
import com.cdp4j.serialization.GsonMapper;
import com.cdp4j.serialization.JacksonMapper;
import com.cdp4j.serialization.JsonMapper;
import com.cdp4j.session.CdpFrame;
import com.cdp4j.session.CloseListener;
import com.cdp4j.session.Command;
import com.cdp4j.session.Context;
import com.cdp4j.session.GsonMessageHandler;
import com.cdp4j.session.JacksonMessageHandler;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.Session;
import com.cdp4j.session.SessionSettings;
import com.cdp4j.session.TargetListener;
import com.cdp4j.session.UserProfileDirectoryCleaner;
import com.cdp4j.type.target.FilterEntry;
import com.cdp4j.type.target.TargetInfo;
import com.cdp4j.type.target.WindowState;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class SessionFactory
implements AutoCloseable {
    private final LoggerFactory loggerFactory;
    private final Options options;
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private final List<String> browserContexts = new CopyOnWriteArrayList<String>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private final Channel channel;
    private final JsonMapper mapper;
    private volatile String browserTargetId;
    private volatile Session browserSession;
    private volatile Boolean headless;
    private volatile int majorVersion;
    private final boolean externalProcess;
    private static String playwrightEngine;

    public SessionFactory(Options options, ChannelFactory channelFactory, Connection connection) {
        this(options, channelFactory, connection, true);
    }

    public SessionFactory(Options options, ChannelFactory channelFactory, Connection connection, boolean init) {
        this.options = options;
        this.loggerFactory = this.createLoggerFactory(options.loggerType());
        this.externalProcess = connection instanceof DevToolsConnection;
        MessageHandler handler = null;
        if (JsonLibrary.Jackson.equals((Object)options.jsonLibrary())) {
            this.mapper = new JacksonMapper();
            handler = new JacksonMessageHandler(this.mapper, this, options.workerThreadPool(), options.eventHandlerThreadPool(), this.loggerFactory.getLogger("cdp4j.ws.response"));
        } else {
            this.mapper = new GsonMapper();
            handler = new GsonMessageHandler(this.mapper, this, options.workerThreadPool(), options.eventHandlerThreadPool(), this.loggerFactory.getLogger("cdp4j.ws.response"));
        }
        this.channel = channelFactory.createChannel(connection, this, handler);
        if (init) {
            this.connect();
        }
        if (options.createNewUserDataDir()) {
            this.addCloseListener(new UserProfileDirectoryCleaner(options));
        }
    }

    public void connect() {
        if (this.browserTargetId != null) {
            throw new IllegalStateException();
        }
        this.channel.connect();
        this.initBrowserSession();
    }

    public Session create() {
        return this.create(null, null);
    }

    public Session create(SessionSettings settings) {
        return this.create(null, settings);
    }

    public Session create(String browserContextId) {
        return this.create(browserContextId, null);
    }

    public Session create(String browserContextId, SessionSettings settings) {
        String targetId;
        Session browserSession = this.getBrowserSession();
        Target target = browserSession.getCommand().getTarget();
        if ((settings == null || Boolean.TRUE.equals(settings.getReuseEmptyTab())) && this.sessions.isEmpty() && browserContextId == null && !this.options.headless() && !this.externalProcess) {
            TargetInfo blankPage = null;
            List<TargetInfo> targets = target.getTargets();
            if (targets != null) {
                for (TargetInfo next : targets) {
                    if (!this.isEmptyTarget(next)) continue;
                    blankPage = next;
                    break;
                }
            }
            if (blankPage != null) {
                return this.connect(blankPage.getTargetId(), blankPage.getBrowserContextId(), null, true, settings != null ? settings.isMultiFrameMode() : Boolean.FALSE, settings != null ? settings.getSelectorEngine() : this.options.selectorEngine());
            }
        }
        Integer left = settings != null ? settings.getScreenLeft() : null;
        Integer top = settings != null ? settings.getScreenWidth() : null;
        Integer width = settings != null ? settings.getScreenWidth() : this.options.screenWidth();
        Integer height = settings != null ? settings.getScreenHeight() : this.options.screenHeight();
        Boolean multiFrameMode = settings != null ? settings.isMultiFrameMode() : Boolean.FALSE;
        WindowState windowState = settings != null ? settings.getWindowState() : null;
        Boolean newWindow = null;
        if (left != null || top != null || width != null || height != null) {
            newWindow = true;
        }
        if (browserContextId != null && !Boolean.TRUE.equals(newWindow) && !this.windowExistsForBrowserContext(browserContextId)) {
            newWindow = true;
        }
        if ((targetId = target.createTarget("about:blank", left, top, width, height, windowState, browserContextId, false, newWindow, null, null, false)) == null) {
            throw new CdpException("Couldn't create a new session");
        }
        return this.connect(targetId, browserContextId, null, true, multiFrameMode, settings != null ? settings.getSelectorEngine() : this.options.selectorEngine());
    }

    public boolean windowExistsForBrowserContext(String browserContextId) {
        Target target = this.browserSession.getCommand().getTarget();
        LinkedList<FilterEntry> filerEntries = new LinkedList<FilterEntry>();
        FilterEntry filterEntry = new FilterEntry();
        filterEntry.setType("page");
        filterEntry.setExclude(false);
        filerEntries.add(filterEntry);
        List<TargetInfo> targetInfos = target.getTargets(filerEntries);
        if (browserContextId == null || targetInfos == null) {
            return targetInfos != null && !targetInfos.isEmpty();
        }
        for (TargetInfo targetInfo : targetInfos) {
            if (!browserContextId.equals(targetInfo.getBrowserContextId()) || !"page".equals(targetInfo.getType())) continue;
            return true;
        }
        return false;
    }

    public Session connect(String targetId) {
        return this.connect(targetId, null);
    }

    private boolean isEmptyTarget(TargetInfo targetInfo) {
        String url = targetInfo.getUrl();
        String type = targetInfo.getType();
        return "page".equals(type) && (url.isEmpty() || "about:blank".equals(url) || "chrome://welcome/".equals(url) || "chrome://newtab/".equals(url) || "edge://newtab/".equals(url) || "edge://welcome/".equals(url) || url.startsWith("chrome://welcome-win10"));
    }

    public Session connect(String targetId, String browserContextId) {
        return this.connect(targetId, browserContextId, null);
    }

    public Session connect(String targetId, String browserContextId, String sessionId) {
        return this.connect(targetId, browserContextId, sessionId, true);
    }

    public Session connect(String targetId, String browserContextId, String sessionId, boolean isPage) {
        return this.connect(targetId, browserContextId, sessionId, isPage, Boolean.FALSE);
    }

    public Session connect(String targetId, String browserContextId, String sessionId, boolean isPage, Boolean multiFrameMode) {
        return this.connect(targetId, browserContextId, sessionId, isPage, multiFrameMode, this.options.selectorEngine());
    }

    public Session connect(String targetId, String browserContextId, String sessionId, boolean isPage, Boolean multiFrameMode, SelectorEngine selectorEngine) {
        return this.connect(targetId, browserContextId, sessionId, isPage, multiFrameMode, selectorEngine, true);
    }

    public Session connect(String targetId, String browserContextId, String sessionId, boolean isPage, Boolean multiFrameMode, SelectorEngine selectorEngine, boolean initSession) {
        Session bs = this.getBrowserSession();
        if (browserContextId == null) {
            TargetInfo found = null;
            List<TargetInfo> targets = bs.getCommand().getTarget().getTargets();
            for (TargetInfo next : targets) {
                if (!next.getTargetId().equals(targetId)) continue;
                found = next;
            }
            if (found == null) {
                throw new CdpException("Target not found: " + targetId);
            }
            browserContextId = found.getBrowserContextId();
        }
        Target target = bs.getCommand().getTarget();
        if (sessionId == null) {
            sessionId = target.attachToTarget(targetId, Boolean.TRUE);
        }
        ConcurrentHashMap<Integer, Context> contexts = new ConcurrentHashMap<Integer, Context>();
        CopyOnWriteArrayList<EventListener> eventListeners = new CopyOnWriteArrayList<EventListener>();
        Session session = new Session(this.options, this.mapper, sessionId, targetId, browserContextId, this.channel, contexts, this, eventListeners, this.loggerFactory, multiFrameMode, selectorEngine != null ? selectorEngine : this.options.selectorEngine());
        this.sessions.put(sessionId, session);
        session.addEventListener((event, value) -> {
            if (Events.RuntimeExecutionContextCreated.equals((Object)event)) {
                ExecutionContextCreated ecc = (ExecutionContextCreated)value;
                String frameId = (String)ecc.getContext().getAuxData().get("frameId");
                Integer executionContextId = ecc.getContext().getId();
                if (targetId.equals(frameId)) {
                    session.setExecutionContextId(executionContextId);
                } else if (session.isMultiFrameMode().booleanValue()) {
                    CdpFrame frame = new CdpFrame(frameId, executionContextId);
                    session.addFrame(frame);
                }
            } else if (Events.RuntimeExecutionContextDestroyed.equals((Object)event)) {
                ExecutionContextDestroyed ecd = (ExecutionContextDestroyed)value;
                if (ecd.getExecutionContextId() != null && ecd.getExecutionContextId().equals(session.getExecutionContextId())) {
                    session.setExecutionContextId(null);
                } else if (session.isMultiFrameMode().booleanValue() && ecd.getExecutionContextId() != null) {
                    session.removeFrame(ecd.getExecutionContextId());
                }
            }
        });
        if (initSession) {
            this.initNewSession(session, isPage);
        }
        return session;
    }

    public void initNewSession(Session session, boolean isPage) {
        session.getCommand().getRuntime().enable();
        if (isPage) {
            Command command = session.getCommand();
            Page page = command.getPage();
            page.enable();
            page.setLifecycleEventsEnabled(true);
            if (SelectorEngine.Playwright.equals((Object)session.getSelectorEngine())) {
                ((CompletableFuture)session.getAsyncCommand().getPage().addScriptToEvaluateOnNewDocument(playwrightEngine).exceptionally(t -> {
                    this.loggerFactory.getLogger("cdp4j.playwright").error("An error occurred while loading Playwright selector engine", (Throwable)t);
                    return null;
                })).thenAccept(f -> {
                    CdpLogger log = this.loggerFactory.getLogger("cdp4j.playwright");
                    if (log.isDebugEnabled()) {
                        log.debug("Playwright selector engine loaded successfully", new Object[0]);
                    }
                });
            }
        }
    }

    private void initBrowserSession() {
        ConcurrentHashMap<Integer, Context> contexts = new ConcurrentHashMap<Integer, Context>();
        CopyOnWriteArrayList<EventListener> eventlisteners = new CopyOnWriteArrayList<EventListener>();
        this.browserSession = new Session(this.options, this.mapper, null, null, null, this.channel, contexts, this, eventlisteners, this.loggerFactory, Boolean.FALSE, SelectorEngine.Native);
        if (this.options.protocolVersion() != ProtocolVersion.V8) {
            this.browserSession.addSyncEventListener(new TargetListener(this.sessions));
            Target target = this.browserSession.getCommand().getTarget();
            this.browserSession.addSyncEventListener(new BrowserSessionListener(this));
            target.setDiscoverTargets(Boolean.TRUE);
        }
    }

    public Session getBrowserSession() {
        return this.browserSession;
    }

    public Map<String, Session> getSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    Session getSession(String sessionId) {
        return this.sessions.get(sessionId);
    }

    void close(Session session) {
        if (!session.isDisposed() && this.options.protocolVersion() != ProtocolVersion.V8) {
            session.getCommand().getPage().close();
        }
        this.remove(session);
    }

    void remove(Session session) {
        session.dispose();
        String sessionId = session.getId();
        if (sessionId != null) {
            this.sessions.remove(sessionId);
        }
    }

    public int getMajorVersion() {
        String[] version;
        String[] product;
        if (this.majorVersion == 0 && (product = this.browserSession.getCommand().getBrowser().getVersion().getProduct().split("/")).length == 2 && (version = product[1].split("\\.")).length > 2) {
            this.majorVersion = Integer.parseInt(version[0]);
        }
        return this.majorVersion;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Target target = this.browserSession.getCommand().getTarget();
            if (this.channel.isOpen() && this.browserSession != null) {
                for (String string : this.browserContexts) {
                    target.disposeBrowserContext(string);
                }
                for (TargetInfo targetInfo : target.getTargets()) {
                    if (this.browserTargetId == null || !this.browserTargetId.equals(targetInfo.getTargetId())) continue;
                    target.closeTarget(this.browserTargetId);
                    break;
                }
            }
            this.browserSession.dispose();
            this.channel.disconnect();
            for (Session session : this.sessions.values()) {
                session.dispose();
            }
            this.sessions.clear();
            this.browserContexts.clear();
            if (this.options.shutdownThreadPoolOnClose()) {
                ExecutorService eps;
                Executor executor;
                ExecutorService executorService;
                Executor wp = this.options.workerThreadPool();
                if (wp instanceof ExecutorService && !(executorService = (ExecutorService)wp).isShutdown()) {
                    executorService.shutdownNow();
                }
                if ((executor = this.options.eventHandlerThreadPool()) instanceof ExecutorService && !(eps = (ExecutorService)executor).isShutdown()) {
                    eps.shutdownNow();
                }
            }
            this.browserSession = null;
            for (CloseListener closeListener : this.closeListeners) {
                closeListener.closed();
            }
            this.closeListeners.clear();
        }
    }

    public void activate(String sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            this.browserSession.getCommand().getTarget().activateTarget(session.getTargetId());
        }
    }

    public boolean isHeadless() {
        if (this.headless == null) {
            this.headless = this.getBrowserSession().getCommand().getBrowser().getVersion().getProduct().toLowerCase(Locale.ENGLISH).contains("headless");
        }
        return this.headless;
    }

    public String createBrowserContext() {
        String browserContextId = this.getBrowserSession().getCommand().getTarget().createBrowserContext();
        this.browserContexts.add(browserContextId);
        return browserContextId;
    }

    public String createBrowserContext(String proxyServer, String proxyBypassList) {
        String browserContextId = this.getBrowserSession().getCommand().getTarget().createBrowserContext(null, proxyServer, proxyBypassList, null);
        this.browserContexts.add(browserContextId);
        return browserContextId;
    }

    public void disposeBrowserContext(String browserContextId) {
        if (this.browserContexts.contains(browserContextId)) {
            this.getBrowserSession().getCommand().getTarget().disposeBrowserContext(browserContextId);
            this.browserContexts.remove(browserContextId);
        }
    }

    public boolean closed() {
        return this.closed.get();
    }

    protected LoggerFactory createLoggerFactory(CdpLoggerType loggerType) {
        return new CdpLoggerFactory(this.options);
    }

    public boolean addCloseListener(CloseListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.closeListeners.contains(listener)) {
            return false;
        }
        return this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        return this.closeListeners.remove(listener);
    }

    public Options getOptions() {
        return this.options;
    }

    public String toString() {
        return "SessionFactory [sessions=" + this.sessions + "]";
    }

    static {
        block13: {
            playwrightEngine = "throw new Error('playwright-engine not available')";
            try (InputStream is = SessionFactory.class.getResourceAsStream("/META-INF/cdp4j-playwright-engine.js");){
                if (is == null) break block13;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                    playwrightEngine = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                }
            }
            catch (Exception e) {
                System.err.println("Could not setup playwright-engine: " + e.toString());
            }
        }
    }

    private class BrowserSessionListener
    implements EventListener {
        private final SessionFactory sessionFactory;

        private BrowserSessionListener(SessionFactory sessionFactory2) {
            this.sessionFactory = sessionFactory2;
        }

        @Override
        public void onEvent(Events event, Object value) {
            TargetCreated tc;
            TargetInfo ti;
            if (Events.TargetTargetCreated.equals((Object)event) && "browser".equalsIgnoreCase((ti = (tc = (TargetCreated)value).getTargetInfo()).getType())) {
                this.sessionFactory.browserTargetId = ti.getTargetId();
                this.sessionFactory.browserSession.removeEventEventListener(this);
            }
        }
    }
}

