/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.SelectorEngine;
import com.cdp4j.type.target.WindowState;

public class SessionSettings {
    private static final Integer DEFAULT_SCREEN_WIDTH = 1366;
    private static final Integer DEFAULT_SCREEN_HEIGHT = 768;
    private final Integer screenLeft;
    private final Integer screenTop;
    private final Integer screenWidth;
    private final Integer screenHeight;
    private final Boolean multiFrameMode;
    private final WindowState windowState;
    private final SelectorEngine selectorEngine;
    private final Boolean reuseEmptyTab;

    public static Builder builder() {
        return new Builder();
    }

    public SessionSettings() {
        this(DEFAULT_SCREEN_WIDTH, DEFAULT_SCREEN_HEIGHT);
    }

    public SessionSettings(Boolean multiFrameMode) {
        this(DEFAULT_SCREEN_WIDTH, DEFAULT_SCREEN_HEIGHT, multiFrameMode);
    }

    public SessionSettings(Integer screenWidth, Integer screenHeight) {
        this(screenWidth, screenHeight, Boolean.FALSE);
    }

    public SessionSettings(Integer screenWidth, Integer screenHeight, Boolean multiFrameMode) {
        this.screenLeft = null;
        this.screenTop = null;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.multiFrameMode = multiFrameMode;
        this.windowState = null;
        this.selectorEngine = SelectorEngine.Native;
        this.reuseEmptyTab = Boolean.TRUE;
    }

    private SessionSettings(Integer screenLeft, Integer screenTop, Integer screenWidth, Integer screenHeight, Boolean multiFrameMode, WindowState windowState, SelectorEngine selectorEngine, Boolean reuseEmptyTab) {
        this.screenLeft = screenLeft;
        this.screenTop = screenTop;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.multiFrameMode = multiFrameMode;
        this.windowState = windowState;
        this.selectorEngine = selectorEngine;
        this.reuseEmptyTab = reuseEmptyTab;
    }

    public Integer getScreenLeft() {
        return this.screenLeft;
    }

    public Integer getScreenTop() {
        return this.screenTop;
    }

    public Integer getScreenWidth() {
        return this.screenWidth;
    }

    public Integer getScreenHeight() {
        return this.screenHeight;
    }

    public Boolean isMultiFrameMode() {
        return this.multiFrameMode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public SelectorEngine getSelectorEngine() {
        return this.selectorEngine;
    }

    public Boolean getReuseEmptyTab() {
        return this.reuseEmptyTab;
    }

    public String toString() {
        return "SessionSettings [screenWidth=" + this.screenWidth + ", screenHeight=" + this.screenHeight + ", multiFrameMode=" + this.multiFrameMode + ", selectorEngine=" + (Object)((Object)this.selectorEngine) + ", reuseEmptyTab=" + this.reuseEmptyTab + "]";
    }

    public static class Builder {
        private Integer screenLeft;
        private Integer screenTop;
        private Integer screenWidth;
        private Integer screenHeight;
        private Boolean multiFrameMode;
        private WindowState windowState;
        private SelectorEngine selectorEngine;
        private Boolean reuseEmptyTab;

        private Builder() {
        }

        public Builder screenLeft(Integer screenLeft) {
            this.screenLeft = screenLeft;
            return this;
        }

        public Builder screenTop(Integer screenTop) {
            this.screenTop = screenTop;
            return this;
        }

        public Builder screenWidth(Integer screenWidth) {
            this.screenWidth = screenWidth;
            return this;
        }

        public Builder screenHeight(Integer screenHeight) {
            this.screenHeight = screenHeight;
            return this;
        }

        public Builder multiFrameMode(Boolean multiFrameMode) {
            this.multiFrameMode = multiFrameMode;
            return this;
        }

        public Builder windowState(WindowState windowState) {
            this.windowState = windowState;
            return this;
        }

        public Builder selectorEngine(SelectorEngine selectorEngine) {
            this.selectorEngine = selectorEngine;
            return this;
        }

        public Builder reuseEmptyTab(Boolean reuseEmptyTab) {
            this.reuseEmptyTab = reuseEmptyTab;
            return this;
        }

        public SessionSettings build() {
            return new SessionSettings(this.screenLeft, this.screenTop, this.screenWidth == null ? DEFAULT_SCREEN_WIDTH : this.screenWidth, this.screenHeight == null ? DEFAULT_SCREEN_HEIGHT : this.screenHeight, this.multiFrameMode == null ? Boolean.FALSE : this.multiFrameMode, this.windowState, this.selectorEngine == null ? SelectorEngine.Native : this.selectorEngine, this.reuseEmptyTab == null ? Boolean.TRUE : this.reuseEmptyTab);
        }
    }
}

