/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.type.domsnapshot.DOMNode;
import com.cdp4j.type.domsnapshot.NameValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class TreeNode {
    private static final short ELEMENT_NODE = 1;
    private static final short TEXT_NODE = 3;
    private static final Set<String> VOID_ELEMENTS = new HashSet<String>(Arrays.asList("AREA", "BASE", "BASEFONT", "BGSOUND", "BR", "COL", "COMMAND", "EMBED", "FRAME", "HR", "IMAGE", "IMG", "INPUT", "ISINDEX", "KEYGEN", "LINK", "MENUITEM", "META", "NEXTID", "PARAM", "SOURCE", "TRACK", "WBR"));
    private final DOMNode data;
    private TreeNode[] children;
    private int size;

    TreeNode(DOMNode data, int length) {
        this.data = data;
        this.children = new TreeNode[length];
    }

    TreeNode find(DOMNode node) {
        TreeNode found = null;
        if (this.data.equals(node)) {
            found = this;
        } else {
            TreeNode next;
            for (int i = 0; i < this.size && (found = (next = this.children[i]).find(node)) == null; ++i) {
            }
        }
        return found;
    }

    void add(TreeNode child) {
        if (this.size == this.children.length) {
            TreeNode[] temp = new TreeNode[this.children.length * 2];
            System.arraycopy(this.children, 0, temp, 0, this.children.length);
            this.children = temp;
        }
        this.children[this.size++] = child;
    }

    public String toString() {
        String content = "";
        String nodeName = this.data.getNodeName();
        if (nodeName.charAt(0) == '<') {
            return content;
        }
        short nodeType = this.data.getNodeType().shortValue();
        if (1 == nodeType && !nodeName.startsWith("::")) {
            content = content + "<" + nodeName;
            List<NameValue> attributes = this.data.getAttributes();
            int size = attributes.size();
            content = content + (size > 0 ? " " : "");
            for (int i = 0; i < size; ++i) {
                NameValue next = attributes.get(i);
                content = content + next.getName();
                if (next.getValue() != null && !next.getValue().trim().isEmpty()) {
                    content = content + "=\"" + next.getValue() + "\"";
                }
                if (i + 1 >= size) continue;
                content = content + " ";
            }
            content = content + ">";
        }
        if (3 == nodeType) {
            content = content + this.data.getNodeValue();
        }
        for (int i = 0; i < this.size; ++i) {
            content = content + this.children[i].toString();
        }
        if (1 == nodeType && !VOID_ELEMENTS.contains(nodeName) && !nodeName.startsWith("::")) {
            content = content + "</" + nodeName + ">";
        }
        return content;
    }
}

