/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFolderChooserUI;
import com.jidesoft.plaf.basic.LazyMutableTreeNode;
import com.jidesoft.swing.FolderChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Icon;

class BasicFileSystemTreeNode
extends LazyMutableTreeNode
implements Comparable {
    private FolderChooser _folderChooser;
    private File _file;
    static HashMap _icons = new HashMap();
    static HashMap _nodes = new HashMap();

    protected BasicFileSystemTreeNode(File file) {
        this(file, null);
    }

    protected BasicFileSystemTreeNode(File file, FolderChooser folderChooser) {
        this._file = file;
        this._folderChooser = folderChooser;
    }

    public boolean isLeaf() {
        if (!this.isLoaded()) {
            return false;
        }
        return super.isLeaf();
    }

    public boolean hasChildren() {
        if (!this._loaded) {
            if (BasicFolderChooserUI.isFileSystem(this._file) && this._file.isDirectory()) {
                File[] files;
                for (File file : files = this._folderChooser.getFileSystemView().getFiles(this._file, this._folderChooser.isFileHidingEnabled())) {
                    if (!file.isDirectory()) continue;
                    return true;
                }
                this._loaded = true;
            }
            return false;
        }
        return this.getChildCount() != 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void initChildren() {
        if (this._folderChooser == null) {
            return;
        }
        if (this._file.isDirectory()) {
            Object[] files = new File[]{};
            try {
                void var5_9;
                files = this._folderChooser.getFileSystemView().getFiles(this._file, this._folderChooser.isFileHidingEnabled());
                ArrayList<File> folders = new ArrayList<File>();
                Object[] objectArray = files;
                int n = objectArray.length;
                boolean i = false;
                while (var5_9 < n) {
                    File file = objectArray[var5_9];
                    if (file.isDirectory()) {
                        folders.add(file);
                    }
                    ++var5_9;
                }
                files = folders.toArray(new File[folders.size()]);
                Comparator<File> comparator = this._folderChooser.getFileComparator();
                if (comparator != null) {
                    Arrays.sort(files, comparator);
                } else {
                    Arrays.sort(files);
                }
            }
            catch (Error error) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (File file : files) {
                BasicFileSystemTreeNode fileTreeNode = BasicFileSystemTreeNode.createFileSystemTreeNode(file, this._folderChooser);
                this.add(fileTreeNode);
            }
        }
    }

    public File getFile() {
        return this._file;
    }

    public String getName() {
        return this.getName(this.getFile());
    }

    public Icon getIcon() {
        Icon icon = (Icon)_icons.get(this);
        if (icon == null) {
            icon = this.getIcon(this.getFile());
            _icons.put(this, icon);
            return icon;
        }
        return icon;
    }

    public String getTypeDescription() {
        String desc = this.getTypeDescription(this.getFile());
        return desc == null ? "" : desc;
    }

    public Icon getIcon(File file) {
        return this._folderChooser.getFileSystemView().getSystemIcon(file);
    }

    public String getTypeDescription(File file) {
        return this._folderChooser.getFileSystemView().getSystemTypeDescription(file);
    }

    public String getName(File file) {
        return this._folderChooser.getFileSystemView().getSystemDisplayName(file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicFileSystemTreeNode that = (BasicFileSystemTreeNode)o;
        return !(this._file == null ? that._file != null : !this._file.equals(that._file));
    }

    public int compareTo(Object o) {
        if (!(o instanceof BasicFileSystemTreeNode)) {
            return 0;
        }
        return this.getFile().compareTo(((BasicFileSystemTreeNode)o).getFile());
    }

    public int hashCode() {
        return this._file != null ? this._file.hashCode() : 0;
    }

    public boolean canEnqueue() {
        return !this.isLoaded() && !this._folderChooser.getFileSystemView().isFloppyDrive(this.getFile()) && !this._folderChooser.getFileSystemView().isFileSystemRoot(this.getFile());
    }

    public String toString() {
        return this._file != null ? this._file.toString() : "null";
    }

    public static BasicFileSystemTreeNode createFileSystemTreeNode(File file, FolderChooser folderChooser) {
        BasicFileSystemTreeNode node = (BasicFileSystemTreeNode)_nodes.get(file);
        if (node == null) {
            node = new BasicFileSystemTreeNode(file, folderChooser);
            _nodes.put(file, node);
        }
        return node;
    }

    public static void clearCache() {
        _nodes.clear();
    }
}

