/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideComboBoxButton;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.border.AbstractBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class BasicJideComboBoxUI
extends MetalComboBoxUI {
    private boolean _rollOver = false;
    protected RolloverListener _rolloverListener;

    public static BasicJideComboBoxUI createUI(JComponent c) {
        return new BasicJideComboBoxUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        JideSwingUtilities.installBorder(this.comboBox, this.createComboBoxBorder());
    }

    protected BasicJideComboBoxBorder createComboBoxBorder() {
        return new BasicJideComboBoxBorder();
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void installListeners() {
        super.installListeners();
        if (this._rolloverListener == null) {
            this._rolloverListener = this.createRolloverListener();
        }
        this.comboBox.addMouseListener(this._rolloverListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this._rolloverListener);
        this._rolloverListener = null;
    }

    protected RolloverListener createRolloverListener() {
        return new RolloverListener();
    }

    protected JButton createArrowButton() {
        BasicJideComboBoxButton button = new BasicJideComboBoxButton(this.comboBox, new BasicJideComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(1, 3, 0, 4));
        button.setFocusPainted(this.comboBox.isEditable());
        button.addMouseListener(this._rolloverListener);
        return button;
    }

    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
        this.arrowButton.removeMouseListener(this._rolloverListener);
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeMouseListener(this._rolloverListener);
        this.editor.removeFocusListener(this._rolloverListener);
    }

    public void configureEditor() {
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        this.editor.addMouseListener(this._rolloverListener);
        this.editor.addFocusListener(this._rolloverListener);
    }

    public Dimension getMinimumSize(JComponent c) {
        int buttonWidth;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        int buttonHeight = size.height;
        if (this.arrowButton instanceof BasicJideComboBoxButton) {
            Icon icon = ((BasicJideComboBoxButton)this.arrowButton).getComboIcon();
            Insets buttonInsets = this.arrowButton.getInsets();
            buttonWidth = icon.getIconWidth() + buttonInsets.left + buttonInsets.right;
        } else {
            buttonWidth = this.squareButton ? buttonHeight : this.arrowButton.getPreferredSize().width;
        }
        size.height += insets.top + insets.bottom;
        size.width += insets.left + insets.right + buttonWidth + 3;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    public void layoutComboBox(Container parent, MetalComboBoxUI.MetalComboBoxLayoutManager manager) {
        if (this.arrowButton != null) {
            if (this.arrowButton instanceof BasicJideComboBoxButton) {
                Icon icon = ((BasicJideComboBoxButton)this.arrowButton).getComboIcon();
                Insets buttonInsets = this.arrowButton.getInsets();
                int buttonWidth = icon.getIconWidth() + buttonInsets.left + buttonInsets.right;
                Insets insets = this.comboBox.getInsets();
                this.arrowButton.setBounds(this.comboBox.getComponentOrientation().isLeftToRight() ? this.comboBox.getWidth() - insets.right - buttonWidth : insets.left, insets.top, buttonWidth, this.comboBox.getHeight() - insets.top - insets.bottom);
            } else {
                Insets insets = this.comboBox.getInsets();
                int width = this.comboBox.getWidth();
                int height = this.comboBox.getHeight();
                this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
            }
        }
        if (this.editor != null) {
            Rectangle cvb = this.rectangleForCurrentValue();
            this.editor.setBounds(cvb);
        }
    }

    public boolean isRollOver() {
        return this._rollOver || (this.editor != null ? this.editor.hasFocus() : this.hasFocus);
    }

    public void setRollOver(boolean rollOver) {
        this._rollOver = rollOver;
    }

    protected class BasicJideComboBoxIcon
    implements Icon {
        protected BasicJideComboBoxIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JideSwingUtilities.paintArrow(g, c.getForeground(), x, y, 5, 0);
        }

        public int getIconWidth() {
            return 5;
        }

        public int getIconHeight() {
            return 3;
        }
    }

    protected class RolloverListener
    extends MouseAdapter
    implements FocusListener {
        protected RolloverListener() {
        }

        public void mouseEntered(MouseEvent e) {
            BasicJideComboBoxUI.this.setRollOver(true);
            BasicJideComboBoxUI.this.comboBox.repaint();
        }

        public void mouseExited(MouseEvent e) {
            if (BasicJideComboBoxUI.this.comboBox.isPopupVisible()) {
                PopupMenuListener l = new PopupMenuListener(){

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        BasicJideComboBoxUI.this.setRollOver(false);
                        ((JPopupMenu)((Object)BasicJideComboBoxUI.this.popup)).removePopupMenuListener(this);
                    }

                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                };
                ((JPopupMenu)((Object)BasicJideComboBoxUI.this.popup)).addPopupMenuListener(l);
                BasicJideComboBoxUI.this.setRollOver(true);
            } else {
                BasicJideComboBoxUI.this.setRollOver(false);
            }
            BasicJideComboBoxUI.this.comboBox.repaint();
        }

        public void focusGained(FocusEvent e) {
            BasicJideComboBoxUI.this.comboBox.repaint();
        }

        public void focusLost(FocusEvent e) {
            BasicJideComboBoxUI.this.comboBox.repaint();
        }
    }

    protected class BasicJideComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 4633179647696691207L;

        protected BasicJideComboBoxBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color old = g.getColor();
            JComboBox box = (JComboBox)c;
            if (box.isPopupVisible() || BasicJideComboBoxUI.this.isRollOver()) {
                g.setColor(UIDefaultsLookup.getColor("JideButton.borderColor"));
            } else {
                g.setColor(UIDefaultsLookup.getColor("TextField.background"));
            }
            g.drawRect(x, y, width - 1, height - 1);
            g.setColor(old);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 1;
            insets.top = 1;
            insets.right = 1;
            insets.left = 1;
            return insets;
        }
    }
}

