/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import java.io.File;
import java.util.logging.Logger;

public class OS {
    private static final Logger LOGGER = Logger.getLogger(OS.class.getName());
    public static final String OS_NAME = System.getProperty("os.name").toUpperCase();
    public static final boolean IS_MACOS = OS_NAME.indexOf("MAC") > -1;
    public static final boolean IS_WINDOWS = OS_NAME.startsWith("WINDOWS");
    public static final boolean IS_64_BIT = System.getProperty("os.arch", "") != null && System.getProperty("os.arch", "").indexOf("64") > -1;

    public static void loadLibrary(String libName) {
        LOGGER.config("libName: " + libName);
        String libraryPath = System.getProperty("webp.library.path", "");
        try {
            if (!"".contentEquals(libraryPath)) {
                String targetLibName = OS.nativeLibName(libName, true);
                LOGGER.fine("Loading " + targetLibName + " from " + libraryPath);
                File libFile = new File(libraryPath, targetLibName);
                OS.load(libFile.getAbsolutePath());
            } else {
                LOGGER.fine("Loading from system library path");
                OS.load(libName);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Loading " + libName + " failed. ", ex);
        }
    }

    private static void load(String libName) {
        LOGGER.config("libName: " + libName);
        if (libName.indexOf(File.separator) > -1) {
            System.load(libName);
        } else {
            System.loadLibrary(libName);
        }
    }

    private static String nativeLibName(String libName, boolean includeBitness) {
        libName = IS_MACOS ? "lib" + libName + ".dylib" : (IS_WINDOWS ? libName + ".dll" : "lib" + libName + ".so");
        if (includeBitness) {
            libName = (IS_64_BIT ? "x64" : "x86") + File.separator + libName;
        }
        return libName;
    }
}

