/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.OS;
import com.luciad.imageio.webp.VP8StatusCode;
import com.luciad.imageio.webp.WebPDecoderOptions;
import com.luciad.imageio.webp.WebPEncoderOptions;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public final class WebP {
    public static String version = "1.0.2";
    private static final Logger LOGGER = Logger.getLogger(WebP.class.getName());
    private static boolean NATIVE_LIBRARY_LOADED = false;

    static synchronized void loadNativeLibrary() {
        if (!NATIVE_LIBRARY_LOADED) {
            LOGGER.config("Loading native libraries");
            NATIVE_LIBRARY_LOADED = true;
            if (OS.IS_WINDOWS) {
                OS.loadLibrary("msvcr120");
            }
            OS.loadLibrary("webp-imageio");
        }
    }

    @Deprecated
    public static String[] getTempPaths() {
        return new String[0];
    }

    private WebP() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] decode(WebPDecoderOptions aOptions, byte[] aData, int aOffset, int aLength, int[] aOut) throws IOException {
        int[] pixels;
        if (aOptions == null) {
            throw new NullPointerException("Decoder options may not be null");
        }
        if (aData == null) {
            throw new NullPointerException("Input data may not be null");
        }
        if (aOffset + aLength > aData.length) {
            throw new IllegalArgumentException("Offset/length exceeds array size");
        }
        try {
            pixels = WebP.decode(aOptions.fPointer, aData, aOffset, aLength, aOut, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        }
        finally {
            aOptions.objectCanBeFinalized();
        }
        VP8StatusCode status = VP8StatusCode.getStatusCode(aOut[0]);
        switch (status) {
            case VP8_STATUS_OK: {
                break;
            }
            case VP8_STATUS_OUT_OF_MEMORY: {
                throw new OutOfMemoryError();
            }
            default: {
                throw new IOException("Decode returned code " + (Object)((Object)status));
            }
        }
        return pixels;
    }

    private static native int[] decode(long var0, byte[] var2, int var3, int var4, int[] var5, boolean var6);

    public static int[] getInfo(byte[] aData, int aOffset, int aLength) throws IOException {
        int[] out = new int[2];
        int result = WebP.getInfo(aData, aOffset, aLength, out);
        if (result == 0) {
            throw new IOException("Invalid WebP data");
        }
        return out;
    }

    private static native int getInfo(byte[] var0, int var1, int var2, int[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodeRGBA(WebPEncoderOptions aOptions, byte[] aRgbaData, int aWidth, int aHeight, int aStride) {
        try {
            byte[] byArray = WebP.encodeRGBA(aOptions.fPointer, aRgbaData, aWidth, aHeight, aStride);
            return byArray;
        }
        finally {
            aOptions.objectCanBeFinalized();
        }
    }

    private static native byte[] encodeRGBA(long var0, byte[] var2, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodeRGB(WebPEncoderOptions aOptions, byte[] aRgbaData, int aWidth, int aHeight, int aStride) {
        try {
            byte[] byArray = WebP.encodeRGB(aOptions.fPointer, aRgbaData, aWidth, aHeight, aStride);
            return byArray;
        }
        finally {
            aOptions.objectCanBeFinalized();
        }
    }

    private static native byte[] encodeRGB(long var0, byte[] var2, int var3, int var4, int var5);

    static {
        WebP.loadNativeLibrary();
    }
}

