/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp.commandline;

import com.luciad.imageio.webp.WebPWriteParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class Converter {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Provide image name as argument");
            return;
        }
        File input = new File(args[0]);
        BufferedImage image = ImageIO.read(input);
        String extension = Converter.getFileExtension(input);
        String outputFormat = args.length > 1 ? args[1] : ("WEBP".equals(extension.toUpperCase()) ? "png" : "webp");
        String inputFileName = input.getAbsolutePath();
        String outputFileName = inputFileName.substring(0, inputFileName.length() - extension.length()) + "out." + outputFormat;
        if ("webp".equals(outputFormat)) {
            FileOutputStream out = new FileOutputStream(new File(outputFileName));
            MemoryCacheImageOutputStream imageOut = new MemoryCacheImageOutputStream(out);
            ImageWriter writer = ImageIO.getImageWritersByMIMEType("image/webp").next();
            writer.setOutput(imageOut);
            WebPWriteParam writeParam = (WebPWriteParam)writer.getDefaultWriteParam();
            writeParam.setCompressionMode(2);
            writeParam.setCompressionType(writeParam.getCompressionTypes()[1]);
            writer.write(null, new IIOImage(image, null, null), writeParam);
            imageOut.close();
            out.close();
        } else {
            ImageIO.write((RenderedImage)image, outputFormat, new File(outputFileName));
        }
    }

    static String getFileExtension(File file) {
        if (file == null) {
            return "";
        }
        String name = file.getName();
        int i = name.lastIndexOf(46);
        String ext = i > 0 ? name.substring(i + 1) : "";
        return ext;
    }
}

