/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle;

import de.schlichtherle.CommandLineUtility;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.archive.tar.TarBZip2Driver;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarGZipDriver;
import de.schlichtherle.io.archive.zip.CheckedJarDriver;
import de.schlichtherle.io.archive.zip.CheckedReadOnlySfxDriver;
import de.schlichtherle.io.archive.zip.CheckedZip32Driver;
import de.schlichtherle.io.swing.tree.FileTreeModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class NZip
extends CommandLineUtility {
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private final FieldPosition fpos = new FieldPosition(0);
    static final /* synthetic */ boolean $assertionsDisabled;

    public NZip() {
    }

    public NZip(OutputStream outputStream, OutputStream outputStream2, boolean bl) {
        super(outputStream, outputStream2, bl);
    }

    protected DefaultArchiveDetector createDefaultArchiveDetector() {
        return new DefaultArchiveDetector(ArchiveDetector.ALL, new Object[]{"ear|jar|war", new CheckedJarDriver(), "zip", new CheckedZip32Driver(), "exe", new CheckedReadOnlySfxDriver()});
    }

    protected DefaultArchiveDetector createDefaultArchiveDetector(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        return new DefaultArchiveDetector(ArchiveDetector.ALL, new Object[]{"ear|jar|war|zip", new CheckedZip32Driver(string), "exe", new CheckedReadOnlySfxDriver(string), "tar", new TarDriver(string), "tgz|tar.gz", new TarGZipDriver(string), "tbz|tar.bz2", new TarBZip2Driver(string)});
    }

    public static void main(String[] stringArray) {
        System.exit(new NZip().run(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runWithException(String[] stringArray) throws IllegalUsageException, IOException {
        block25: {
            if (stringArray.length < 1) {
                throw new IllegalUsageException();
            }
            String string = stringArray[0].toLowerCase(Locale.ENGLISH);
            stringArray = NZip.lshift(stringArray);
            ArchiveDetector archiveDetector = File.getDefaultArchiveDetector();
            try {
                File.setDefaultArchiveDetector(this.createDefaultArchiveDetector());
                if ("ls".equals(string)) {
                    this.ls(stringArray, false, false);
                    break block25;
                }
                if ("ll".equals(string)) {
                    this.ls(stringArray, true, false);
                    break block25;
                }
                if ("llr".equals(string)) {
                    this.ls(stringArray, true, true);
                    break block25;
                }
                if ("cat".equals(string)) {
                    this.cat(stringArray);
                    break block25;
                }
                if ("cp".equals(string)) {
                    this.cpOrMv(stringArray, false);
                    break block25;
                }
                if ("mv".equals(string)) {
                    this.cpOrMv(stringArray, true);
                    break block25;
                }
                if ("touch".equals(string)) {
                    this.touch(stringArray);
                    break block25;
                }
                if ("mkdir".equals(string)) {
                    this.mkdir(stringArray, false);
                    break block25;
                }
                if ("mkdirs".equals(string)) {
                    this.mkdir(stringArray, true);
                    break block25;
                }
                if ("rm".equals(string)) {
                    this.rm(stringArray, false);
                    break block25;
                }
                if ("rmr".equals(string)) {
                    this.rm(stringArray, true);
                    break block25;
                }
                if ("isarchive".equals(string)) {
                    boolean bl = this.isArchive(stringArray);
                    return bl;
                }
                if ("isdirectory".equals(string)) {
                    boolean bl = this.isDirectory(stringArray);
                    return bl;
                }
                if ("isfile".equals(string)) {
                    boolean bl = this.isFile(stringArray);
                    return bl;
                }
                if ("exists".equals(string)) {
                    boolean bl = this.exists(stringArray);
                    return bl;
                }
                if ("length".equals(string)) {
                    boolean bl = this.length(stringArray);
                    return bl;
                }
                throw new IllegalUsageException();
            }
            finally {
                File.setDefaultArchiveDetector(archiveDetector);
            }
        }
        return true;
    }

    private static final String[] lshift(String[] stringArray) {
        return NZip.lshift(stringArray, 1);
    }

    private static String[] lshift(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    private void ls(String[] stringArray, boolean bl, boolean bl2) throws IOException {
        if (stringArray.length <= 0) {
            stringArray = new String[]{"."};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (stringArray.length > 1) {
                this.out.println(stringArray[i] + ":");
            }
            if (file.isDirectory()) {
                this.ls(file, "", bl, bl2);
                continue;
            }
            this.ls(file, file.getPath(), bl, bl2);
        }
    }

    private void ls(java.io.File file, String string, boolean bl, boolean bl2) throws IOException {
        if (file.isDirectory()) {
            java.io.File[] fileArray = file.listFiles();
            if (fileArray == null) {
                throw new IOException(string + " (directory is inaccessible)");
            }
            Arrays.sort(fileArray, FileTreeModel.FILE_NAME_COMPARATOR);
            for (int i = 0; i < fileArray.length; ++i) {
                java.io.File file2 = fileArray[i];
                String string2 = string.length() > 0 ? string + File.separator + file2.getName() : file2.getName();
                this.ls(file2, string2, bl);
                if (!bl2 || !file2.isDirectory()) continue;
                this.ls(fileArray[i], string2, bl, true);
            }
        } else if (file.exists()) {
            this.ls(file, string, bl);
        } else {
            throw new IOException(string + " (no such file or directory)");
        }
    }

    private void ls(java.io.File file, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            this.align(stringBuffer, file.length(), 11);
            stringBuffer.append(' ');
            stringBuffer.append(this.dateFormat.format(new Date(file.lastModified())));
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(file.isDirectory() ? File.separator : (file.isFile() ? "" : "?"));
        }
        this.out.println(stringBuffer.toString());
    }

    private void align(StringBuffer stringBuffer, long l, int n) {
        int n2 = stringBuffer.length();
        this.numberFormat.format(l, stringBuffer, this.fpos);
        int n3 = n - this.fpos.getEndIndex();
        while (--n3 >= 0) {
            stringBuffer.insert(n2, ' ');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cat(String[] stringArray) throws IOException {
        if (stringArray.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
            try {
                File.cat(fileInputStream, this.out);
                continue;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private void cpOrMv(String[] stringArray, boolean bl) throws IOException {
        Object object;
        int n;
        if (stringArray.length < 2) {
            throw new IllegalUsageException();
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            if (bl) {
                throw new IllegalUsageException();
            }
            object = stringArray[n].toLowerCase(Locale.ENGLISH);
            if ("-unzip".equals(object)) {
                bl2 = true;
                ++n3;
                continue;
            }
            if ("-cp437out".equals(object)) {
                bl3 = true;
                ++n3;
                continue;
            }
            if ("-utf8out".equals(object)) {
                bl4 = true;
                ++n3;
                continue;
            }
            if ("-cp437in".equals(object)) {
                bl5 = true;
                ++n2;
                continue;
            }
            if ("-utf8in".equals(object)) {
                bl6 = true;
                ++n2;
                continue;
            }
            throw new IllegalUsageException();
        }
        if (n2 > 1 || n3 > 1) {
            throw new IllegalUsageException();
        }
        object = bl5 ? this.createDefaultArchiveDetector("IBM437") : (bl6 ? this.createDefaultArchiveDetector("UTF-8") : File.getDefaultArchiveDetector());
        ArchiveDetector archiveDetector = bl2 ? ArchiveDetector.NULL : (bl3 ? this.createDefaultArchiveDetector("IBM437") : (bl4 ? this.createDefaultArchiveDetector("UTF-8") : File.getDefaultArchiveDetector()));
        int n4 = stringArray.length - 1;
        File file = new File(stringArray[n4], archiveDetector);
        if (n4 - n < 1 || n4 - n > 1 && !file.isArchive() && !file.isDirectory()) {
            throw new IllegalUsageException();
        }
        if (file.isArchive() || file.isEntry()) {
            this.progressMonitor.start();
        }
        for (int i = n; i < n4; ++i) {
            File file2 = new File(stringArray[i], (ArchiveDetector)object);
            File file3 = n4 - n > 1 || file.isDirectory() ? new File((java.io.File)file, file2.getName(), archiveDetector) : file;
            if (bl) {
                if ((!file3.isFile() || file3.delete()) && file2.renameTo(file3)) continue;
                throw new IOException(file2 + ": cannot move to: " + file3);
            }
            if (file2.archiveCopyAllTo(file3, (ArchiveDetector)object, archiveDetector)) continue;
            throw new IOException(file2 + ": cannot copy to: " + file3 + " (check output)");
        }
    }

    private void touch(String[] stringArray) throws IOException {
        if (stringArray.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            boolean bl = !file.exists() ? file.createNewFile() : file.setLastModified(System.currentTimeMillis());
            if (bl) continue;
            String string = !file.exists() ? "cannot create file" : (file.isDirectory() ? "cannot update last modification time of directory" : (file.isFile() ? "cannot update last modification time of file" : "cannot update last modification time of special file or directory"));
            throw new IOException(file.getPath() + " (" + string + ")");
        }
    }

    private void mkdir(String[] stringArray, boolean bl) throws IOException {
        if (stringArray.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2;
            File file = new File(stringArray[i]);
            boolean bl3 = bl2 = bl ? file.mkdirs() : file.mkdir();
            if (bl2) continue;
            String string = !file.exists() ? "cannot create directory" : (file.isDirectory() ? "directory exists already" : (file.isFile() ? "file exists already" : "special file or directory exists already"));
            throw new IOException(file.getPath() + " (" + string + ")");
        }
    }

    private void rm(String[] stringArray, boolean bl) throws IOException {
        if (stringArray.length < 1) {
            throw new IllegalUsageException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2;
            File file = new File(stringArray[i]);
            boolean bl3 = bl2 = bl ? file.deleteAll() : file.delete();
            if (bl2) continue;
            String string = !file.exists() ? "no such file or directory" : (file.isDirectory() ? (file.list().length > 0 ? "directory not empty" : "cannot remove directory") : (file.isFile() ? "cannot remove file" : "cannot remove special file or directory"));
            throw new IOException(file.getPath() + " (" + string + ")");
        }
    }

    private boolean isArchive(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new IllegalUsageException();
        }
        boolean bl = new File(stringArray[0]).isArchive();
        this.out.println(bl);
        return bl;
    }

    private boolean isDirectory(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new IllegalUsageException();
        }
        boolean bl = new File(stringArray[0]).isDirectory();
        this.out.println(bl);
        return bl;
    }

    private boolean isFile(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new IllegalUsageException();
        }
        boolean bl = new File(stringArray[0]).isFile();
        this.out.println(bl);
        return bl;
    }

    private boolean exists(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new IllegalUsageException();
        }
        boolean bl = new File(stringArray[0]).exists();
        this.out.println(bl);
        return bl;
    }

    private boolean length(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new IllegalUsageException();
        }
        long l = new File(stringArray[0]).length();
        this.out.println(l);
        return true;
    }

    static {
        $assertionsDisabled = !NZip.class.desiredAssertionStatus();
    }

    public class IllegalUsageException
    extends CommandLineUtility.IllegalUsageException {
        private IllegalUsageException() {
            super("@banner@\n\nUsage: " + NZip.this.getClass().getName() + " COMMAND ...\n\n" + "where COMMAND is one of (case is ignored):\n\n" + "\tls [PATH] ...\t\tSimilar to GNU \"ls\"\n" + "\tll [PATH] ...\t\tSimilar to GNU \"ls -l\"\n" + "\tllR [PATH] ...\t\tSimilar to GNU \"ls -lR\"\n" + "\tcat FILE ...\t\tLike GNU \"cat\"\n" + "\tcp [-unzip|-cp437in|-utf8in|-cp437out|-utf8out] SRC ... DST\tSimilar to GNU \"cp -a\"\n" + "\tmv SRC ... DST\t\tLike GNU \"mv\"\n" + "\ttouch PATH ...\t\tLike GNU \"touch\"\n" + "\tmkdir PATH ...\t\tLike GNU \"mkdir\"\n" + "\tmkdirs PATH ...\t\tSimilar to GNU \"mkdir -p\"\n" + "\trm PATH ...\t\tLike GNU \"rm\"\n" + "\trmR PATH ...\t\tLike GNU \"rm -r\"\n" + "\tisArchive PATH\t\tTests if PATH names an archive file\n" + "\tisDirectory PATH\tTests if PATH really is a directory or archive file\n" + "\tisFile PATH\t\tTests if PATH really is a file\n" + "\texists PATH\t\tTests if PATH really exists\n\n" + "\tlength PATH\t\tPrints length of PATH\n\n" + "For more information please refer to the respective Unix man pages.\n\n" + "Options (case is ignored):\n\n" + "\t-unzip\t\tTreat any ZIP like pathnames in DST as plain directories.\n" + "\t-cp437(in|out)\tForce any ZIP entry names in SRC/DST to be encoded in CP437.\n" + "\t-utf8(in|out)\tForce any ZIP entry names in SRC/DST to be encoded in UTF-8.\n" + "");
        }
    }
}

