/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveBusyException;
import de.schlichtherle.io.ArchiveControllers;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveFileSystem;
import de.schlichtherle.io.Entry;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.IORunnable;
import de.schlichtherle.io.ReentrantLock;
import de.schlichtherle.io.ReentrantReadWriteLock;
import de.schlichtherle.io.Streams;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.TransientIOException;
import de.schlichtherle.key.PromptingKeyManager;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import javax.swing.Icon;

abstract class ArchiveController
implements Archive,
Entry {
    private final WeakReference weakThis = new WeakReference<ArchiveController>(this);
    private final java.io.File target;
    private final ArchiveController enclController;
    private final String enclEntryName;
    private ArchiveDriver driver;
    private final ReentrantLock readLock;
    private final ReentrantLock writeLock;
    static final /* synthetic */ boolean $assertionsDisabled;

    ArchiveController(java.io.File file, ArchiveController archiveController, String string, ArchiveDriver archiveDriver) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !file.isAbsolute()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveController != null != (string != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriver == null) {
            throw new AssertionError();
        }
        this.target = file;
        this.enclController = archiveController;
        this.enclEntryName = string;
        this.driver = archiveDriver;
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
        this.setScheduled(false);
    }

    final ReentrantLock readLock() {
        return this.readLock;
    }

    final ReentrantLock writeLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWriteLocked(IORunnable iORunnable) throws IOException {
        int n;
        int n2;
        for (n2 = n = this.readLock().lockCount(); n2 > 0; --n2) {
            this.readLock().unlock();
        }
        this.writeLock().lock();
        try {
            try {
                iORunnable.run();
            }
            finally {
                for (n2 = n; n2 > 0; --n2) {
                    this.readLock().lock();
                }
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final java.io.File getTarget() {
        return this.target;
    }

    public final String getPath() {
        return this.target.getPath();
    }

    static final boolean isRoot(String string) {
        return "" == string;
    }

    final ArchiveController getEnclController() {
        return this.enclController;
    }

    final String getEnclEntryName() {
        return this.enclEntryName;
    }

    final String enclEntryName(String string) {
        return ArchiveController.isRoot(string) ? this.enclEntryName : this.enclEntryName + "/" + string;
    }

    private final boolean isEnclosedBy(ArchiveController archiveController) {
        if (!$assertionsDisabled && archiveController == null) {
            throw new AssertionError();
        }
        if (this.enclController == archiveController) {
            return true;
        }
        if (this.enclController == null) {
            return false;
        }
        return this.enclController.isEnclosedBy(archiveController);
    }

    final ArchiveDriver getDriver() {
        return this.driver;
    }

    final void setDriver(ArchiveDriver archiveDriver) {
        this.driver = archiveDriver;
    }

    final boolean isRfsEntryTarget() {
        return this.enclController == null || this.enclController.getTarget().isDirectory();
    }

    abstract boolean isTouched();

    final void setScheduled(boolean bl) {
        if (!$assertionsDisabled && this.weakThis.get() == null && bl) {
            throw new AssertionError();
        }
        ArchiveControllers.set(this.getTarget(), bl ? this : this.weakThis);
    }

    abstract boolean hasNewData(String var1);

    abstract ArchiveFileSystem autoMount(boolean var1) throws IOException;

    final void autoUmount(String string) throws ArchiveException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (this.hasNewData(string)) {
            this.umount(null, true, false, true, false, false, false);
        }
    }

    abstract void umount(ArchiveException var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7) throws ArchiveException;

    abstract int waitAllInputStreamsByOtherThreads(long var1);

    abstract int waitAllOutputStreamsByOtherThreads(long var1);

    abstract void reset() throws IOException;

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "(" + this.getPath() + ")";
    }

    final InputStream createInputStream(String string) throws FileNotFoundException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        try {
            return this.createInputStream0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.createInputStream(this.enclEntryName(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (ArchiveBusyException archiveBusyException) {
            throw new FileBusyException(archiveBusyException);
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(iOException.toString());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream createInputStream0(final String string) throws IOException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.readLock().lock();
        try {
            ArchiveEntry archiveEntry;
            if (ArchiveController.isRoot(string)) {
                block10: {
                    try {
                        boolean bl = this.isDirectory0(string);
                        if (!$assertionsDisabled && !bl) {
                            throw new AssertionError((Object)"The root entry must be a directory!");
                        }
                    }
                    catch (FalsePositiveException falsePositiveException) {
                        if (falsePositiveException.getCause() instanceof FileNotFoundException) break block10;
                        throw falsePositiveException;
                    }
                }
                throw new ArchiveEntryNotFoundException(string, "cannot read (potential) virtual root directory");
            }
            if (this.hasNewData(string)) {
                this.runWriteLocked(new IORunnable(){

                    public void run() throws IOException {
                        ArchiveController.this.autoUmount(string);
                    }
                });
            }
            if ((archiveEntry = this.autoMount(false).get(string)) == null) {
                throw new ArchiveEntryNotFoundException(string, "no such file entry");
            }
            InputStream inputStream = this.createInputStream(archiveEntry, null);
            return inputStream;
        }
        finally {
            this.readLock().unlock();
        }
    }

    abstract InputStream createInputStream(ArchiveEntry var1, ArchiveEntry var2) throws IOException;

    final OutputStream createOutputStream(String string, boolean bl) throws FileNotFoundException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        try {
            return this.createOutputStream0(string, bl);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.createOutputStream(this.enclEntryName(string), bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (ArchiveBusyException archiveBusyException) {
            throw new FileBusyException(archiveBusyException);
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(iOException.toString());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream createOutputStream0(String string, boolean bl) throws IOException {
        OutputStream outputStream;
        InputStream inputStream;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.writeLock().lock();
        try {
            if (ArchiveController.isRoot(string)) {
                block12: {
                    try {
                        boolean bl2 = this.isDirectory0(string);
                        if (!$assertionsDisabled && !bl2) {
                            throw new AssertionError((Object)"The root entry must be a directory!");
                        }
                    }
                    catch (FalsePositiveException falsePositiveException) {
                        if (falsePositiveException.getCause() instanceof FileNotFoundException) break block12;
                        throw falsePositiveException;
                    }
                }
                throw new ArchiveEntryNotFoundException(string, "cannot write (potential) virtual root directory");
            }
            this.autoUmount(string);
            boolean bl3 = File.isLenient();
            ArchiveFileSystem archiveFileSystem = this.autoMount(bl3);
            inputStream = bl && archiveFileSystem.isFile(string) ? this.createInputStream0(string) : null;
            ArchiveFileSystem.Delta delta = archiveFileSystem.link(string, bl3);
            outputStream = this.createOutputStream(delta.getEntry(), null);
            delta.commit();
        }
        finally {
            this.writeLock().unlock();
        }
        if (inputStream != null) {
            try {
                Streams.cat(inputStream, outputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return outputStream;
    }

    abstract OutputStream createOutputStream(ArchiveEntry var1, ArchiveEntry var2) throws IOException;

    final boolean exists(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.exists0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.exists(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean exists0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            boolean bl = archiveFileSystem.exists(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean isFile(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.isFile0(string);
        }
        catch (FileArchiveEntryFalsePositiveException fileArchiveEntryFalsePositiveException) {
            if (ArchiveController.isRoot(string) && fileArchiveEntryFalsePositiveException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.enclController.isFile(this.enclEntryName(string));
        }
        catch (DirectoryArchiveEntryFalsePositiveException directoryArchiveEntryFalsePositiveException) {
            return this.enclController.isFile(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isFile0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            boolean bl = archiveFileSystem.isFile(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean isDirectory(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.isDirectory0(string);
        }
        catch (FileArchiveEntryFalsePositiveException fileArchiveEntryFalsePositiveException) {
            return false;
        }
        catch (DirectoryArchiveEntryFalsePositiveException directoryArchiveEntryFalsePositiveException) {
            return this.enclController.isDirectory(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isDirectory0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            boolean bl = archiveFileSystem.isDirectory(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final Icon getOpenIcon(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.getOpenIcon0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.getOpenIcon(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Icon getOpenIcon0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            Icon icon = ArchiveController.isRoot(string) ? this.getDriver().getOpenIcon(this) : archiveFileSystem.getOpenIcon(string);
            return icon;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final Icon getClosedIcon(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.getClosedIcon0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.getOpenIcon(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Icon getClosedIcon0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            Icon icon = ArchiveController.isRoot(string) ? this.getDriver().getClosedIcon(this) : archiveFileSystem.getClosedIcon(string);
            return icon;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean canRead(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.canRead0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.canRead(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean canRead0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            boolean bl = archiveFileSystem.exists(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean canWrite(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.canWrite0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.canWrite(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean canWrite0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            boolean bl = archiveFileSystem.canWrite(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final long length(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.length0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.length(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long length0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            long l = archiveFileSystem.length(string);
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final long lastModified(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.lastModified0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.lastModified(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long lastModified0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            long l = archiveFileSystem.lastModified(string);
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final String[] list(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.list0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.list(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] list0(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            String[] stringArray = archiveFileSystem.list(string);
            return stringArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final String[] list(String string, FilenameFilter filenameFilter, File file) throws RfsEntryFalsePositiveException {
        try {
            return this.list0(string, filenameFilter, file);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.list(this.enclEntryName(string), filenameFilter, file);
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] list0(String string, FilenameFilter filenameFilter, File file) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            String[] stringArray = archiveFileSystem.list(string, filenameFilter, file);
            return stringArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final File[] listFiles(String string, FilenameFilter filenameFilter, File file, FileFactory fileFactory) throws RfsEntryFalsePositiveException {
        try {
            return this.listFiles0(string, filenameFilter, file, fileFactory);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.listFiles(this.enclEntryName(string), filenameFilter, file, fileFactory);
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] listFiles0(String string, FilenameFilter filenameFilter, File file, FileFactory fileFactory) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            File[] fileArray = archiveFileSystem.listFiles(string, filenameFilter, file, fileFactory);
            return fileArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final File[] listFiles(String string, FileFilter fileFilter, File file, FileFactory fileFactory) throws RfsEntryFalsePositiveException {
        try {
            return this.listFiles0(string, fileFilter, file, fileFactory);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.listFiles(this.enclEntryName(string), fileFilter, file, fileFactory);
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] listFiles0(String string, FileFilter fileFilter, File file, FileFactory fileFactory) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            File[] fileArray = archiveFileSystem.listFiles(string, fileFilter, file, fileFactory);
            return fileArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean setReadOnly(String string) throws RfsEntryFalsePositiveException {
        try {
            return this.setReadOnly0(string);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.setReadOnly(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean setReadOnly0(String string) throws IOException {
        this.writeLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            boolean bl = archiveFileSystem.setReadOnly(string);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean setLastModified(String string, long l) throws RfsEntryFalsePositiveException {
        try {
            return this.setLastModified0(string, l);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.setLastModified(this.enclEntryName(string), l);
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean setLastModified0(String string, long l) throws IOException {
        this.writeLock().lock();
        try {
            this.autoUmount(string);
            ArchiveFileSystem archiveFileSystem = this.autoMount(false);
            boolean bl = archiveFileSystem.setLastModified(string, l);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean createNewFile(String string, boolean bl) throws IOException {
        try {
            return this.createNewFile0(string, bl);
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.createNewFile(this.enclEntryName(string), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean createNewFile0(String string, boolean bl) throws IOException {
        if (!$assertionsDisabled && ArchiveController.isRoot(string)) {
            throw new AssertionError();
        }
        this.writeLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.autoMount(bl);
            if (archiveFileSystem.exists(string)) {
                boolean bl2 = false;
                return bl2;
            }
            this.createOutputStream0(string, false).close();
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean mkdir(String string, boolean bl) throws RfsEntryFalsePositiveException {
        try {
            this.mkdir0(string, bl);
            return true;
        }
        catch (ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            return this.enclController.mkdir(this.enclEntryName(string), bl);
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mkdir0(String string, boolean bl) throws IOException {
        this.writeLock().lock();
        try {
            if (ArchiveController.isRoot(string)) {
                if (this.isRfsEntryTarget() ? this.target.exists() : this.enclController.exists(this.enclEntryName)) {
                    throw new IOException("target file exists already!");
                }
                this.autoMount(true);
            } else {
                ArchiveFileSystem archiveFileSystem = this.autoMount(bl);
                archiveFileSystem.mkdir(string, bl);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean delete(String string) throws RfsEntryFalsePositiveException {
        try {
            this.delete0(string);
            return true;
        }
        catch (DirectoryArchiveEntryFalsePositiveException directoryArchiveEntryFalsePositiveException) {
            return this.enclController.delete(this.enclEntryName(string));
        }
        catch (FileArchiveEntryFalsePositiveException fileArchiveEntryFalsePositiveException) {
            if (ArchiveController.isRoot(string) && !this.enclController.isDirectory(this.enclEntryName(string)) && fileArchiveEntryFalsePositiveException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.enclController.delete(this.enclEntryName(string));
        }
        catch (RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            throw rfsEntryFalsePositiveException;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void delete0(String string) throws IOException {
        block14: {
            this.writeLock().lock();
            try {
                this.autoUmount(string);
                if (ArchiveController.isRoot(string)) {
                    ArchiveFileSystem archiveFileSystem;
                    try {
                        archiveFileSystem = this.autoMount(false);
                    }
                    catch (FalsePositiveException falsePositiveException) {
                        try {
                            this.reset();
                        }
                        catch (IOException iOException) {
                            throw new AssertionError((Object)iOException);
                        }
                        throw falsePositiveException;
                    }
                    String[] stringArray = archiveFileSystem.list(string);
                    if (stringArray != null && stringArray.length != 0) {
                        throw new IOException("archive file system not empty!");
                    }
                    int n = this.waitAllOutputStreamsByOtherThreads(50L);
                    if (!$assertionsDisabled && n > 0) {
                        throw new AssertionError((Object)"Entries for open output streams should not be deletable!");
                    }
                    int n2 = this.waitAllInputStreamsByOtherThreads(50L);
                    if (n2 > 0 || n > 0) {
                        throw new IOException("archive file has open streams!");
                    }
                    this.reset();
                    PromptingKeyManager.resetKeyProvider(this.getPath());
                    if (this.isRfsEntryTarget()) {
                        if (!this.target.delete()) {
                            throw new IOException("couldn't delete archive file!");
                        }
                    } else {
                        this.enclController.delete0(this.enclEntryName(string));
                    }
                    break block14;
                }
                ArchiveFileSystem archiveFileSystem = this.autoMount(false);
                archiveFileSystem.delete(string);
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }

    static {
        $assertionsDisabled = !ArchiveController.class.desiredAssertionStatus();
    }

    final class ArchiveEntryNotFoundException
    extends FileNotFoundException {
        private final String entryName;
        static final /* synthetic */ boolean $assertionsDisabled;

        ArchiveEntryNotFoundException(String string, String string2) {
            super(string2);
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && string2 == null) {
                throw new AssertionError();
            }
            this.entryName = string;
        }

        public String getMessage() {
            String string;
            String string2 = ArchiveController.this.getPath();
            if (!ArchiveController.isRoot(this.entryName)) {
                string2 = string2 + File.separator + this.entryName.replace('/', File.separatorChar);
            }
            if ((string = super.getMessage()) != null) {
                string2 = string2 + " (" + string + ")";
            }
            return string2;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveController == null ? (class$de$schlichtherle$io$ArchiveController = ArchiveController.class$("de.schlichtherle.io.ArchiveController")) : class$de$schlichtherle$io$ArchiveController).desiredAssertionStatus();
        }
    }

    final class ArchiveFileNotFoundException
    extends FileNotFoundException {
        ArchiveFileNotFoundException(String string) {
            super(string);
        }

        public String getMessage() {
            String string = super.getMessage();
            if (string != null) {
                return ArchiveController.this.getPath() + " (" + string + ")";
            }
            return ArchiveController.this.getPath();
        }
    }

    final class DirectoryArchiveEntryFalsePositiveException
    extends ArchiveEntryFalsePositiveException {
        DirectoryArchiveEntryFalsePositiveException(ArchiveController archiveController2, String string, IOException iOException) {
            super(archiveController2, string, iOException);
        }
    }

    final class FileArchiveEntryFalsePositiveException
    extends ArchiveEntryFalsePositiveException {
        FileArchiveEntryFalsePositiveException(ArchiveController archiveController2, String string, IOException iOException) {
            super(archiveController2, string, iOException);
        }
    }

    abstract class ArchiveEntryFalsePositiveException
    extends FalsePositiveException {
        private final ArchiveController enclController;
        private final String enclEntryName;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ArchiveEntryFalsePositiveException(ArchiveController archiveController2, String string, IOException iOException) {
            super(iOException);
            if (!$assertionsDisabled && archiveController2 == ArchiveController.this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !ArchiveController.this.isEnclosedBy(archiveController2)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            this.enclController = archiveController2;
            this.enclEntryName = string;
        }

        ArchiveController getEnclController() {
            return this.enclController;
        }

        String getEnclEntryName() {
            return this.enclEntryName;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveController == null ? (class$de$schlichtherle$io$ArchiveController = ArchiveController.class$("de.schlichtherle.io.ArchiveController")) : class$de$schlichtherle$io$ArchiveController).desiredAssertionStatus();
        }
    }

    final class RfsEntryFalsePositiveException
    extends FalsePositiveException {
        RfsEntryFalsePositiveException(IOException iOException) {
            super(iOException);
        }
    }

    abstract class FalsePositiveException
    extends FileNotFoundException {
        private final boolean cacheable;
        static final /* synthetic */ boolean $assertionsDisabled;

        private FalsePositiveException(IOException iOException) {
            if (!$assertionsDisabled && iOException == null) {
                throw new AssertionError();
            }
            boolean bl = iOException instanceof TransientIOException;
            super.initCause(bl ? iOException.getCause() : iOException);
            this.cacheable = !bl;
        }

        ArchiveController getController() {
            return ArchiveController.this;
        }

        boolean isCacheable() {
            return this.cacheable;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveController == null ? (class$de$schlichtherle$io$ArchiveController = ArchiveController.class$("de.schlichtherle.io.ArchiveController")) : class$de$schlichtherle$io$ArchiveController).desiredAssertionStatus();
        }
    }
}

