/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryStreamClosedException;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.util.SynchronizedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InputArchiveMetaData {
    private static final String CLASS_NAME;
    private static final Logger logger;
    private final Archive archive;
    private final InputArchive inArchive;
    private final Map streams;
    private volatile boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;

    InputArchiveMetaData(Archive archive, InputArchive inputArchive) {
        AbstractMap abstractMap = this.streams = File.isLenient() ? new WeakHashMap() : new HashMap();
        if (!$assertionsDisabled && inputArchive == null) {
            throw new AssertionError();
        }
        this.archive = archive;
        this.inArchive = inputArchive;
    }

    synchronized InputStream createInputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveEntry == null) {
            throw new AssertionError();
        }
        InputStream inputStream = this.inArchive.getInputStream(archiveEntry, archiveEntry2);
        return inputStream != null ? new EntryInputStream(inputStream) : null;
    }

    synchronized int waitAllInputStreamsByOtherThreads(long l) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        long l2 = System.currentTimeMillis();
        int n = this.threadStreams();
        try {
            while (this.streams.size() > n) {
                long l3;
                if (l > 0L) {
                    l3 = l - (System.currentTimeMillis() - l2);
                    if (l3 <= 0L) {
                        break;
                    }
                } else {
                    l3 = 0L;
                }
                if (File.isLenient()) {
                    System.gc();
                    System.runFinalization();
                }
                this.wait(l3);
            }
        }
        catch (InterruptedException interruptedException) {
            logger.warning("interrupted");
        }
        return this.streams.size();
    }

    private int threadStreams() {
        Thread thread = Thread.currentThread();
        int n = 0;
        Iterator iterator = this.streams.values().iterator();
        while (iterator.hasNext()) {
            Thread thread2 = (Thread)iterator.next();
            if (thread != thread2) continue;
            ++n;
        }
        return n;
    }

    synchronized ArchiveException closeAllInputStreams(ArchiveException archiveException) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        this.stopped = true;
        Iterator iterator = this.streams.keySet().iterator();
        while (iterator.hasNext()) {
            EntryInputStream entryInputStream = (EntryInputStream)iterator.next();
            try {
                entryInputStream.doClose();
            }
            catch (IOException iOException) {
                archiveException = new ArchiveWarningException(archiveException, iOException);
            }
        }
        this.streams.clear();
        return archiveException;
    }

    static {
        $assertionsDisabled = !InputArchiveMetaData.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/InputArchiveMetaData".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    }

    private final class EntryInputStream
    extends SynchronizedInputStream {
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        private EntryInputStream(InputStream inputStream) {
            super(inputStream, InputArchiveMetaData.this);
            if (!$assertionsDisabled && inputStream == null) {
                throw new AssertionError();
            }
            InputArchiveMetaData.this.streams.put(this, Thread.currentThread());
            InputArchiveMetaData.this.notify();
        }

        private final void ensureNotStopped() throws IOException {
            if (InputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        public int read() throws IOException {
            this.ensureNotStopped();
            return super.read();
        }

        public int read(byte[] byArray) throws IOException {
            this.ensureNotStopped();
            return super.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.ensureNotStopped();
            return super.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            this.ensureNotStopped();
            return super.skip(l);
        }

        public int available() throws IOException {
            this.ensureNotStopped();
            return super.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            if (!$assertionsDisabled && InputArchiveMetaData.this != this.lock) {
                throw new AssertionError();
            }
            InputArchiveMetaData inputArchiveMetaData = InputArchiveMetaData.this;
            synchronized (inputArchiveMetaData) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doClose();
                }
                finally {
                    InputArchiveMetaData.this.streams.remove(this);
                    InputArchiveMetaData.this.notify();
                }
            }
        }

        protected void doClose() throws IOException {
            if (!$assertionsDisabled && this.closed) {
                throw new AssertionError();
            }
            this.closed = true;
            super.doClose();
        }

        public void mark(int n) {
            if (!InputArchiveMetaData.this.stopped) {
                super.mark(n);
            }
        }

        public void reset() throws IOException {
            this.ensureNotStopped();
            super.reset();
        }

        public boolean markSupported() {
            return !InputArchiveMetaData.this.stopped && super.markSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.closed) {
                    return;
                }
                logger.finer("finalize.open");
                try {
                    this.doClose();
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "finalize.exception", iOException);
                }
            }
            finally {
                super.finalize();
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$InputArchiveMetaData == null ? (class$de$schlichtherle$io$InputArchiveMetaData = InputArchiveMetaData.class$("de.schlichtherle.io.InputArchiveMetaData")) : class$de$schlichtherle$io$InputArchiveMetaData).desiredAssertionStatus();
        }
    }
}

