/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;

public class TarGZipDriver
extends TarDriver {
    private static final long serialVersionUID = 7736164529936091928L;
    private static final int BUFSIZE = 4096;
    public static final int DEFAULT_LEVEL = 9;
    private final int level;

    public TarGZipDriver() {
        this("US-ASCII", null, null, 9);
    }

    public TarGZipDriver(String string) {
        this(string, null, null, 9);
    }

    public TarGZipDriver(int n) {
        this("US-ASCII", null, null, n);
    }

    public TarGZipDriver(String string, Icon icon, Icon icon2, int n) {
        super(string, null, null);
        if ((n < 1 || n > 9) && n != -1) {
            throw new IllegalArgumentException();
        }
        this.level = n;
    }

    public final int getLevel() {
        return this.level;
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        return new GZIPInputStream(super.createInputStream(archive, readOnlyFile), 4096);
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream outputStream, TarInputArchive tarInputArchive) throws IOException {
        return super.createTarOutputArchive(archive, new GZIPOutputStream(outputStream, 4096, this.level), tarInputArchive);
    }

    public static class GZIPOutputStream
    extends java.util.zip.GZIPOutputStream {
        public GZIPOutputStream(OutputStream outputStream, int n, int n2) throws IOException {
            super(outputStream, n);
            this.def.setLevel(n2);
        }
    }
}

