/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.File;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.util.Temps;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tools.tar.TarOutputStream;

public class TarOutputArchive
extends TarOutputStream
implements OutputArchive {
    private static final String TEMP_FILE_PREFIX = "tzp-tar";
    private final Map entries = new LinkedHashMap();
    private OutputArchiveMetaData metaData;
    private boolean busy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TarOutputArchive(OutputStream outputStream) {
        super(outputStream);
        super.setLongFileMode(2);
    }

    public int getNumArchiveEntries() {
        return this.entries.size();
    }

    public Enumeration getArchiveEntries() {
        return Collections.enumeration(this.entries.values());
    }

    public ArchiveEntry getArchiveEntry(String string) {
        return (TarEntry)this.entries.get(string);
    }

    public OutputStream getOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (this.isBusy()) {
            throw new OutputArchiveBusyException(archiveEntry);
        }
        TarEntry tarEntry = (TarEntry)archiveEntry;
        if (tarEntry.isDirectory()) {
            tarEntry.setSize(0L);
            return new EntryOutputStream(tarEntry);
        }
        if (archiveEntry2 != null) {
            tarEntry.setSize(archiveEntry2.getSize());
            return new EntryOutputStream(tarEntry);
        }
        java.io.File file = Temps.createTempFile(TEMP_FILE_PREFIX);
        return new TempEntryOutputStream(tarEntry, file);
    }

    private final boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntry(TarEntry tarEntry, java.io.File file) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.putNextEntry(tarEntry);
                try {
                    File.cat(fileInputStream, (OutputStream)((Object)this));
                }
                finally {
                    this.closeEntry();
                }
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public final void storeDirectory(ArchiveEntry archiveEntry) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Since TrueZIP 6.5, this is not used anymore!");
        }
        if (!archiveEntry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(archiveEntry, null).close();
    }

    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OutputArchiveMetaData outputArchiveMetaData) {
        this.metaData = outputArchiveMetaData;
    }

    static {
        $assertionsDisabled = !TarOutputArchive.class.desiredAssertionStatus();
    }

    private class TempEntryOutputStream
    extends FileOutputStream {
        private final TarEntry entry;
        private final java.io.File temp;
        private boolean closed;

        public TempEntryOutputStream(TarEntry tarEntry, java.io.File file) throws IOException {
            super(file);
            this.entry = tarEntry;
            this.temp = file;
            TarOutputArchive.this.entries.put(tarEntry.getName(), tarEntry);
            TarOutputArchive.this.busy = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputArchive.this.busy = false;
            try {
                super.close();
            }
            finally {
                this.entry.setSize(this.temp.length());
                TarOutputArchive.this.storeTempEntry(this.entry, this.temp);
            }
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private boolean closed;

        private EntryOutputStream(TarEntry tarEntry) throws IOException {
            super((OutputStream)((Object)TarOutputArchive.this));
            TarOutputArchive.this.putNextEntry(tarEntry);
            TarOutputArchive.this.entries.put(tarEntry.getName(), tarEntry);
            TarOutputArchive.this.busy = true;
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputArchive.this.busy = false;
            TarOutputArchive.this.closeEntry();
        }
    }
}

