/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.MultiplexedOutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import java.io.IOException;
import java.io.OutputStream;

public class OdfOutputArchive
extends MultiplexedOutputArchive {
    private static final String MIMETYPE = "mimetype";
    private boolean mimetype;

    public OdfOutputArchive(OutputArchive outputArchive) {
        super(outputArchive);
    }

    public OutputStream getOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        Zip32Entry zip32Entry = (Zip32Entry)archiveEntry;
        if (MIMETYPE.equals(zip32Entry.getName())) {
            this.mimetype = true;
            if (zip32Entry.getMethod() == -1) {
                zip32Entry.setMethod(0);
            }
        }
        return super.getOutputStream(zip32Entry, archiveEntry2);
    }

    public boolean isTargetBusy() {
        return !this.mimetype || super.isTargetBusy();
    }

    public void close() throws IOException {
        this.mimetype = true;
        super.close();
    }
}

