/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.swing.FileView;
import de.schlichtherle.io.swing.FilterFileSystemView;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.UIManager;

public class FileSystemView
extends FilterFileSystemView {
    private static FileSystemView defaultView = new FileSystemView(javax.swing.filechooser.FileSystemView.getFileSystemView(), null);
    private ArchiveDetector archiveDetector;

    public static final javax.swing.filechooser.FileSystemView getFileSystemView() {
        return FileSystemView.getFileSystemView(null);
    }

    public static final javax.swing.filechooser.FileSystemView getFileSystemView(ArchiveDetector archiveDetector) {
        return archiveDetector != null ? new FileSystemView(javax.swing.filechooser.FileSystemView.getFileSystemView(), archiveDetector) : defaultView;
    }

    private FileSystemView(javax.swing.filechooser.FileSystemView fileSystemView, ArchiveDetector archiveDetector) {
        super(fileSystemView);
        this.archiveDetector = archiveDetector;
    }

    public ArchiveDetector getArchiveDetector() {
        return this.archiveDetector != null ? this.archiveDetector : File.getDefaultArchiveDetector();
    }

    public void setArchiveDetector(ArchiveDetector archiveDetector) {
        this.archiveDetector = archiveDetector;
    }

    protected File wrap(java.io.File file) {
        if (file == null) {
            return null;
        }
        return file instanceof File ? (File)file : this.getArchiveDetector().createFile(file);
    }

    protected java.io.File unwrap(java.io.File file) {
        return file instanceof File ? ((File)file).getDelegate() : file;
    }

    public java.io.File createFileObject(java.io.File file) {
        if (file == null) {
            return null;
        }
        File file2 = this.wrap(file);
        return file2.isArchive() || file2.isEntry() ? file2 : this.unwrap(file);
    }

    public boolean isRoot(java.io.File file) {
        return super.isRoot(this.unwrap(file));
    }

    public Boolean isTraversable(java.io.File file) {
        File file2 = this.wrap(file);
        Boolean bl = FileView.traversable(file2);
        if (bl != null) {
            return bl;
        }
        return super.isTraversable(this.unwrap(file));
    }

    public String getSystemDisplayName(java.io.File file) {
        File file2 = this.wrap(file);
        if (file2.isArchive() || file2.isEntry()) {
            return file2.getName();
        }
        return super.getSystemDisplayName(this.unwrap(file));
    }

    public String getSystemTypeDescription(java.io.File file) {
        File file2 = this.wrap(file);
        String string = FileView.typeDescription(file2);
        if (string != null) {
            return string;
        }
        return super.getSystemTypeDescription(this.unwrap(file));
    }

    public Icon getSystemIcon(java.io.File file) {
        File file2 = this.wrap(file);
        Icon icon = FileView.closedIcon(file2);
        if (icon != null) {
            return icon;
        }
        java.io.File file3 = this.unwrap(file);
        return file3.exists() ? super.getSystemIcon(file3) : null;
    }

    public boolean isParent(java.io.File file, java.io.File file2) {
        return super.isParent(this.wrap(file), this.wrap(file2)) || super.isParent(this.unwrap(file), this.unwrap(file2));
    }

    public java.io.File getChild(java.io.File file, String string) {
        File file2 = this.wrap(file);
        if (file2.isArchive() || file2.isEntry()) {
            return this.createFileObject(super.getChild(file2, string));
        }
        return this.createFileObject(super.getChild(this.unwrap(file), string));
    }

    public boolean isFileSystem(java.io.File file) {
        return super.isFileSystem(this.unwrap(file));
    }

    public java.io.File createNewFolder(java.io.File file) throws IOException {
        File file2 = this.wrap(file);
        if (file2.isArchive() || file2.isEntry()) {
            File file3 = this.getArchiveDetector().createFile((java.io.File)file2, UIManager.getString(File.separatorChar == '\\' ? "FileChooser.win32.newFolder" : "FileChooser.other.newFolder"));
            int n = 2;
            while (!file3.mkdirs()) {
                if (n > 100) {
                    throw new IOException(file2 + ": Could not create new directory entry!");
                }
                file3 = this.getArchiveDetector().createFile((java.io.File)file2, MessageFormat.format(UIManager.getString(File.separatorChar == '\\' ? "FileChooser.win32.newFolder.subsequent" : "FileChooser.other.newFolder.subsequent"), new Integer(n)));
                ++n;
            }
            return file3;
        }
        return this.createFileObject(super.createNewFolder(this.unwrap(file)));
    }

    public boolean isHiddenFile(java.io.File file) {
        return super.isHiddenFile(this.unwrap(file));
    }

    public boolean isFileSystemRoot(java.io.File file) {
        return super.isFileSystemRoot(this.unwrap(file));
    }

    public boolean isDrive(java.io.File file) {
        return super.isDrive(this.unwrap(file));
    }

    public boolean isFloppyDrive(java.io.File file) {
        return super.isFloppyDrive(this.unwrap(file));
    }

    public boolean isComputerNode(java.io.File file) {
        return super.isComputerNode(this.unwrap(file));
    }

    public java.io.File createFileObject(java.io.File file, String string) {
        return this.createFileObject(super.createFileObject(file, string));
    }

    public java.io.File createFileObject(String string) {
        return this.createFileObject(super.createFileObject(string));
    }

    public java.io.File[] getFiles(java.io.File file, final boolean bl) {
        File file2 = this.wrap(file);
        if (file2.isArchive() || file2.isEntry()) {
            return file2.listFiles(new FileFilter(){

                public boolean accept(java.io.File file) {
                    return !bl || !FileSystemView.this.isHiddenFile(file);
                }
            });
        }
        java.io.File[] fileArray = super.getFiles(this.unwrap(file), bl);
        if (fileArray != null) {
            int n = fileArray.length;
            while (--n >= 0) {
                fileArray[n] = this.createFileObject(fileArray[n]);
            }
        }
        return fileArray;
    }

    public java.io.File getParentDirectory(java.io.File file) {
        File file2 = this.wrap(file);
        if (file2.isEntry()) {
            return this.createFileObject(file2.getParentFile());
        }
        return this.createFileObject(super.getParentDirectory(this.unwrap(file)));
    }
}

