/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.AuthenticationPanel;
import de.schlichtherle.key.passwd.swing.Feedback;
import de.schlichtherle.key.passwd.swing.PromptingKeyProviderUI;
import de.schlichtherle.key.passwd.swing.WeakKeyException;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CreateKeyPanel
extends EnhancedPanel {
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final int MIN_PASSWD_LEN = 6;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private Feedback feedback;
    private AuthenticationPanel authenticationPanel;
    private JLabel error;
    private JPasswordField newPasswd1;
    private JLabel newPasswd1Label;
    private JPasswordField newPasswd2;
    private JLabel newPasswd2Label;
    private EnhancedPanel newPasswdPanel;
    private JTextPane resourceID;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CreateKeyPanel() {
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateKeyPanel.this.setError(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CreateKeyPanel.this.setError(null);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                CreateKeyPanel.this.setError(null);
            }
        };
        this.newPasswd1.getDocument().addDocumentListener(documentListener);
        this.newPasswd2.getDocument().addDocumentListener(documentListener);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(documentListener);
        this.defaultForeground = this.resourceID.getForeground();
    }

    private Font getBoldFont() {
        Font font = this.resourceID.getFont();
        return new Font(font.getName(), 1, font.getSize());
    }

    public String getResourceID() {
        return this.resourceID.getText();
    }

    public void setResourceID(String string) {
        String string2 = PromptingKeyProviderUI.lastResourceID;
        if (!string2.equals(string) && !"".equals(string2)) {
            this.resourceID.setForeground(Color.RED);
        } else {
            this.resourceID.setForeground(this.defaultForeground);
        }
        this.resourceID.setText(string);
        PromptingKeyProviderUI.lastResourceID = string;
    }

    public Object getCreateKey() {
        try {
            switch (this.authenticationPanel.getAuthenticationMethod()) {
                case 0: {
                    char[] cArray = this.newPasswd1.getPassword();
                    char[] cArray2 = this.newPasswd2.getPassword();
                    if (Arrays.equals(cArray, cArray2)) {
                        Arrays.fill(cArray2, '\u0000');
                        this.checkPasswdCreateKey(cArray);
                        this.setError(null);
                        return cArray;
                    }
                    this.setError(resources.getString("passwd.noMatch"));
                    return null;
                }
                case 1: {
                    byte[] byArray;
                    String string = this.authenticationPanel.getKeyFilePath();
                    if (new File(string).canWrite()) {
                        this.setError(resources.getString("keyFile.canWrite"));
                        return null;
                    }
                    try {
                        byArray = PromptingKeyProviderUI.readKeyFile(string);
                    }
                    catch (EOFException eOFException) {
                        this.setError(resources.getString("keyFile.eofException"));
                        return null;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.setError(resources.getString("keyFile.fileNotFoundException"));
                        return null;
                    }
                    catch (IOException iOException) {
                        this.setError(resources.getString("keyFile.ioException"));
                        return null;
                    }
                    this.checkKeyFileCreateKey(byArray);
                    this.setError(null);
                    return byArray;
                }
            }
            throw new AssertionError((Object)"Unsupported authentication method!");
        }
        catch (WeakKeyException weakKeyException) {
            this.setError(weakKeyException.getLocalizedMessage());
            return null;
        }
    }

    public void resetCreateKey() {
        this.resetPasswd();
        this.setError(null);
    }

    public void resetPasswd() {
        this.newPasswd1.setText(null);
        this.newPasswd2.setText(null);
    }

    protected void checkKeyFileCreateKey(byte[] byArray) throws WeakKeyException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        if (!$assertionsDisabled && deflater.getTotalOut() != 0) {
            throw new AssertionError();
        }
        int n = deflater.deflate(new byte[byArray.length * 2]);
        if (!$assertionsDisabled && deflater.getTotalOut() != n) {
            throw new AssertionError();
        }
        deflater.end();
        if (n < 64) {
            throw new WeakKeyException(CreateKeyPanel.localizedMessage(resources, "keyFile.badEntropy", null));
        }
    }

    protected void checkPasswdCreateKey(char[] cArray) throws WeakKeyException {
        if (cArray.length < 6) {
            throw new WeakKeyException(CreateKeyPanel.localizedMessage(resources, "passwd.tooShort", new Integer(6)));
        }
    }

    static final String localizedMessage(ResourceBundle resourceBundle, String string, Object object) {
        return object != null ? MessageFormat.format(resourceBundle.getString(string), object) : resourceBundle.getString(string);
    }

    public String getError() {
        String string = this.error.getText();
        return string.trim().length() > 0 ? string : null;
    }

    public void setError(String string) {
        this.error.setText(string != null ? string : " ");
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent jComponent) {
        if (this.extraDataUI == jComponent) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (jComponent != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
        }
        this.extraDataUI = jComponent;
        this.revalidate();
    }

    public Feedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    private void initComponents() {
        this.newPasswdPanel = new EnhancedPanel();
        this.newPasswd1Label = new JLabel();
        this.newPasswd1 = new JPasswordField();
        this.newPasswd2Label = new JLabel();
        this.newPasswd2 = new JPasswordField();
        JLabel jLabel = new JLabel();
        this.resourceID = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.newPasswdPanel.setLayout(new GridBagLayout());
        this.newPasswdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                CreateKeyPanel.this.newPasswdPanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.newPasswd1Label.setDisplayedMnemonic(resources.getString("newPasswd1").charAt(0));
        this.newPasswd1Label.setLabelFor(this.newPasswd1);
        this.newPasswd1Label.setText(resources.getString("newPasswd1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.newPasswdPanel.add((Component)this.newPasswd1Label, gridBagConstraints);
        this.newPasswd1.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.newPasswdPanel.add((Component)this.newPasswd1, gridBagConstraints);
        this.newPasswd2Label.setDisplayedMnemonic(resources.getString("newPasswd2").charAt(0));
        this.newPasswd2Label.setLabelFor(this.newPasswd2);
        this.newPasswd2Label.setText(resources.getString("newPasswd2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.newPasswdPanel.add((Component)this.newPasswd2Label, gridBagConstraints);
        this.newPasswd2.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.newPasswdPanel.add((Component)this.newPasswd2, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                CreateKeyPanel.this.formAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        jLabel.setLabelFor(this.resourceID);
        jLabel.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this.resourceID.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resourceID.setEditable(false);
        this.resourceID.setFont(this.getBoldFont());
        this.resourceID.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resourceID, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel(this.newPasswdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.authenticationPanel, gridBagConstraints);
        this.error.setForeground(new Color(255, 0, 0));
        this.error.setText(" ");
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void formAncestorWindowShown(PanelEvent panelEvent) {
        Feedback feedback = this.getFeedback();
        if (feedback != null) {
            feedback.setPanel(this);
            feedback.run();
        }
    }

    private void newPasswdPanelAncestorWindowShown(PanelEvent panelEvent) {
        final Window window = panelEvent.getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (CreateKeyPanel.this.newPasswd1.requestFocusInWindow()) {
                            CreateKeyPanel.this.newPasswd1.selectAll();
                            CreateKeyPanel.this.newPasswd2.selectAll();
                        }
                    }
                });
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }

    static {
        $assertionsDisabled = !CreateKeyPanel.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/key/passwd/swing/CreateKeyPanel".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
    }
}

