/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.BasicInvalidKeyFeedback;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HurlingWindowFeedback
extends BasicInvalidKeyFeedback {
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;
    public static final int DISTANCE = 25;
    public static final int CYCLE = 150;
    public static final int DURATION = 1500;
    public static final int FPS = 75;
    private final double distance;
    private final double cycle;
    private final int duration;
    private final int fps;

    public HurlingWindowFeedback() {
        this(25, 150, 1500, 75);
    }

    protected HurlingWindowFeedback(int n, int n2, int n3, int n4) {
        this.distance = n;
        this.cycle = n2;
        this.duration = n3;
        this.fps = n4;
        if (n3 > this.getDelay()) {
            this.setDelay(n3);
        }
    }

    protected void startAnimation() {
        super.startAnimation();
        final Window window = SwingUtilities.getWindowAncestor(this.getPanel());
        if (window == null) {
            return;
        }
        final Point point = window.getLocation();
        final long l = System.currentTimeMillis();
        Timer timer = new Timer(1000 / this.fps, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l2 = System.currentTimeMillis() - l;
                if (l2 < (long)HurlingWindowFeedback.this.duration && window.isShowing()) {
                    double d = Math.sin(Math.PI * (double)l2 / (double)HurlingWindowFeedback.this.duration) * HurlingWindowFeedback.this.distance;
                    double d2 = Math.PI * 2 * (double)l2 / HurlingWindowFeedback.this.cycle;
                    int n = (int)(Math.cos(d2) * d + (double)point.x);
                    int n2 = (int)(Math.sin(d2) * d + (double)point.y);
                    window.setLocation(n, n2);
                    window.repaint();
                } else {
                    ((Timer)actionEvent.getSource()).stop();
                    window.setLocation(point);
                    window.repaint();
                }
            }
        });
        timer.start();
    }
}

