/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class AbstractComboBoxBrowser
implements Serializable {
    private final Listener listener = new Listener();
    private JComboBox comboBox;
    private transient boolean recursion;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractComboBoxBrowser() {
    }

    public AbstractComboBoxBrowser(JComboBox jComboBox) {
        this.changeComboBox(null, jComboBox, false);
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox jComboBox) {
        this.changeComboBox(this.getComboBox(), jComboBox, true);
    }

    private void changeComboBox(JComboBox jComboBox, JComboBox jComboBox2, boolean bl) {
        if (jComboBox2 == jComboBox) {
            return;
        }
        ComboBoxEditor comboBoxEditor = null;
        if (jComboBox != null) {
            jComboBox.removePropertyChangeListener("editor", this.listener);
            comboBoxEditor = jComboBox.getEditor();
            jComboBox.setEditor(((ComboBoxEditorProxy)comboBoxEditor).getEditor());
        }
        this.comboBox = jComboBox2;
        ComboBoxEditorProxy comboBoxEditorProxy = null;
        if (jComboBox2 != null) {
            jComboBox2.updateUI();
            comboBoxEditorProxy = new ComboBoxEditorProxy(jComboBox2.getEditor());
            jComboBox2.setEditor(comboBoxEditorProxy);
            jComboBox2.addPropertyChangeListener("editor", this.listener);
        }
        this.changeEditor(comboBoxEditor, comboBoxEditorProxy, bl);
    }

    private void changeEditor(ComboBoxEditor comboBoxEditor, ComboBoxEditor comboBoxEditor2, boolean bl) {
        Component component;
        Component component2;
        if (comboBoxEditor2 == comboBoxEditor) {
            return;
        }
        JTextComponent jTextComponent = null;
        if (comboBoxEditor != null && (component2 = comboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component2;
        }
        component2 = null;
        if (comboBoxEditor2 != null && (component = comboBoxEditor2.getEditorComponent()) instanceof JTextComponent) {
            component2 = (JTextComponent)component;
        }
        this.changeText(jTextComponent, (JTextComponent)component2, bl);
    }

    private void changeText(JTextComponent jTextComponent, JTextComponent jTextComponent2, boolean bl) {
        if (jTextComponent2 == jTextComponent) {
            return;
        }
        Document document = null;
        if (jTextComponent != null) {
            jTextComponent.removePropertyChangeListener("document", this.listener);
            document = jTextComponent.getDocument();
        }
        Document document2 = null;
        if (jTextComponent2 != null) {
            document2 = jTextComponent2.getDocument();
            jTextComponent2.addPropertyChangeListener("document", this.listener);
        }
        this.changeDocument(document, document2, bl);
    }

    private void changeDocument(Document document, Document document2, boolean bl) {
        if (document2 == document) {
            return;
        }
        if (document != null) {
            document.removeDocumentListener(this.listener);
        }
        if (document2 != null) {
            if (bl) {
                String string;
                try {
                    string = document2.getText(0, document2.getLength());
                }
                catch (BadLocationException badLocationException) {
                    string = null;
                }
                this.update(string);
            }
            document2.addDocumentListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentUpdated() {
        if (this.lock()) {
            return;
        }
        try {
            JComboBox jComboBox = this.getComboBox();
            ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
            JTextComponent jTextComponent = (JTextComponent)comboBoxEditor.getEditorComponent();
            if (!$assertionsDisabled && !jComboBox.isShowing() && jTextComponent.isFocusOwner()) {
                throw new AssertionError();
            }
            if (!jTextComponent.isFocusOwner()) {
                return;
            }
            jComboBox.setPopupVisible(false);
            if (this.update(jTextComponent.getText())) {
                jComboBox.setPopupVisible(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(ComboBoxEditor comboBoxEditor, Object object) {
        if (this.lock()) {
            return;
        }
        try {
            comboBoxEditor.setItem(object);
            if (!(object instanceof String)) {
                return;
            }
            JComboBox jComboBox = this.getComboBox();
            JTextComponent jTextComponent = (JTextComponent)comboBoxEditor.getEditorComponent();
            if (!$assertionsDisabled && !jComboBox.isShowing() && jTextComponent.isFocusOwner()) {
                throw new AssertionError();
            }
            if (!jTextComponent.isFocusOwner()) {
                return;
            }
            Caret caret = jTextComponent.getCaret();
            caret.setDot(((String)object).length());
        }
        finally {
            this.unlock();
        }
    }

    protected abstract boolean update(String var1);

    private final boolean lock() {
        if (this.recursion) {
            return true;
        }
        this.recursion = true;
        return false;
    }

    private final void unlock() {
        this.recursion = false;
    }

    static {
        $assertionsDisabled = !AbstractComboBoxBrowser.class.desiredAssertionStatus();
    }

    private final class ComboBoxEditorProxy
    extends BasicComboBoxEditor {
        private final ComboBoxEditor comboBoxEditor;

        public ComboBoxEditorProxy(ComboBoxEditor comboBoxEditor) {
            this.comboBoxEditor = comboBoxEditor;
        }

        public ComboBoxEditor getEditor() {
            return this.comboBoxEditor;
        }

        public Component getEditorComponent() {
            return this.comboBoxEditor.getEditorComponent();
        }

        public void setItem(Object object) {
            AbstractComboBoxBrowser.this.updateEditor(this.comboBoxEditor, object);
        }

        public Object getItem() {
            return this.comboBoxEditor.getItem();
        }

        public void selectAll() {
            this.comboBoxEditor.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.comboBoxEditor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.comboBoxEditor.removeActionListener(actionListener);
        }
    }

    private final class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("editor".equals(string)) {
                AbstractComboBoxBrowser.this.changeEditor((ComboBoxEditor)propertyChangeEvent.getOldValue(), (ComboBoxEditor)propertyChangeEvent.getNewValue(), true);
            } else if ("document".equals(string)) {
                AbstractComboBoxBrowser.this.changeDocument((Document)propertyChangeEvent.getOldValue(), (Document)propertyChangeEvent.getNewValue(), true);
            } else {
                throw new AssertionError((Object)("Received change event for unknown property: " + string));
            }
        }
    }
}

