/*
 * Decompiled with CFR 0.152.
 */
package junitx.ant;

import java.io.File;
import java.util.List;
import java.util.Vector;
import junitx.tool.TestClassValidator;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TestClassValidatorTask
extends Task {
    private int verbosity = 3;
    private boolean quiet = false;
    private boolean failonerror = true;
    private AntClassLoader loader;
    private Path classpath;
    private List filesets = new Vector();
    private TestClassValidator.ClassValidator validator;

    public void execute() throws BuildException {
        this.validator = new TestClassValidator.DefaultClassValidator();
        this.validator.setListener(new TestClassValidator.ClassValidatorListener(){

            public void info(String message) {
                TestClassValidatorTask.this.log("INFO> " + message, TestClassValidatorTask.this.verbosity);
                System.out.println("INFO> " + message);
            }

            public void warning(String message) {
                TestClassValidatorTask.this.log("WARNING> " + message, TestClassValidatorTask.this.verbosity);
                System.out.println("WARNING> " + message);
            }

            public void error(String message) {
                TestClassValidatorTask.this.log("ERROR> " + message, TestClassValidatorTask.this.verbosity);
                System.out.println("ERROR> " + message);
            }
        });
        if (this.classpath != null) {
            this.classpath.setProject(this.project);
            this.loader = new AntClassLoader(this.project, this.classpath);
        }
        this.log("TestClassValidator, by Vladimir R. Bossicard", 3);
        System.out.println("TestClassValidator, by Vladimir R. Bossicard");
        int count = 0;
        int i2 = 0;
        while (i2 < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.get(i2);
            try {
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                ds.scan();
                String[] files = ds.getIncludedFiles();
                int k = 0;
                while (k < files.length) {
                    String pathname = files[k];
                    if (pathname.endsWith(".class")) {
                        String classname = pathname.substring(0, pathname.length() - ".class".length()).replace(File.separatorChar, '.');
                        this.processFile(classname);
                    }
                    ++k;
                }
                count += files.length;
            }
            catch (BuildException e) {
                if (this.failonerror) {
                    throw e;
                }
                this.log(e.getMessage(), this.quiet ? 3 : 1);
            }
            catch (ClassNotFoundException e) {
                if (this.failonerror) {
                    throw new BuildException((Throwable)e);
                }
                this.log(e.getMessage(), this.quiet ? 3 : 1);
            }
            this.log("Number of classes: " + count, 3);
            System.out.println("Number of classes: " + count);
            ++i2;
        }
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    private void processFile(String classname) throws ClassNotFoundException {
        ClassLoader l;
        this.log("processing " + classname, this.verbosity);
        Class<?> cls = this.loader != null ? this.loader.loadClass(classname) : ((l = ((Object)((Object)this)).getClass().getClassLoader()) != null ? l.loadClass(classname) : Class.forName(classname));
        this.validator.validate(cls);
    }
}

