/*
 * Decompiled with CFR 0.152.
 */
package junitx.extensions;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junitx.framework.Assert;

public abstract class EqualsHashCodeTestCase
extends TestCase {
    private Object eq1;
    private Object eq2;
    private Object eq3;
    private Object neq;
    private static final int NUM_ITERATIONS = 20;

    public EqualsHashCodeTestCase(String name) {
        super(name);
    }

    protected abstract Object createInstance() throws Exception;

    protected abstract Object createNotEqualInstance() throws Exception;

    protected void setUp() throws Exception {
        super.setUp();
        this.eq1 = this.createInstance();
        this.eq2 = this.createInstance();
        this.eq3 = this.createInstance();
        this.neq = this.createNotEqualInstance();
        try {
            junit.framework.Assert.assertNotNull((String)"createInstance() returned null", (Object)this.eq1);
            junit.framework.Assert.assertNotNull((String)"2nd createInstance() returned null", (Object)this.eq2);
            junit.framework.Assert.assertNotNull((String)"3rd createInstance() returned null", (Object)this.eq3);
            junit.framework.Assert.assertNotNull((String)"createNotEqualInstance() returned null", (Object)this.neq);
            Assert.assertNotSame(this.eq1, this.eq2);
            Assert.assertNotSame(this.eq1, this.eq3);
            Assert.assertNotSame(this.eq1, this.neq);
            Assert.assertNotSame(this.eq2, this.eq3);
            Assert.assertNotSame(this.eq2, this.neq);
            Assert.assertNotSame(this.eq3, this.neq);
            junit.framework.Assert.assertEquals((String)"1st and 2nd equal instances of different classes", this.eq1.getClass(), this.eq2.getClass());
            junit.framework.Assert.assertEquals((String)"1st and 3rd equal instances of different classes", this.eq1.getClass(), this.eq3.getClass());
            junit.framework.Assert.assertEquals((String)"1st equal instance and not-equal instance of different classes", this.eq1.getClass(), this.neq.getClass());
        }
        catch (AssertionFailedError ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public final void testEqualsAgainstNewObject() {
        Object o = new Object();
        Assert.assertNotEquals(o, this.eq1);
        Assert.assertNotEquals(o, this.eq2);
        Assert.assertNotEquals(o, this.eq3);
        Assert.assertNotEquals(o, this.neq);
    }

    public final void testEqualsAgainstNull() {
        Assert.assertNotEquals("null vs. 1st", null, this.eq1);
        Assert.assertNotEquals("null vs. 2nd", null, this.eq2);
        Assert.assertNotEquals("null vs. 3rd", null, this.eq3);
        Assert.assertNotEquals("null vs. not-equal", null, this.neq);
    }

    public final void testEqualsAgainstUnequalObjects() {
        Assert.assertNotEquals("1st vs. not-equal", this.eq1, this.neq);
        Assert.assertNotEquals("2nd vs. not-equal", this.eq2, this.neq);
        Assert.assertNotEquals("3rd vs. not-equal", this.eq3, this.neq);
        Assert.assertNotEquals("not-equal vs. 1st", this.neq, this.eq1);
        Assert.assertNotEquals("not-equal vs. 2nd", this.neq, this.eq2);
        Assert.assertNotEquals("not-equal vs. 3rd", this.neq, this.eq3);
    }

    public final void testEqualsIsConsistentAcrossInvocations() {
        int i2 = 0;
        while (i2 < 20) {
            this.testEqualsAgainstNewObject();
            this.testEqualsAgainstNull();
            this.testEqualsAgainstUnequalObjects();
            this.testEqualsIsReflexive();
            this.testEqualsIsSymmetricAndTransitive();
            ++i2;
        }
    }

    public final void testEqualsIsReflexive() {
        junit.framework.Assert.assertEquals((String)"1st equal instance", (Object)this.eq1, (Object)this.eq1);
        junit.framework.Assert.assertEquals((String)"2nd equal instance", (Object)this.eq2, (Object)this.eq2);
        junit.framework.Assert.assertEquals((String)"3rd equal instance", (Object)this.eq3, (Object)this.eq3);
        junit.framework.Assert.assertEquals((String)"not-equal instance", (Object)this.neq, (Object)this.neq);
    }

    public final void testEqualsIsSymmetricAndTransitive() {
        junit.framework.Assert.assertEquals((String)"1st vs. 2nd", (Object)this.eq1, (Object)this.eq2);
        junit.framework.Assert.assertEquals((String)"2nd vs. 1st", (Object)this.eq2, (Object)this.eq1);
        junit.framework.Assert.assertEquals((String)"1st vs. 3rd", (Object)this.eq1, (Object)this.eq3);
        junit.framework.Assert.assertEquals((String)"3rd vs. 1st", (Object)this.eq3, (Object)this.eq1);
        junit.framework.Assert.assertEquals((String)"2nd vs. 3rd", (Object)this.eq2, (Object)this.eq3);
        junit.framework.Assert.assertEquals((String)"3rd vs. 2nd", (Object)this.eq3, (Object)this.eq2);
    }

    public final void testHashCodeContract() {
        junit.framework.Assert.assertEquals((String)"1st vs. 2nd", (int)this.eq1.hashCode(), (int)this.eq2.hashCode());
        junit.framework.Assert.assertEquals((String)"1st vs. 3rd", (int)this.eq1.hashCode(), (int)this.eq3.hashCode());
        junit.framework.Assert.assertEquals((String)"2nd vs. 3rd", (int)this.eq2.hashCode(), (int)this.eq3.hashCode());
    }

    public final void testHashCodeIsConsistentAcrossInvocations() {
        int eq1Hash = this.eq1.hashCode();
        int eq2Hash = this.eq2.hashCode();
        int eq3Hash = this.eq3.hashCode();
        int neqHash = this.neq.hashCode();
        int i2 = 0;
        while (i2 < 20) {
            junit.framework.Assert.assertEquals((String)"1st equal instance", (int)eq1Hash, (int)this.eq1.hashCode());
            junit.framework.Assert.assertEquals((String)"2nd equal instance", (int)eq2Hash, (int)this.eq2.hashCode());
            junit.framework.Assert.assertEquals((String)"3rd equal instance", (int)eq3Hash, (int)this.eq3.hashCode());
            junit.framework.Assert.assertEquals((String)"not-equal instance", (int)neqHash, (int)this.neq.hashCode());
            ++i2;
        }
    }
}

