/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.cpsuite;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.extensions.cpsuite.ClassTester;
import org.junit.extensions.cpsuite.ClassesFinder;
import org.junit.extensions.cpsuite.JarFilenameIterator;
import org.junit.extensions.cpsuite.NullIterator;
import org.junit.extensions.cpsuite.RecursiveFilenameIterator;

public class ClasspathClassesFinder
implements ClassesFinder {
    private static final int CLASS_SUFFIX_LENGTH = ".class".length();
    private static final String FALLBACK_CLASSPATH_PROPERTY = "java.class.path";
    private final ClassTester tester;
    private final String classpathProperty;

    public ClasspathClassesFinder(ClassTester tester, String classpathProperty) {
        this.tester = tester;
        this.classpathProperty = classpathProperty;
    }

    @Override
    public List<Class<?>> find() {
        return this.findClassesInClasspath(this.getClasspath());
    }

    private String getClasspath() {
        String classPath = System.getProperty(this.getClasspathProperty());
        if (classPath == null) {
            classPath = System.getProperty(FALLBACK_CLASSPATH_PROPERTY);
        }
        return classPath;
    }

    private List<Class<?>> findClassesInClasspath(String classPath) {
        return this.findClassesInRoots(this.splitClassPath(classPath));
    }

    private List<Class<?>> findClassesInRoots(List<String> roots) {
        ArrayList classes = new ArrayList(100);
        for (String root : roots) {
            this.gatherClassesInRoot(new File(root), classes);
        }
        return classes;
    }

    private void gatherClassesInRoot(File classRoot, List<Class<?>> classes) {
        Iterable<String> relativeFilenames = new NullIterator<String>();
        if (this.tester.searchInJars() && this.isJarFile(classRoot)) {
            try {
                relativeFilenames = new JarFilenameIterator(classRoot);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (classRoot.isDirectory()) {
            relativeFilenames = new RecursiveFilenameIterator(classRoot);
        }
        this.gatherClasses(classes, relativeFilenames);
    }

    private boolean isJarFile(File classRoot) {
        return classRoot.getName().endsWith(".jar") || classRoot.getName().endsWith(".JAR");
    }

    private void gatherClasses(List<Class<?>> classes, Iterable<String> filenamesIterator) {
        for (String fileName : filenamesIterator) {
            String className;
            if (!this.isClassFile(fileName) || !this.tester.acceptClassName(className = this.classNameFromFile(fileName)) || !this.tester.acceptInnerClass() && this.isInnerClass(className)) continue;
            try {
                Class<?> clazz = Class.forName(className, false, this.getClass().getClassLoader());
                if (clazz == null || clazz.isLocalClass() || clazz.isAnonymousClass() || !this.tester.acceptClass(clazz)) continue;
                classes.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
    }

    private boolean isInnerClass(String className) {
        return className.contains("$");
    }

    private boolean isClassFile(String classFileName) {
        return classFileName.endsWith(".class");
    }

    private List<String> splitClassPath(String classPath) {
        String separator = System.getProperty("path.separator");
        return Arrays.asList(classPath.split(separator));
    }

    private String classNameFromFile(String classFileName) {
        String s = this.replaceFileSeparators(this.cutOffExtension(classFileName));
        if (s.startsWith(".")) {
            return s.substring(1);
        }
        return s;
    }

    private String replaceFileSeparators(String s) {
        String result = s.replace(File.separatorChar, '.');
        if (File.separatorChar != '/') {
            result = result.replace('/', '.');
        }
        return result;
    }

    private String cutOffExtension(String classFileName) {
        return classFileName.substring(0, classFileName.length() - CLASS_SUFFIX_LENGTH);
    }

    public ClassTester getTester() {
        return this.tester;
    }

    public String getClasspathProperty() {
        return this.classpathProperty;
    }
}

