/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.cpsuite;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class RecursiveFilenameIterator
implements Iterator<String>,
Iterable<String> {
    private List<RecursiveFilenameIterator> innerIterators;
    private int prefixLength;
    private File root;
    private boolean alreadyUsed = false;
    private int index = 0;

    public RecursiveFilenameIterator(File root) {
        this(root, root.getAbsolutePath().length() + 1);
    }

    private RecursiveFilenameIterator(File root, int prefixLength) {
        this.root = root;
        this.prefixLength = prefixLength;
        if (!this.isRootFile()) {
            this.innerIterators = this.getInnerIterators(root);
        }
    }

    private boolean isRootFile() {
        return this.root.isFile();
    }

    private List<RecursiveFilenameIterator> getInnerIterators(File root) {
        ArrayList<RecursiveFilenameIterator> iterators = new ArrayList<RecursiveFilenameIterator>();
        for (File each : root.listFiles()) {
            iterators.add(new RecursiveFilenameIterator(each, this.prefixLength));
        }
        return iterators;
    }

    @Override
    public boolean hasNext() {
        if (this.isRootFile()) {
            return !this.alreadyUsed;
        }
        if (this.index >= this.innerIterators.size()) {
            return false;
        }
        if (this.currentIterator().hasNext()) {
            return true;
        }
        ++this.index;
        return this.hasNext();
    }

    private RecursiveFilenameIterator currentIterator() {
        return this.innerIterators.get(this.index);
    }

    @Override
    public String next() {
        if (this.isRootFile()) {
            if (this.alreadyUsed) {
                throw new NoSuchElementException();
            }
            this.alreadyUsed = true;
            return this.root.getAbsolutePath().substring(this.prefixLength);
        }
        if (this.hasNext()) {
            return this.currentIterator().next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

