/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.ULongInt;
import com.jniwrapper.UShortInt;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BlendFunction;
import com.jniwrapper.win32.gdi.Brush;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.gdi.DDBitmap;
import com.jniwrapper.win32.gdi.Font;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.GradientRect;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.LogBrush;
import com.jniwrapper.win32.gdi.Msimg32;
import com.jniwrapper.win32.gdi.Pen;
import com.jniwrapper.win32.gdi.PolyFillMode;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.gdi.TriVertex;
import com.jniwrapper.win32.ui.User32;
import java.awt.Color;

public class DC
extends Handle {
    public static final int DC_PEN = 19;
    static final String FUNCTION_CREATE_COMPATIBLE_DC = "CreateCompatibleDC";
    static final String FUNCTION_SELECT_OBJECT = "SelectObject";
    static final String FUNCTION_BIT_BLT = "BitBlt";
    static final String FUNCTION_STRETCH_BLT = "StretchBlt";
    static final String FUNCTION_PAT_BLT = "PatBlt";
    static final String FUNCTION_DELETE_DC = "DeleteDC";
    static final String FUNCTION_SET_DC_BRUSH_COLOR = "SetDCBrushColor";
    static final String FUNCTION_SET_DC_PEN_COLOR = "SetDCPenColor";
    static final FunctionName FUNCTION_TEXT_OUT = new FunctionName("TextOut");
    static final FunctionName FUNCTION_DRAW_TEXT = new FunctionName("DrawText");
    static final FunctionName FUNCTION_GET_TEXT_EXTENT_POINT_32 = new FunctionName("GetTextExtentPoint32");
    static final String FUNCTION_DRAW_ICON_EX = "DrawIconEx";
    static final String FUNCTION_DRAW_ICON = "DrawIcon";
    static final String FUNCTION_SET_BACKGROUND_MODE = "SetBkMode";
    static final String FUNCTION_SET_BACKGROUND_COLOR = "SetBkColor";
    static final String FUNCTION_SET_TEXT_COLOR = "SetTextColor";
    static final String FUNCTION_SELECT_CLIP_RGN = "SelectClipRgn";
    static final String FUNCTION_FILL_REGION = "FillRgn";
    static final String FUNCTION_FRAME_RGN = "FrameRgn";
    static final String FUNCTION_GET_POLY_FILL_MODE = "GetPolyFillMode";
    static final String FUNCTION_INVERT_RGN = "InvertRgn";
    static final String FUNCTION_PAINT_RGN = "PaintRgn";
    static final String FUNCTION_SET_POLY_FILL_MODE = "SetPolyFillMode";
    static final String FUNCTION_GET_PIXEL = "GetPixel";
    private static final String FUNCTION_GRADIENT_FILL = "GradientFill";
    private static final String FUNCTION_LINE_TO = "LineTo";
    private static final String FUNCTION_MOVE_TO_EX = "MoveToEx";
    private static final String FUNCTION_RECTANGLE = "Rectangle";
    private static final String FUNCTION_ROUND_RECT = "RoundRect";
    private static final String FUNCTION_FILL_RECT = "FillRect";
    private static final String FUNCTION_SetMapMode = "SetMapMode";
    private static final String FUNCTION_GetDeviceCaps = "GetDeviceCaps";
    private static final String FUNCTION_IntersectClipRect = "IntersectClipRect";
    public static final int BKMODE_TRANSPARENT = 1;
    public static final int BKMODE_OPAQUE = 2;
    public static final int BKMODE_LAST = 2;
    private static final String FUNCTION_ALPHA_BLEND = "AlphaBlend";
    public static final long GRADIENT_FILL_RECT_H = 0L;
    public static final long GRADIENT_FILL_RECT_V = 1L;
    public static final int DT_RIGHT = 2;
    static /* synthetic */ Class class$com$jniwrapper$win32$gdi$DC$MappingMode;

    public DC() {
    }

    public DC(long value) {
        super(value);
    }

    public static DC createCompatibleDC(DC dc) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_COMPATIBLE_DC);
        DC result = new DC();
        function.invoke((Parameter)result, dc == null ? new Pointer(null, true) : dc);
        return result;
    }

    private long selectObject(GdiObject object) {
        Function function = Gdi32.get(FUNCTION_SELECT_OBJECT);
        Handle result = new Handle();
        function.invoke(result, this, object);
        return result.getValue();
    }

    public Brush selectObject(Brush brush) {
        long handle = this.selectObject((GdiObject)brush);
        Brush result = new Brush(handle);
        return result;
    }

    public Pen selectObject(Pen pen) {
        long handle = this.selectObject((GdiObject)pen);
        Pen result = new Pen(handle);
        return result;
    }

    public Bitmap selectObject(Bitmap bitmap) {
        long handle = this.selectObject((GdiObject)bitmap);
        DDBitmap result = new DDBitmap(handle);
        return result;
    }

    public Font selectObject(Font font) {
        long handle = this.selectObject((GdiObject)font);
        Font result = new Font(handle);
        return result;
    }

    public Region selectObject(Region region) {
        long handle = this.selectObject((GdiObject)region);
        Region result = new Region(handle);
        return result;
    }

    public static void bitBlt(DC hdcDest, int xDest, int yDest, int width, int height, DC hdcSrc, int xSrc, int ySrc, RasterOperation rop) {
        Function function = Gdi32.get(FUNCTION_BIT_BLT);
        function.invoke(null, new Parameter[]{hdcDest, new Int(xDest), new Int(yDest), new Int(width), new Int(height), hdcSrc, new Int(xSrc), new Int(ySrc), new UInt32(rop.getValue())});
    }

    public static boolean stretchBlt(DC hDCDest, int xOriginDest, int yOriginDest, int widthDest, int heightDest, DC hDCSrc, int xOriginSrc, int yOriginSrc, int widthSrc, int heightSrc, RasterOperation rasterOp) {
        Int result = new Int();
        Function function = Gdi32.get(FUNCTION_STRETCH_BLT);
        function.invoke((Parameter)result, new Parameter[]{hDCDest, new Int(xOriginDest), new Int(yOriginDest), new Int(widthDest), new Int(heightDest), hDCSrc, new Int(xOriginSrc), new Int(yOriginSrc), new Int(widthSrc), new Int(heightSrc), new UInt32(rasterOp.getValue())});
        return result.getValue() > 0L;
    }

    public boolean patBlt(int xLeft, int yLeft, int width, int height, RasterOperation rasterOp) {
        Bool result = new Bool();
        Function function = Gdi32.get(FUNCTION_PAT_BLT);
        function.invoke((Parameter)result, new Parameter[]{this, new Int(xLeft), new Int(yLeft), new Int(width), new Int(height), new UInt32(rasterOp.getValue())});
        return result.getValue();
    }

    public void release() {
        DC.deleteDC(this);
    }

    public static void deleteDC(DC dc) {
        Function function = Gdi32.get(FUNCTION_DELETE_DC);
        Int result = new Int();
        long errorCode = function.invoke((Parameter)result, dc);
        if (result.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
    }

    public void textOut(int x2, int y2, String text) {
        Function function = Gdi32.get(FUNCTION_TEXT_OUT.toString());
        UShortInt returnValue = new UShortInt();
        long errorCode = function.invoke((Parameter)returnValue, new Parameter[]{this, new Int(x2), new Int(y2), new Str(text), new Int(text.length())});
        if (returnValue.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
    }

    public void drawText(String text, Rect clipRect, UInt uFormat) {
        Function function = User32.getInstance().getFunction(FUNCTION_DRAW_TEXT.toString());
        Int returnValue = new Int();
        long errorCode = function.invoke((Parameter)returnValue, new Parameter[]{this, new Str(text), new Int(text.length()), new Pointer(clipRect), new UInt(uFormat)});
        if (returnValue.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
    }

    public Size getTextExtentPoint32(DC dc, String str) {
        Size result = new Size();
        Gdi32.getInstance().getFunction(FUNCTION_GET_TEXT_EXTENT_POINT_32.toString()).invoke(null, new Parameter[]{this, new Str(str), new UInt(str.length()), new Pointer(result)});
        return result;
    }

    public void drawIconEx(int x2, int y2, Icon icon, int width, int heght, int frameIndex, Handle bgBrush, int flags) {
        Function function = User32.getInstance().getFunction(FUNCTION_DRAW_ICON_EX);
        UShortInt returnValue = new UShortInt();
        long errorCode = function.invoke((Parameter)returnValue, new Parameter[]{this, new Int(x2), new Int(y2), icon, new Int(width), new Int(heght), new UInt(frameIndex), bgBrush, new UInt(flags)});
        if (returnValue.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
    }

    public boolean drawIcon(int x2, int y2, Icon icon) {
        Function function = User32.getInstance().getFunction(FUNCTION_DRAW_ICON);
        Bool result = new Bool();
        function.invoke(result, this, new Int(x2), new Int(y2), icon);
        return result.getValue();
    }

    public int setBkMode(int bgMode) {
        Function function = Gdi32.get(FUNCTION_SET_BACKGROUND_MODE);
        UShortInt returnValue = new UShortInt();
        long errorCode = function.invoke(returnValue, this, new Int(bgMode));
        if (returnValue.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
        return (int)returnValue.getValue();
    }

    public ColorRef setBkColor(ColorRef color) {
        ColorRef returnValue = new ColorRef();
        Function function = Gdi32.get(FUNCTION_SET_BACKGROUND_COLOR);
        long errorCode = function.invoke(returnValue, this, color);
        if (returnValue.isInvalid()) {
            throw new LastErrorException(errorCode, "Error while changing text color");
        }
        return returnValue;
    }

    public ColorRef setTextColor(ColorRef color) {
        ColorRef returnValue = new ColorRef();
        Function function = Gdi32.get(FUNCTION_SET_TEXT_COLOR);
        long errorCode = function.invoke(returnValue, this, color);
        if (returnValue.isInvalid()) {
            throw new LastErrorException(errorCode, "Error while changing text color");
        }
        return returnValue;
    }

    public void selectClipRgn(Region region) {
        Int resultRgnType = new Int();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_SELECT_CLIP_RGN);
        long errorCode = function.invoke(resultRgnType, this, region);
        if (0L == resultRgnType.getValue()) {
            throw new LastErrorException(errorCode, "Failed to select region");
        }
    }

    public void fillRegion(Region region, Brush brush) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_FILL_REGION);
        long errorCode = function.invoke(result, this, region, brush);
        if (!result.getValue()) {
            throw new LastErrorException(errorCode, "Failed to fill region");
        }
    }

    public void frameRegion(Region region, Brush brush, int width, int heigh) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_FRAME_RGN);
        long errorCode = function.invoke((Parameter)result, new Parameter[]{this, region, brush, new Int(width), new Int(heigh)});
        if (!result.getValue()) {
            throw new LastErrorException(errorCode, "Failed to frame region");
        }
    }

    public int getPolyFillMode() {
        Int result = new Int();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_POLY_FILL_MODE);
        function.invoke((Parameter)result, this);
        return (int)result.getValue();
    }

    public boolean invertRegion(Region region) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_INVERT_RGN);
        function.invoke(result, this, region);
        return result.getValue();
    }

    public boolean paintRegion(Region region) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_PAINT_RGN);
        function.invoke(result, this, region);
        return result.getValue();
    }

    public void setPolyFillMode(PolyFillMode polyFillMode) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_SET_POLY_FILL_MODE);
        function.invoke(null, this, new Int(polyFillMode.getValue()));
    }

    public ColorRef getPixel(int x2, int y2) {
        ColorRef result = new ColorRef();
        Function function = Gdi32.get(FUNCTION_GET_PIXEL);
        function.invoke(result, this, new Int(x2), new Int(y2));
        return result;
    }

    public static ColorRef setDCBrushColor(DC hDC, ColorRef clrref) {
        ColorRef result = new ColorRef();
        Function function = Gdi32.get(FUNCTION_SET_DC_BRUSH_COLOR);
        function.invoke(result, hDC, clrref);
        return result;
    }

    public ColorRef setDCPenColor(DC hDC, ColorRef colorRef) {
        ColorRef color = new ColorRef();
        Function function = Gdi32.get(FUNCTION_SET_DC_PEN_COLOR);
        function.invoke(color, hDC, colorRef);
        return color;
    }

    private void transparentBlt32(Bitmap bitmap, int x2, int y2) {
        DC bitmapDC = DC.createCompatibleDC(this);
        Bitmap oldImageBitmap = bitmapDC.selectObject(bitmap);
        BlendFunction blendFunction = new BlendFunction();
        blendFunction.setSourceConstantAlpha(255);
        blendFunction.setAlphaFormat(1);
        this.alphaBlend(x2, y2, bitmap.getWidth(), bitmap.getHeight(), bitmapDC, 0, 0, bitmap.getWidth(), bitmap.getHeight(), blendFunction);
        bitmapDC.selectObject(oldImageBitmap);
        DC.deleteDC(bitmapDC);
    }

    public void transparentBlt(Bitmap bitmap, int x2, int y2) {
        if (bitmap.getBitCount() == 32) {
            this.transparentBlt32(bitmap, x2, y2);
        } else if (bitmap.getTransparentMask() != null) {
            this.transparentBlt(bitmap, bitmap.getTransparentMask(), x2, y2);
        }
    }

    public void paintBitmap(Bitmap bitmap, int x2, int y2) {
        if (bitmap.isTransparent()) {
            this.transparentBlt(bitmap, x2, y2);
        } else {
            this.paintOpaqueBitmap(bitmap, x2, y2);
        }
    }

    public void paintOpaqueBitmap(Bitmap bitmap, int x2, int y2) {
        DC tempDC = DC.createCompatibleDC(this);
        Bitmap oldBitmap = tempDC.selectObject(bitmap);
        DC.bitBlt(this, x2, y2, bitmap.getWidth(), bitmap.getHeight(), tempDC, 0, 0, RasterOperation.SRCCOPY);
        tempDC.selectObject(oldBitmap);
        DC.deleteDC(tempDC);
    }

    private void transparentBlt(Bitmap bitmap, Bitmap maskBitmap, int x2, int y2) {
        Size bitmapSize = bitmap.getSize();
        DC tempDC = DC.createCompatibleDC(this);
        DC maskDC = DC.createCompatibleDC(this);
        DC resultDC = DC.createCompatibleDC(this);
        DDBitmap resultBitmap = new DDBitmap(this, bitmapSize.getCx(), bitmapSize.getCy());
        DDBitmap workMaskBitmap = new DDBitmap(this, bitmapSize.getCx(), bitmapSize.getCy());
        Bitmap oldMaskBitmap = maskDC.selectObject(workMaskBitmap);
        Bitmap oldResultBitmap = resultDC.selectObject(resultBitmap);
        Bitmap oldBitmap = tempDC.selectObject(bitmap);
        this.copyImage(resultDC, bitmapSize, tempDC);
        tempDC.selectObject(maskBitmap);
        this.copyImage(maskDC, bitmapSize, tempDC);
        this.maskBackgroundForSourceImage(resultDC, maskDC, bitmapSize);
        this.combineBackgroundForeground(x2, y2, bitmapSize, maskDC, resultDC);
        tempDC.selectObject(oldBitmap);
        maskDC.selectObject(oldMaskBitmap);
        resultDC.selectObject(oldResultBitmap);
        resultBitmap.deleteObject();
        DC.deleteDC(resultDC);
        DC.deleteDC(maskDC);
        DC.deleteDC(tempDC);
    }

    private void maskBackgroundForSourceImage(DC resultDC, DC maskDC, Size bitmapSize) {
        resultDC.setBkColor(new ColorRef(Color.black));
        resultDC.setTextColor(new ColorRef(Color.white));
        DC.bitBlt(resultDC, 0, 0, bitmapSize.getCx(), bitmapSize.getCy(), maskDC, 0, 0, RasterOperation.SRCAND);
    }

    private void copyImage(DC resultDC, Size bitmapSize, DC tempDC) {
        DC.bitBlt(resultDC, 0, 0, bitmapSize.getCx(), bitmapSize.getCy(), tempDC, 0, 0, RasterOperation.SRCCOPY);
    }

    private void combineBackgroundForeground(int x2, int y2, Size bitmapSize, DC maskDC, DC resultDC) {
        maskDC.patBlt(0, 0, bitmapSize.getCx(), bitmapSize.getCy(), RasterOperation.DSTINVERT);
        DC.bitBlt(this, x2, y2, bitmapSize.getCx(), bitmapSize.getCy(), maskDC, 0, 0, RasterOperation.SRCAND);
        DC.bitBlt(this, x2, y2, bitmapSize.getCx(), bitmapSize.getCy(), resultDC, 0, 0, RasterOperation.SRCPAINT);
    }

    public boolean alphaBlend(int xDest, int yDest, int widthDest, int heightDest, DC hdcSrc, int xSrc, int ySrc, int widthSrc, int heightSrc, BlendFunction blendFunction) {
        Bool result = new Bool();
        Msimg32.getInstance().getFunction(FUNCTION_ALPHA_BLEND).invoke((Parameter)result, new Parameter[]{this, new Int(xDest), new Int(yDest), new Int(widthDest), new Int(heightDest), hdcSrc, new Int(xSrc), new Int(ySrc), new Int(widthSrc), new Int(heightSrc), blendFunction});
        return result.getValue();
    }

    public void drawGrayed(DC srcDC, Rect destRect) {
        int width = destRect.getWidth();
        int height = destRect.getHeight();
        int x2 = (int)destRect.getLeft();
        int y2 = (int)destRect.getTop();
        DC maskDC = DC.createCompatibleDC(this);
        DDBitmap maskBitmap = new DDBitmap(this, width, height);
        Bitmap oldMaskBitmap = maskDC.selectObject(maskBitmap);
        DC imageDC = DC.createCompatibleDC(this);
        DDBitmap imageBitmap = new DDBitmap(this, width, height);
        Bitmap oldImageBitmap = imageDC.selectObject(imageBitmap);
        DC.bitBlt(maskDC, 0, 0, width, height, srcDC, 0, 0, RasterOperation.SRCCOPY);
        DC.bitBlt(this, x2 + 1, y2 + 1, width, height, maskDC, 0, 0, RasterOperation.MERGEPAINT);
        DC.bitBlt(this, x2, y2, width, height, maskDC, 0, 0, RasterOperation.SRCAND);
        Rect rect = new Rect(0L, 0L, width, height);
        LogBrush logBrush = new LogBrush();
        logBrush.setColor(new ColorRef(new Color(127, 127, 127)));
        Brush brush = Brush.createBrushIndirect(logBrush);
        imageDC.fillRect(rect, brush);
        brush.deleteObject();
        maskDC.patBlt(0, 0, width, height, RasterOperation.DSTINVERT);
        DC.bitBlt(imageDC, 0, 0, width, height, maskDC, 0, 0, RasterOperation.SRCAND);
        DC.bitBlt(this, x2, y2, width, height, imageDC, 0, 0, RasterOperation.SRCPAINT);
        imageDC.selectObject(oldImageBitmap);
        imageBitmap.deleteObject();
        DC.deleteDC(imageDC);
        maskDC.selectObject(oldMaskBitmap);
        maskBitmap.deleteObject();
        DC.deleteDC(maskDC);
    }

    public void fillRect(Rect rect, Brush brush) {
        Region region = Region.createRectRegion(rect);
        this.fillRegion(region, brush);
        region.deleteObject();
    }

    public void maskBlt(Bitmap.PredefinedBitmap predefinedMaskBitmap, int x2, int y2, Brush fgBrush) {
        DC bitmapDC = DC.createCompatibleDC(this);
        DDBitmap bitmap = new DDBitmap(predefinedMaskBitmap);
        Bitmap oldBitmap = bitmapDC.selectObject(bitmap);
        Size bitmapSize = bitmap.getSize();
        int width = bitmapSize.getCx();
        int height = bitmapSize.getCy();
        DC maskDC = DC.createCompatibleDC(this);
        DDBitmap maskBitmap = new DDBitmap(this, width, height);
        Bitmap oldMaskBitmap = maskDC.selectObject(maskBitmap);
        DC fgDC = DC.createCompatibleDC(this);
        DDBitmap fgBitmap = new DDBitmap(this, width, height);
        Bitmap oldFgBitmap = fgDC.selectObject(fgBitmap);
        DC.bitBlt(maskDC, 0, 0, width, height, bitmapDC, 0, 0, RasterOperation.SRCCOPY);
        DC.bitBlt(this, x2, y2, width, height, maskDC, 0, 0, RasterOperation.SRCAND);
        maskDC.patBlt(0, 0, width, height, RasterOperation.DSTINVERT);
        Brush oldBrush = fgDC.selectObject(fgBrush);
        DC.bitBlt(fgDC, 0, 0, width, height, maskDC, 0, 0, RasterOperation.MERGECOPY);
        fgDC.selectObject(oldBrush);
        DC.bitBlt(this, x2, y2, width, height, fgDC, 0, 0, RasterOperation.SRCPAINT);
        fgDC.selectObject(oldFgBitmap);
        fgBitmap.deleteObject();
        DC.deleteDC(fgDC);
        maskDC.selectObject(oldMaskBitmap);
        maskBitmap.deleteObject();
        DC.deleteDC(maskDC);
        bitmapDC.selectObject(oldBitmap);
        bitmap.deleteObject();
        DC.deleteDC(bitmapDC);
    }

    public boolean gradientFill(Rect rect, Color leftColor, Color rightColor) {
        Function function = Msimg32.getInstance().getFunction(FUNCTION_GRADIENT_FILL);
        TriVertex leftUpperVertex = new TriVertex();
        TriVertex rightLowerVertex = new TriVertex();
        this.initVertex(leftUpperVertex, leftColor, rect.getLeft(), rect.getTop());
        this.initVertex(rightLowerVertex, rightColor, rect.getRight(), rect.getBottom());
        GradientRect gradients = new GradientRect();
        gradients.setUpperLeft(0L);
        gradients.setLowerRight(1L);
        ComplexArray vertices = new ComplexArray(new TriVertex(), 2);
        vertices.setElement(0, leftUpperVertex);
        vertices.setElement(1, rightLowerVertex);
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{this, new Pointer(vertices), new ULongInt(2L), new Pointer(new ComplexArray(new Parameter[]{gradients})), new ULongInt(1L), new ULongInt(0L)});
        return result.getValue();
    }

    private void initVertex(TriVertex vertex, Color color, long x2, long y2) {
        vertex.setX(x2);
        vertex.setY(y2);
        vertex.setRed(color.getRed() << 8);
        vertex.setGreen(color.getGreen() << 8);
        vertex.setBlue(color.getBlue() << 8);
        vertex.setAlpha(0);
    }

    public boolean lineTo(int x2, int y2) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_LINE_TO);
        Bool result = new Bool();
        function.invoke(result, this, new Int(x2), new Int(y2));
        return result.getValue();
    }

    public boolean moveTo(int x2, int y2) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_MOVE_TO_EX);
        Bool result = new Bool();
        function.invoke(result, this, new Int(x2), new Int(y2), new Handle());
        return result.getValue();
    }

    public boolean drawRectangle(Rect rect) {
        this.moveTo(rect.getLeftAsInt(), rect.getTopAsInt());
        this.lineTo(rect.getRightAsInt(), rect.getTopAsInt());
        this.lineTo(rect.getRightAsInt(), rect.getBottomAsInt());
        this.lineTo(rect.getLeftAsInt(), rect.getBottomAsInt());
        this.lineTo(rect.getLeftAsInt(), rect.getTopAsInt());
        return true;
    }

    public MappingMode setMapMode(MappingMode mode) {
        Function function = Gdi32.get(FUNCTION_SetMapMode);
        Int result = new Int();
        function.invoke(result, this, new Int(mode.getValue()));
        MappingMode item = (MappingMode)Enums.getItem(class$com$jniwrapper$win32$gdi$DC$MappingMode == null ? (class$com$jniwrapper$win32$gdi$DC$MappingMode = DC.class$("com.jniwrapper.win32.gdi.DC$MappingMode")) : class$com$jniwrapper$win32$gdi$DC$MappingMode, (int)result.getValue());
        return item;
    }

    public int getDeviceCaps(int index) {
        Function function = Gdi32.get(FUNCTION_GetDeviceCaps);
        Int result = new Int();
        function.invoke(result, this, new Int(index));
        return (int)result.getValue();
    }

    public int intersectClipRect(int left, int top, int right, int bottom) {
        Function function = Gdi32.get(FUNCTION_IntersectClipRect);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{this, new Int(left), new Int(top), new Int(right), new Int(bottom)});
        return (int)result.getValue();
    }

    public boolean rectangle(int left, int top, int right, int bottom) {
        Function function = Gdi32.get(FUNCTION_RECTANGLE);
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{this, new Int(left), new Int(top), new Int(right), new Int(bottom)});
        return result.getValue();
    }

    public boolean roundRect(int left, int top, int right, int bottom, int arcWidth, int arcHeight) {
        Function function = Gdi32.get(FUNCTION_ROUND_RECT);
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{this, new Int(left), new Int(top), new Int(right), new Int(bottom), new Int(arcWidth), new Int(arcHeight)});
        return result.getValue();
    }

    public boolean fillRectangle(int left, int top, int right, int bottom) {
        Function function = User32.getInstance().getFunction(FUNCTION_FILL_RECT);
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{this, new Int(left), new Int(top), new Int(right), new Int(bottom)});
        return result.getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MappingMode
    extends EnumItem {
        public static MappingMode TEXT = new MappingMode(1);
        public static MappingMode LOMETRIC = new MappingMode(2);
        public static MappingMode HIMETRIC = new MappingMode(3);
        public static MappingMode LOENGLISH = new MappingMode(4);
        public static MappingMode HIENGLISH = new MappingMode(5);
        public static MappingMode TWIPS = new MappingMode(6);
        public static MappingMode ISOTROPIC = new MappingMode(7);
        public static MappingMode ANISOTROPIC = new MappingMode(8);

        private MappingMode(int value) {
            super(value);
        }
    }

    public static class RasterOperation
    extends EnumItem {
        public static final RasterOperation BLACKNESS = new RasterOperation(66);
        public static final RasterOperation CAPTUREBLT = new RasterOperation(0x40000000);
        public static final RasterOperation DSTINVERT = new RasterOperation(0x550009);
        public static final RasterOperation MERGECOPY = new RasterOperation(0xC000CA);
        public static final RasterOperation MERGEPAINT = new RasterOperation(12255782);
        public static final RasterOperation NOMIRRORBITMAP = new RasterOperation(Integer.MIN_VALUE);
        public static final RasterOperation NOTSRCCOPY = new RasterOperation(0x330008);
        public static final RasterOperation NOTSRCERASE = new RasterOperation(1114278);
        public static final RasterOperation PATCOPY = new RasterOperation(15728673);
        public static final RasterOperation PATINVERT = new RasterOperation(5898313);
        public static final RasterOperation PATPAINT = new RasterOperation(16452105);
        public static final RasterOperation SRCAND = new RasterOperation(8913094);
        public static final RasterOperation SRCCOPY = new RasterOperation(0xCC0020);
        public static final RasterOperation SRCERASE = new RasterOperation(4457256);
        public static final RasterOperation SRCINVERT = new RasterOperation(0x660046);
        public static final RasterOperation SRCPAINT = new RasterOperation(15597702);
        public static final RasterOperation WHITENESS = new RasterOperation(16711778);

        private RasterOperation(int value) {
            super(value);
        }

        public static RasterOperation or(RasterOperation[] operations) {
            int result = 0;
            for (int i2 = 0; i2 < operations.length; ++i2) {
                result |= operations[i2].getValue();
            }
            return new RasterOperation(result);
        }
    }
}

