/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Gdi32;

public abstract class GdiObject
extends Handle {
    public static final int GDI_ERROR = -1;
    public static final int HGDI_ERROR = -1;
    static final FunctionName FUNCTION_GET_OBJECT = new FunctionName("GetObject");
    static final String FUNCTION_DELETE_OBJECT = "DeleteObject";
    static final String FUNCTION_GET_OBJECT_TYPE = "GetObjectType";

    public GdiObject() {
    }

    public GdiObject(long value) {
        super(value);
    }

    public void deleteObject() {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_DELETE_OBJECT);
        Bool result = new Bool();
        long errorCode = function.invoke((Parameter)result, this);
        if (!result.getValue()) {
            throw new LastErrorException(errorCode, "Failed to delete object");
        }
    }

    public long getObject(GdiObject object, Parameter data) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_OBJECT.toString());
        Int result = new Int();
        int length = data.getLength();
        long errorCode = function.invoke(result, object, new Int(length), new Pointer(data));
        if (result.getValue() == 0L || (long)length != result.getValue()) {
            throw new LastErrorException(errorCode, "Failed to get object.");
        }
        return result.getValue();
    }

    public Type getObjectType() {
        UInt32 result = new UInt32();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_OBJECT_TYPE);
        function.invoke((Parameter)result, this);
        return new Type((int)result.getValue());
    }

    public static class Type
    extends EnumItem {
        public static final Type PEN = new Type(1);
        public static final Type BRUSH = new Type(2);
        public static final Type DC = new Type(3);
        public static final Type METADC = new Type(4);
        public static final Type PAL = new Type(5);
        public static final Type FONT = new Type(6);
        public static final Type BITMAP = new Type(7);
        public static final Type REGION = new Type(8);
        public static final Type METAFILE = new Type(9);
        public static final Type MEMDC = new Type(10);
        public static final Type EXTPEN = new Type(11);
        public static final Type ENHMETADC = new Type(12);
        public static final Type ENHMETAFILE = new Type(13);

        private Type(int value) {
            super(value);
        }
    }

    public static class ImageLoadParameters
    extends FlagSet {
        public static final int DEFAULTCOLOR = 0;
        public static final int MONOCHROME = 1;
        public static final int COLOR = 2;
        public static final int COPYRETURNORG = 4;
        public static final int COPYDELETEORG = 8;
        public static final int LOADFROMFILE = 16;
        public static final int LOADTRANSPARENT = 32;
        public static final int DEFAULTSIZE = 64;
        public static final int VGACOLOR = 128;
        public static final int LOADMAP3DCOLORS = 4096;
        public static final int CREATEDIBSECTION = 8192;
        public static final int COPYFROMRESOURCE = 16384;
        public static final int SHARED = 32768;
    }

    public static class ImageType
    extends EnumItem {
        public static final ImageType BITMAP = new ImageType(0);
        public static final ImageType ICON = new ImageType(1);
        public static final ImageType CURSOR = new ImageType(2);
        public static final ImageType ENHMETAFILE = new ImageType(3);

        private ImageType(int value) {
            super(value);
        }
    }
}

