/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.PolyFillMode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Region
extends GdiObject {
    static final String FUNCTION_CREATE_ELLIPTIC_RGN = "CreateEllipticRgn";
    static final String FUNCTION_CREATE_ELLIPTIC_RGN_INDIRECT = "CreateEllipticRgnIndirect";
    static final String FUNCTION_COMBINE_RGN = "CombineRgn";
    static final String FUNCTION_CREATE_POLYGON_RGN = "CreatePolygonRgn";
    static final String FUNCTION_CREATE_POLY_POLYGON_RGN = "CreatePolyPolygonRgn";
    static final String FUNCTION_CREATE_RECT_RGN = "CreateRectRgn";
    static final String FUNCTION_CREATE_RECT_RGN_INDIRECT = "CreateRectRgnIndirect";
    static final String FUNCTION_CREATE_ROUND_RECT_RGN = "CreateRoundRectRgn";
    static final String FUNCTION_EQUAL_RGN = "EqualRgn";
    static final String FUNCTION_GET_REGION_DATA = "GetRegionData";
    static final String FUNCTION_GET_RGN_BOX = "GetRgnBox";
    static final String FUNCTION_OFFSET_RGN = "OffsetRgn";
    static final String FUNCTION_POINT_IN_REGION = "PtInRegion";
    static final String FUNCTION_RECT_IN_REGION = "RectInRegion";
    static final String FUNCTION_SET_RECT_RGN = "SetRectRgn";
    public static final int RGN_ERROR = 0;
    public static final int NULLREGION = 1;
    public static final int SIMPLEREGION = 2;
    public static final int COMPLEXREGION = 3;
    static /* synthetic */ Class class$com$jniwrapper$win32$Point;
    static /* synthetic */ Class class$com$jniwrapper$Int;

    public Region() {
    }

    public Region(long value) {
        super(value);
    }

    public static Region createElliptic(int left, int top, int right, int bottom) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_ELLIPTIC_RGN);
        Region result = new Region();
        function.invoke(result, new Int(left), new Int(top), new Int(right), new Int(bottom));
        return result;
    }

    public static Region createElliptic(Rect rect) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_ELLIPTIC_RGN_INDIRECT);
        function.invoke((Parameter)result, new Pointer(rect));
        return null;
    }

    public static Region createRoundRectRegion(int left, int top, int right, int bottom, int ellipseWidth, int ellipseHight) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_ROUND_RECT_RGN);
        function.invoke((Parameter)result, new Parameter[]{new Int(left), new Int(top), new Int(right), new Int(bottom), new Int(ellipseWidth), new Int(ellipseHight)});
        return result;
    }

    public static Region combineRgn(Region srcRgn1, Region srcRgn2, CombineMode combineMode) {
        Region result = Region.createRectRegion(0, 0, 0, 0);
        Int resultRgnType = new Int();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_COMBINE_RGN);
        long errorCode = function.invoke(resultRgnType, result, srcRgn1, srcRgn2, new Int(combineMode.getValue()));
        long value = resultRgnType.getValue();
        if (0L == value) {
            throw new LastErrorException(errorCode, "Failed to combine regions.");
        }
        return result;
    }

    public static Region createPolygonRgn(Point[] points, int nPoints, PolyFillMode polyFillMode) {
        PrimitiveArray pointsArray = new PrimitiveArray(class$com$jniwrapper$win32$Point == null ? (class$com$jniwrapper$win32$Point = Region.class$("com.jniwrapper.win32.Point")) : class$com$jniwrapper$win32$Point, nPoints);
        for (int i2 = 0; i2 < nPoints; ++i2) {
            pointsArray.setElement(i2, points[i2]);
        }
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_POLYGON_RGN);
        function.invoke(result, new Pointer(pointsArray), new Int(nPoints), new Int(polyFillMode.getValue()));
        return result;
    }

    public static Region createPolyPolygonRgn(Point[] points, int[] polyCounts, int count, PolyFillMode polyFillMode) {
        Region result = new Region();
        int length = points.length;
        PrimitiveArray pointsArray = new PrimitiveArray(class$com$jniwrapper$win32$Point == null ? (class$com$jniwrapper$win32$Point = Region.class$("com.jniwrapper.win32.Point")) : class$com$jniwrapper$win32$Point, length);
        for (int i2 = 0; i2 < length; ++i2) {
            pointsArray.setElement(i2, points[i2]);
        }
        PrimitiveArray polyCountsArray = new PrimitiveArray(class$com$jniwrapper$Int == null ? (class$com$jniwrapper$Int = Region.class$("com.jniwrapper.Int")) : class$com$jniwrapper$Int, count);
        for (int i3 = 0; i3 < length; ++i3) {
            polyCountsArray.setElement(i3, new Int(polyCounts[i3]));
        }
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_POLY_POLYGON_RGN);
        function.invoke(result, new Pointer(pointsArray), new Pointer(polyCountsArray), new Int(count), new Int(polyFillMode.getValue()));
        return result;
    }

    public static Region createRectRegion(int left, int top, int right, int bottom) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_RECT_RGN);
        function.invoke((Parameter)result, new Parameter[]{new Int(left), new Int(top), new Int(right), new Int(bottom)});
        return result;
    }

    public static Region createRectRegion(Rect rect) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_RECT_RGN_INDIRECT);
        function.invoke((Parameter)result, new Pointer(rect));
        return result;
    }

    public boolean equalRegion(Region region) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_RECT_RGN);
        function.invoke(result, this, region);
        return result.getValue();
    }

    public int getRagionData(PrimitiveArray rgnData, int count) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_REGION_DATA);
        UInt32 returnValue = new UInt32();
        function.invoke(returnValue, this, new UInt32(count), new Pointer(rgnData));
        return (int)returnValue.getValue();
    }

    public Rect getRegionBox() {
        Rect result = new Rect();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_RGN_BOX);
        Int returnResult = new Int();
        function.invoke(returnResult, this, new Pointer(result));
        return result;
    }

    public void offsetRegion(int xOffset, int yOffset) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_OFFSET_RGN);
        function.invoke(null, this, new Int(xOffset), new Int(yOffset));
    }

    public boolean isPointInRegion(int x2, int y2) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_POINT_IN_REGION);
        function.invoke(result, this, new Int(x2), new Int(y2));
        return result.getValue();
    }

    public boolean isPointInRegion(Point point) {
        return this.isPointInRegion((int)point.getY(), (int)point.getY());
    }

    public boolean isRectInRegion(Rect rect) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_RECT_IN_REGION);
        function.invoke(result, this, new Pointer(rect));
        return result.getValue();
    }

    public void setRectRegion(int left, int top, int right, int bottom) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_SET_RECT_RGN);
        function.invoke(null, new Parameter[]{this, new Int(left), new Int(top), new Int(right), new Int(bottom)});
    }

    public static Region createFromImage(Image image, Color transparent) {
        return Region.createFromImage(image, transparent, null);
    }

    public static Region createFromImage(Image image, Color transparent, Color tolerance) {
        if (image == null || transparent == null) {
            throw new IllegalArgumentException();
        }
        if (tolerance == null) {
            tolerance = new Color(0x101010);
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, transparent, null);
        graphics2D.dispose();
        Region result = Region.createRectRegion(new Rect());
        int transparentRedValue = transparent.getRed();
        int transparentGreenValue = transparent.getGreen();
        int transparentBlueValue = transparent.getBlue();
        int toleranceRedValue = Math.min(transparentRedValue + tolerance.getRed(), 255);
        int toleranceGreenValue = Math.min(transparentGreenValue + tolerance.getGreen(), 255);
        int toleranceBlueValue = Math.min(transparentBlueValue + tolerance.getBlue(), 255);
        for (int x2 = 0; x2 < width; ++x2) {
            boolean continuous = false;
            int yBegin = 0;
            for (int y2 = 0; y2 < height; ++y2) {
                int greenValue;
                int rgb = bufferedImage.getRGB(x2, y2);
                int redValue = (rgb & 0xFF0000) >> 16;
                boolean isTransparent = false;
                if (redValue >= transparentRedValue && redValue <= toleranceRedValue && (greenValue = (rgb & 0xFF00) >> 8) >= transparentGreenValue && greenValue <= toleranceGreenValue) {
                    int blueVale = rgb & 0xFF;
                    boolean bl = isTransparent = blueVale >= transparentBlueValue && blueVale <= toleranceBlueValue;
                }
                if (isTransparent) {
                    if (!continuous) continue;
                    continuous = false;
                    Region rectRegion = Region.createRectRegion(x2, yBegin, x2 + 1, y2 - 1);
                    Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
                    result.deleteObject();
                    result = newResult;
                    rectRegion.deleteObject();
                    continue;
                }
                if (continuous) continue;
                continuous = true;
                yBegin = y2;
            }
            if (!continuous) continue;
            Region rectRegion = Region.createRectRegion(x2, yBegin, x2 + 1, height);
            Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
            result.deleteObject();
            result = newResult;
            rectRegion.deleteObject();
        }
        return result;
    }

    public static Region createFromImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        Region result = Region.createRectRegion(new Rect());
        for (int x2 = 0; x2 < width; ++x2) {
            boolean continuous = false;
            int yBegin = 0;
            for (int y2 = 0; y2 < height; ++y2) {
                boolean isTransparent;
                int argb = bufferedImage.getRGB(x2, y2);
                boolean bl = isTransparent = (argb & 0xFF000000) >> 24 == 0;
                if (isTransparent) {
                    if (!continuous) continue;
                    continuous = false;
                    Region rectRegion = Region.createRectRegion(x2, yBegin, x2 + 1, y2 - 1);
                    Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
                    result.deleteObject();
                    result = newResult;
                    rectRegion.deleteObject();
                    continue;
                }
                if (continuous) continue;
                continuous = true;
                yBegin = y2;
            }
            if (!continuous) continue;
            Region rectRegion = Region.createRectRegion(x2, yBegin, x2 + 1, height);
            Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
            result.deleteObject();
            result = newResult;
            rectRegion.deleteObject();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CombineMode
    extends EnumItem {
        public static final CombineMode AND = new CombineMode(1);
        public static final CombineMode OR = new CombineMode(2);
        public static final CombineMode XOR = new CombineMode(3);
        public static final CombineMode DIFF = new CombineMode(4);
        public static final CombineMode COPY = new CombineMode(5);
        public static final CombineMode MIN = AND;
        public static final CombineMode MAX = COPY;

        private CombineMode(int value) {
            super(value);
        }
    }
}

