/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi.bitmap;

public class ARGB {
    private int _argb = 0;

    public ARGB(int argb) {
        this._argb = argb;
    }

    public ARGB(int alpha, int red, int green, int blue) {
        this._argb = 0;
        this.setAlpha(alpha);
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    private void setColorComponent(int index, int val) {
        if (index >= 0 && index <= 3) {
            int offset = 8 * index;
            this._argb |= val << offset;
        } else {
            throw new RuntimeException("Invalid index for component");
        }
    }

    private int getColorComponent(int index) {
        if (index >= 0 && index <= 3) {
            int offset = 8 * index;
            int mask = 255 << offset;
            int result = (this._argb & mask) >> offset;
            return result;
        }
        throw new RuntimeException("Invalid index for component");
    }

    public int getAlpha() {
        return this.getColorComponent(3);
    }

    public int getRed() {
        return this.getColorComponent(2);
    }

    public int getGreen() {
        return this.getColorComponent(1);
    }

    public int getBlue() {
        return this.getColorComponent(0);
    }

    public void setAlpha(int val) {
        this.setColorComponent(3, val);
    }

    public void setRed(int val) {
        this.setColorComponent(2, val);
    }

    public void setGreen(int val) {
        this.setColorComponent(1, val);
    }

    public void setBlue(int val) {
        this.setColorComponent(0, val);
    }

    public int getValue() {
        return this._argb;
    }
}

