/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi.bitmap;

import com.jniwrapper.win32.gdi.bitmap.ARGB;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderDirectColorModel;
import java.awt.image.BufferedImage;

class Bitmap32BitBuilder
extends BitmapBuilderDirectColorModel {
    public Bitmap32BitBuilder(BufferedImage bufferedImage) {
        super(32, bufferedImage);
    }

    public void setPixel(ARGB argb, int offset) {
        byte r2 = (byte)argb.getRed();
        byte g2 = (byte)argb.getGreen();
        byte b2 = (byte)argb.getBlue();
        byte a2 = (byte)argb.getAlpha();
        if (a2 != -1) {
            r2 = this.getTransparentColor(r2, a2);
            g2 = this.getTransparentColor(g2, a2);
            b2 = this.getTransparentColor(b2, a2);
        }
        this.setBitmapByte(offset + 3, a2);
        this.setBitmapByte(offset + 2, r2);
        this.setBitmapByte(offset + 1, g2);
        this.setBitmapByte(offset, b2);
    }

    private byte getTransparentColor(byte c2, byte a2) {
        if (a2 == -1) {
            return (byte)c2;
        }
        int color = c2 >= 0 ? c2 : c2 + 256;
        int alpha = a2 >= 0 ? a2 : a2 + 256;
        int result = color * alpha / 255;
        return (byte)result;
    }
}

