/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi.bitmap;

import com.jniwrapper.ArrayParameter;
import com.jniwrapper.Int8;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public abstract class BitmapBuilder {
    private static final int DWORD_SIZE = 32;
    private static final int BYTES_IN_DWORD = 4;
    private int _bitCount;
    private BufferedImage _bufferedImage;
    private int _scansizeBytes;
    private PrimitiveArray _bitmapData;

    protected BitmapBuilder(int bitCount, BufferedImage bufferedImage) {
        this._bitCount = bitCount;
        this._bufferedImage = bufferedImage;
        this._scansizeBytes = this.calculateScansizeBytes();
        this._bitmapData = new PrimitiveArray(this.createBitsArray(this.getScansizeBytes() * this.getHeight()));
    }

    public final BitmapInfo getBitmapInfo() {
        BitmapInfo result = this.getColorTableSize() > 0 ? new BitmapInfo(this.getColorTableSize()) : new BitmapInfo();
        this.buildColorTable(result.getColors());
        BitmapInfoHeader bitmapInfoHeader = result.getBitmapInfoHeader();
        bitmapInfoHeader.setWidth(this.getWidth());
        bitmapInfoHeader.setHeight(this.getHeight());
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(this.getBitCount());
        bitmapInfoHeader.setClrUsed(this.getColorTableSize());
        return result;
    }

    public abstract void setBitmapColors();

    protected int getBitCount() {
        return this._bitCount;
    }

    protected final int getScansizeBytes() {
        return this._scansizeBytes;
    }

    private int calculateScansizeBytes() {
        int bitsPerRow = this.getWidth() * this.getBitCount();
        return (bitsPerRow + 32 - 1) / 32 * 4;
    }

    protected void setBitmapByte(int offset, byte value) {
        this._bitmapData.setElement(offset, new Int8(value));
    }

    public int getWidth() {
        return this._bufferedImage.getWidth();
    }

    public int getHeight() {
        return this._bufferedImage.getHeight();
    }

    private byte[] createBitsArray(int size) {
        return new byte[size];
    }

    protected abstract int getColorTableSize();

    protected abstract void buildColorTable(ArrayParameter var1);

    protected int getImageOffset(int x2, int y2) {
        return x2 + y2 * this.getWidth();
    }

    protected int getOffsetInBitmapBytes(int x2, int y2) {
        return this.getBitCount() * x2 / 8 + (this.getHeight() - y2 - 1) * this.getScansizeBytes();
    }

    public abstract Image getTransparentMask();

    protected BufferedImage getBufferedImage() {
        return this._bufferedImage;
    }

    protected ColorModel getColorModel() {
        return this._bufferedImage.getColorModel();
    }

    public PrimitiveArray getBitmapData() {
        return this._bitmapData;
    }
}

