/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.io.FileInfo;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemException;
import com.jniwrapper.win32.io.FileSystemWatcher;
import com.jniwrapper.win32.io.FolderInfo;
import com.jniwrapper.win32.io.WatcherStrategy;
import com.jniwrapper.win32.system.Kernel32;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class Win9xWatcherStrategy
extends WatcherStrategy
implements Comparator {
    static final FunctionName FUNCTION_FIND_FIRST_CHANGE_NOTIFICATION = new FunctionName("FindFirstChangeNotification");
    static final String FUNCTION_FIND_NEXT_CHANGE_NOTIFICATION = "FindNextChangeNotification";
    static final String FUNCTION_FIND_CLOSE_CHANGE_NOTIFICATION = "FindCloseChangeNotification";
    static final int INFINITE_TIMEOUT = -1;
    static final int WAIT_ABANDONED = 128;
    static final int WAIT_OBJECT_0 = 0;
    static final int WAIT_TIMEOUT = 258;
    private Handle _changeHandle = new Handle();
    private FolderInfo _folderInfo;
    private Thread _watcherThread;

    public Win9xWatcherStrategy(FileSystemWatcher fileSystemWatcher) {
        super(fileSystemWatcher);
    }

    public void start() throws FileSystemException {
        final FileSystemWatcher watcher = this.getFileSystemWatcher();
        File folder = new File(watcher.getPath());
        if (!folder.exists()) {
            throw new FileSystemException("Folder \"" + folder + "\" does not exist.");
        }
        this._folderInfo = new FolderInfo(watcher.getPath(), watcher.getFileFilter(), watcher.isWatchSubree());
        this._folderInfo.load();
        Function findFirstChangeNotification = Kernel32.getInstance().getFunction(FUNCTION_FIND_FIRST_CHANGE_NOTIFICATION.toString());
        int errorCode = (int)findFirstChangeNotification.invoke(this._changeHandle, new Str(watcher.getPath()), new Bool(watcher.isWatchSubree()), new UInt32(watcher.getOptions().getFlags()));
        if (this._changeHandle.getValue() == -1L) {
            throw new FileSystemException(errorCode);
        }
        this._watcherThread = new Thread(new Runnable(){

            public void run() {
                Win9xWatcherStrategy.this.setWatching(true);
                block4: while (Win9xWatcherStrategy.this.isWatching()) {
                    long waitStatus = Handle.waitFor(Win9xWatcherStrategy.this._changeHandle);
                    switch ((int)waitStatus) {
                        case 128: 
                        case 258: {
                            Win9xWatcherStrategy.this.setWatching(false);
                            continue block4;
                        }
                        case 0: {
                            FolderInfo newFolderInfo = new FolderInfo(watcher.getPath(), watcher.getFileFilter(), watcher.isWatchSubree());
                            newFolderInfo.load();
                            Function findNextChangeNotification = Kernel32.getInstance().getFunction(Win9xWatcherStrategy.FUNCTION_FIND_NEXT_CHANGE_NOTIFICATION);
                            Bool result = new Bool();
                            findNextChangeNotification.invoke((Parameter)result, Win9xWatcherStrategy.this._changeHandle);
                            if (!result.getValue()) {
                                Win9xWatcherStrategy.this.setWatching(false);
                                continue block4;
                            }
                            FileSystemEvent event = Win9xWatcherStrategy.this.findDifference(Win9xWatcherStrategy.this._folderInfo, newFolderInfo);
                            if (event != null && Win9xWatcherStrategy.this.isWatching()) {
                                watcher.fireFileSystemEvent(event);
                            }
                            Win9xWatcherStrategy.this._folderInfo = newFolderInfo;
                            continue block4;
                        }
                    }
                    Win9xWatcherStrategy.this.setWatching(false);
                }
            }
        });
        this._watcherThread.start();
    }

    public void stop() throws FileSystemException {
        this.setWatching(false);
        Kernel32 kernel32 = Kernel32.getInstance();
        Function findCloseChangeNotification = kernel32.getFunction(FUNCTION_FIND_CLOSE_CHANGE_NOTIFICATION);
        Bool result = new Bool();
        int errorCode = (int)findCloseChangeNotification.invoke((Parameter)result, this._changeHandle);
        if (!result.getValue()) {
            throw new FileSystemException(errorCode);
        }
    }

    private FileInfo findChanged(FolderInfo oldFolderInfo, FolderInfo newFolderInfo) {
        Collections.sort(oldFolderInfo.getFiles(), this);
        Collections.sort(newFolderInfo.getFiles(), this);
        FileInfo result = null;
        Iterator i2 = oldFolderInfo.getFiles().iterator();
        while (i2.hasNext()) {
            Object element = i2.next();
            int index = Collections.binarySearch(newFolderInfo.getFiles(), element, this);
            if (index >= 0) {
                FolderInfo newFolder;
                FolderInfo oldSubfolder;
                if (!(element instanceof FolderInfo) || (result = this.findChanged(oldSubfolder = (FolderInfo)element, newFolder = (FolderInfo)newFolderInfo.getFiles().get(index))) == null) continue;
                break;
            }
            result = (FileInfo)element;
            break;
        }
        return result;
    }

    private FileSystemEvent findDifference(FolderInfo oldFolder, FolderInfo newFolder) {
        int newFolderSize;
        FileSystemEvent result = null;
        int fileAction = -1;
        int oldFolderSize = oldFolder.getFileCount();
        if (oldFolderSize == (newFolderSize = newFolder.getFileCount())) {
            fileAction = 3;
        } else if (oldFolderSize < newFolderSize) {
            fileAction = 1;
        } else if (oldFolderSize > newFolderSize) {
            fileAction = 2;
        }
        switch (fileAction) {
            case 3: {
                FileInfo fileInfo1 = this.findChanged(newFolder, oldFolder);
                FileInfo fileInfo2 = this.findChanged(oldFolder, newFolder);
                if (fileInfo1 != null && fileInfo2 != null && !fileInfo1.getFileName().equals(fileInfo2.getFileName())) {
                    result = new FileSystemEvent(newFolder, 4, fileInfo2, fileInfo1);
                    break;
                }
                if (fileInfo1 == null) break;
                result = new FileSystemEvent(newFolder, fileAction, fileInfo1);
                break;
            }
            case 1: {
                FileInfo fileInfo = this.findChanged(newFolder, oldFolder);
                if (fileInfo == null) break;
                result = new FileSystemEvent(newFolder, fileAction, fileInfo);
                break;
            }
            case 2: {
                FileInfo fileInfo = this.findChanged(oldFolder, newFolder);
                if (fileInfo == null) break;
                result = new FileSystemEvent(oldFolder, fileAction, fileInfo);
            }
        }
        return result;
    }

    public int compare(Object o1, Object o2) {
        FileInfo fileInfo1 = (FileInfo)o1;
        FileInfo fileInfo2 = (FileInfo)o2;
        FileSystemWatcher.WatcherOptions options = this.getFileSystemWatcher().getOptions();
        int result = fileInfo1.getFileName().compareTo(fileInfo2.getFileName());
        if (result == 0 && options.isNotifyChangeAttributes()) {
            result = (int)fileInfo1.getAttributes() - (int)fileInfo2.getAttributes();
        }
        if (result == 0 && options.isNotifyChangeSize()) {
            result = (int)fileInfo1.getSize() - (int)fileInfo2.getSize();
        }
        if (result == 0 && options.isNotifyLastModified() && !(fileInfo1 instanceof FolderInfo) && !(fileInfo2 instanceof FolderInfo)) {
            result = (int)fileInfo1.getLastModified() - (int)fileInfo2.getLastModified();
        }
        return result;
    }
}

