/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process;

import com.jniwrapper.Bool;
import com.jniwrapper.ExternalStringPointer;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.process.Process;
import com.jniwrapper.win32.process.StartupInfo;
import com.jniwrapper.win32.system.Kernel32;

public class CurrentProcess
extends Process {
    private static final String FUNCTION_GetCurrentProcess = "GetCurrentProcess";
    private static final String FUNCTION_GetCurrentProcessId = "GetCurrentProcessId";
    private static final FunctionName FUNCTION_GetCommandLine = new FunctionName("GetCommandLine");
    private static final String FUNCTION_GetProcessShutdownParameters = "GetProcessShutdownParameters";
    private static final String FUNCTION_SetProcessShutdownParameters = "SetProcessShutdownParameters";
    private static final FunctionName FUNCTION_GetStartupInfo = new FunctionName("GetStartupInfo");

    public CurrentProcess() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetCurrentProcess);
        function.invoke(this);
    }

    public long getProcessID() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetCurrentProcessId);
        UInt32 result = new UInt32();
        function.invoke(result);
        return result.getValue();
    }

    public long getVersion() {
        return Process.getVersion(0L);
    }

    public String getCommandLine() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetCommandLine.toString());
        ExternalStringPointer externalStringPointer = new ExternalStringPointer();
        function.invoke(externalStringPointer);
        return externalStringPointer.readString();
    }

    public long getShutdownParameters(ShutdownFlags flags) {
        if (flags == null) {
            throw new IllegalArgumentException();
        }
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessShutdownParameters);
        Bool functionResult = new Bool();
        UInt32 _flags = new UInt32();
        UInt32 level = new UInt32();
        long errorCode = function.invoke(functionResult, new Pointer.OutOnly(level), new Pointer.OutOnly(_flags));
        flags.clear();
        flags.add(_flags.getValue());
        if (!functionResult.getValue()) {
            throw new LastErrorException(errorCode);
        }
        return level.getValue();
    }

    public void setShutdownParameters(long level, ShutdownFlags flags) {
        if (flags == null) {
            throw new IllegalArgumentException();
        }
        Function function = Kernel32.getInstance().getFunction(FUNCTION_SetProcessShutdownParameters);
        Bool functionResult = new Bool();
        UInt32 _flags = new UInt32(flags.getFlags());
        long errorCode = function.invoke(functionResult, new UInt32(level), _flags);
        if (!functionResult.getValue()) {
            throw new LastErrorException(errorCode);
        }
    }

    public StartupInfo getStartupInfo() {
        StartupInfo result = new StartupInfo();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetStartupInfo.toString());
        Bool returnValue = new Bool();
        long errorCode = function.invoke((Parameter)returnValue, new Pointer.OutOnly(result));
        if (!returnValue.getValue()) {
            throw new LastErrorException(errorCode);
        }
        return result;
    }

    public static class ShutdownFlags
    extends FlagSet {
        public static final int SHUTDOWN_NORETRY = 1;

        public void setNoRetry(boolean set) {
            this.setupFlag(1L, set);
        }

        public boolean isNoRetry() {
            return this.contains(1L);
        }
    }
}

