/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Char;
import com.jniwrapper.Int64;
import com.jniwrapper.IntegerParameter;
import com.jniwrapper.Parameter;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.StringParameter;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt64;
import com.jniwrapper.UInt8;
import com.jniwrapper.WideChar;
import com.jniwrapper.win32.system.Kernel32;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public interface RegistryValueTransformer {
    public static final RegistryValueTransformer STRING_TRANSFORMER = new RegistryValueTransformer(){

        /*
         * WARNING - void declaration
         */
        public Parameter toRegistryValue(Object value) {
            void var2_2;
            Parameter result;
            if (value instanceof String) {
                result = new Str((String)value);
            } else if (value instanceof StringParameter) {
                result = (Parameter)value;
            } else {
                throw new IllegalArgumentException("Not a string parameter");
            }
            return var2_2;
        }

        public Object fromRegistryValue(Parameter value) {
            return ((StringParameter)((Object)value)).getValue();
        }

        public Parameter createRegistryValueParameter(int size) {
            if (size > 0) {
                return new Str("", size);
            }
            return new Str();
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof String || value instanceof StringParameter;
        }
    };
    public static final RegistryValueTransformer INTEGER_TRANSFORMER = new RegistryValueTransformer(){

        /*
         * WARNING - void declaration
         */
        public Parameter toRegistryValue(Object value) {
            void var2_2;
            Parameter result;
            if (value instanceof Number) {
                result = new UInt32(((Number)value).longValue());
            } else if (value instanceof IntegerParameter) {
                result = (Parameter)value;
            } else {
                throw new IllegalArgumentException("Not an integer parameter");
            }
            return var2_2;
        }

        public Object fromRegistryValue(Parameter value) {
            UInt32 parameter = (UInt32)value;
            return new Long(parameter.getValue());
        }

        public Parameter createRegistryValueParameter(int size) {
            return new UInt32();
        }

        public boolean isTypeSupported(Object value) {
            return (value instanceof Number || value instanceof IntegerParameter) && !(value instanceof Int64);
        }
    };
    public static final RegistryValueTransformer QWORD_TRANSFORMER = new RegistryValueTransformer(){

        /*
         * WARNING - void declaration
         */
        public Parameter toRegistryValue(Object value) {
            void var2_2;
            Parameter result;
            if (value instanceof Number) {
                result = new UInt64(((Number)value).longValue());
            } else if (value instanceof IntegerParameter) {
                result = (Parameter)value;
            } else {
                throw new IllegalArgumentException("Not an integer parameter");
            }
            return var2_2;
        }

        public Object fromRegistryValue(Parameter value) {
            UInt64 parameter = (UInt64)value;
            return new Long(parameter.getValue());
        }

        public Parameter createRegistryValueParameter(int size) {
            return new UInt64();
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof Number || value instanceof IntegerParameter;
        }
    };
    public static final RegistryValueTransformer MULTISTRING_TRANSFORMER = new RegistryValueTransformer(){

        /*
         * WARNING - void declaration
         */
        public Parameter toRegistryValue(Object value) {
            void var2_2;
            Collection<String> strings;
            if (value instanceof String[]) {
                strings = Arrays.asList((String[])value);
            } else if (value instanceof Collection) {
                strings = (Collection)value;
            } else {
                throw new IllegalArgumentException("Not a string collection");
            }
            StringBuffer chars = new StringBuffer();
            Iterator i2 = var2_2.iterator();
            while (i2.hasNext()) {
                chars.append(i2.next()).append('\u0000');
            }
            chars.append('\u0000');
            boolean unicode = Kernel32.getInstance().isUnicode();
            int length = chars.length();
            PrimitiveArray array = (PrimitiveArray)this.createRegistryValueParameter(length);
            for (int i3 = 0; i3 < chars.length(); ++i3) {
                char s2 = chars.charAt(i3);
                Parameter c2 = unicode ? new WideChar(s2) : new Char(s2);
                array.setElement(i3, c2);
            }
            return array;
        }

        public Object fromRegistryValue(Parameter value) {
            ArrayList<String> strings = new ArrayList<String>();
            PrimitiveArray charArray = (PrimitiveArray)value;
            StringBuffer string = new StringBuffer();
            boolean unicode = Kernel32.getInstance().isUnicode();
            int elementCount = charArray.getElementCount();
            for (int i2 = 0; i2 < elementCount; ++i2) {
                char c2;
                Parameter element = charArray.getElement(i2);
                char c3 = c2 = unicode ? ((WideChar)element).getValue() : ((Char)element).getValue();
                if (c2 == '\u0000') {
                    if (string.length() == 0) break;
                    strings.add(string.toString());
                    string = new StringBuffer();
                    continue;
                }
                string.append(c2);
            }
            return strings;
        }

        public Parameter createRegistryValueParameter(int size) {
            boolean unicode = Kernel32.getInstance().isUnicode();
            Class clazz = unicode ? (6.class$com$jniwrapper$WideChar == null ? (6.class$com$jniwrapper$WideChar = 6.class$("com.jniwrapper.WideChar")) : 6.class$com$jniwrapper$WideChar) : (6.class$com$jniwrapper$Char == null ? (6.class$com$jniwrapper$Char = 6.class$("com.jniwrapper.Char")) : 6.class$com$jniwrapper$Char);
            return new PrimitiveArray(clazz, size);
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof String[] || value instanceof Collection;
        }
    };
    public static final RegistryValueTransformer BINARY_TRANSFORMER = new RegistryValueTransformer(){

        public Parameter toRegistryValue(Object value) {
            Parameter result = null;
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                PrimitiveArray byteArray = (PrimitiveArray)this.createRegistryValueParameter(bytes.length);
                for (int i2 = 0; i2 < bytes.length; ++i2) {
                    byteArray.setElement(i2, new UInt8(bytes[i2]));
                }
                result = byteArray;
            } else if (value instanceof PrimitiveArray) {
                result = (Parameter)value;
            } else {
                throw new IllegalArgumentException("Not a byte array parameter");
            }
            return result;
        }

        public Object fromRegistryValue(Parameter value) {
            PrimitiveArray array = (PrimitiveArray)value;
            byte[] bytes = array.getBytes();
            return bytes;
        }

        public Parameter createRegistryValueParameter(int size) {
            return new PrimitiveArray(6.class$com$jniwrapper$UInt8 == null ? (6.class$com$jniwrapper$UInt8 = 6.class$("com.jniwrapper.UInt8")) : 6.class$com$jniwrapper$UInt8, size);
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof byte[] || value instanceof PrimitiveArray;
        }
    };

    public Parameter toRegistryValue(Object var1);

    public Object fromRegistryValue(Parameter var1);

    public Parameter createRegistryValueParameter(int var1);

    public boolean isTypeSupported(Object var1);

    static class 6 {
        static /* synthetic */ Class class$com$jniwrapper$WideChar;
        static /* synthetic */ Class class$com$jniwrapper$Char;
        static /* synthetic */ Class class$com$jniwrapper$UInt8;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

