/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry.ui;

import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKey;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class RegistryTreeModel
extends DefaultTreeModel {
    public RegistryTreeModel() {
        super(new DefaultMutableTreeNode("Windows Registry"));
        MutableTreeNode root = (MutableTreeNode)this.getRoot();
        RegistryKeyNode classesRoot = new RegistryKeyNode(RegistryKey.CLASSES_ROOT);
        this.insertNodeInto(classesRoot, root, 0);
        RegistryKeyNode currentUser = new RegistryKeyNode(RegistryKey.CURRENT_USER);
        this.insertNodeInto(currentUser, root, 1);
        RegistryKeyNode localMachine = new RegistryKeyNode(RegistryKey.LOCAL_MACHINE);
        this.insertNodeInto(localMachine, root, 2);
        RegistryKeyNode users = new RegistryKeyNode(RegistryKey.USERS);
        this.insertNodeInto(users, root, 3);
        RegistryKeyNode currentConfig = new RegistryKeyNode(RegistryKey.CURRENT_CONFIG);
        this.insertNodeInto(currentConfig, root, 4);
    }

    public RegistryTreeModel(RegistryKey rootRegistryKey) {
        super(new RegistryKeyNode(rootRegistryKey));
    }

    public void setRootRegistryKey(RegistryKey rootRegistryKey) {
        this.setRoot(new RegistryKeyNode(rootRegistryKey));
    }

    public static class RegistryKeyNode
    extends DefaultMutableTreeNode {
        private List _subkeys;

        public RegistryKeyNode(RegistryKey registryKey) {
            super(registryKey, true);
        }

        public TreeNode getChildAt(int index) {
            return new RegistryKeyNode((RegistryKey)this.getSubkeys().get(index));
        }

        public int getChildCount() {
            int subKeyCount = 0;
            try {
                subKeyCount = this.getRegistryKey().getSubKeyCount();
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
            return subKeyCount;
        }

        public String toString() {
            return this.getRegistryKey().getName();
        }

        private List getSubkeys() {
            if (this._subkeys == null) {
                this._subkeys = this.getRegistryKey().getSubkeys();
            }
            return this._subkeys;
        }

        public RegistryKey getRegistryKey() {
            return (RegistryKey)this.getUserObject();
        }

        public boolean isLeaf() {
            return false;
        }
    }
}

