/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int32;
import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.shell.Shell32;

public class ShellFolder
extends EnumItem {
    static final FunctionName FUNCTION_GET_PATH_FROM_IDLIST = new FunctionName("SHGetPathFromIDList");
    static final FunctionName FUNCTION_GET_SPECIAL_FOLDER_PATH = new FunctionName("SHGetSpecialFolderPath");
    static final String FUNCTION_GET_SPECIAL_FOLDER_LOCATION = "SHGetSpecialFolderLocation";
    static final int MAX_PATH = 260;
    public static final ShellFolder ADMINTOOLS = new ShellFolder(48);
    public static final ShellFolder ALTSTARTUP = new ShellFolder(29);
    public static final ShellFolder APPDATA = new ShellFolder(26);
    public static final ShellFolder BITBUCKET = new ShellFolder(10, true);
    public static final ShellFolder CDBURN_AREA = new ShellFolder(59);
    public static final ShellFolder COMMON_ADMINTOOLS = new ShellFolder(47);
    public static final ShellFolder COMMON_ALTSTARTUP = new ShellFolder(30);
    public static final ShellFolder COMMON_APPDATA = new ShellFolder(35);
    public static final ShellFolder COMMON_DESKTOPDIRECTORY = new ShellFolder(25);
    public static final ShellFolder COMMON_DOCUMENTS = new ShellFolder(46);
    public static final ShellFolder COMMON_FAVORITES = new ShellFolder(31);
    public static final ShellFolder COMMON_MUSIC = new ShellFolder(53);
    public static final ShellFolder COMMON_PICTURES = new ShellFolder(54);
    public static final ShellFolder COMMON_PROGRAMS = new ShellFolder(23);
    public static final ShellFolder COMMON_STARTMENU = new ShellFolder(22);
    public static final ShellFolder COMMON_STARTUP = new ShellFolder(24);
    public static final ShellFolder COMMON_TEMPLATES = new ShellFolder(45);
    public static final ShellFolder COMMON_VIDEO = new ShellFolder(55);
    public static final ShellFolder CONTROLS = new ShellFolder(3, true);
    public static final ShellFolder COOKIES = new ShellFolder(33);
    public static final ShellFolder DESKTOP = new ShellFolder(0, true);
    public static final ShellFolder DESKTOPDIRECTORY = new ShellFolder(16);
    public static final ShellFolder DRIVES = new ShellFolder(17, true);
    public static final ShellFolder FAVORITES = new ShellFolder(6);
    public static final ShellFolder FONTS = new ShellFolder(20);
    public static final ShellFolder HISTORY = new ShellFolder(34);
    public static final ShellFolder INTERNET = new ShellFolder(1, true);
    public static final ShellFolder INTERNET_CACHE = new ShellFolder(32);
    public static final ShellFolder LOCAL_APPDATA = new ShellFolder(28);
    public static final ShellFolder MYDOCUMENTS = new ShellFolder(12, true);
    public static final ShellFolder MYMUSIC = new ShellFolder(13);
    public static final ShellFolder MYPICTURES = new ShellFolder(39);
    public static final ShellFolder MYVIDEO = new ShellFolder(14);
    public static final ShellFolder NETHOOD = new ShellFolder(19);
    public static final ShellFolder NETWORK = new ShellFolder(18);
    public static final ShellFolder PERSONAL = new ShellFolder(5);
    public static final ShellFolder PRINTERS = new ShellFolder(4, true);
    public static final ShellFolder PROFILE = new ShellFolder(40);
    public static final ShellFolder PROFILES = new ShellFolder(62);
    public static final ShellFolder PROGRAM_FILES = new ShellFolder(38);
    public static final ShellFolder PROGRAM_FILES_COMMON = new ShellFolder(43);
    public static final ShellFolder PROGRAMS = new ShellFolder(2);
    public static final ShellFolder RECENT = new ShellFolder(8);
    public static final ShellFolder SEND_TO = new ShellFolder(9);
    public static final ShellFolder START_MENU = new ShellFolder(11);
    public static final ShellFolder STARTUP = new ShellFolder(7);
    public static final ShellFolder SYSTEM = new ShellFolder(37);
    public static final ShellFolder TEMPLATES = new ShellFolder(21);
    public static final ShellFolder WINDOWS = new ShellFolder(36);
    public static final ShellFolder COMPUTER = new ShellFolder(17);
    public static final ShellFolder NET_CONNECTIONS = new ShellFolder(49);
    private boolean _virtual;
    private String _absolutePath;

    private ShellFolder(int folderID, boolean virtual) {
        super(folderID);
        try {
            this._absolutePath = ShellFolder.getSpecialFolderPath(folderID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._virtual = virtual;
    }

    private ShellFolder(int folderID) {
        this(folderID, false);
    }

    public int getFolderID() {
        return this.getValue();
    }

    public boolean isVirtual() {
        return this._virtual;
    }

    public String getAbsolutePath() {
        return this._absolutePath;
    }

    public static Handle getFolderIDList(int folderID) {
        Handle result = new Handle();
        Function getSpecialFolderLocation = Shell32.getInstance().getFunction(FUNCTION_GET_SPECIAL_FOLDER_LOCATION);
        getSpecialFolderLocation.invoke(null, new Handle(), new Int32(folderID), new Pointer.OutOnly(result));
        return result;
    }

    public static String getPathFromIDList(Handle idList) {
        if (idList.isNull()) {
            throw new IllegalArgumentException("Folder id list is null");
        }
        Function getPathFromIDList = Shell32.getInstance().getFunction(FUNCTION_GET_PATH_FROM_IDLIST.toString());
        Str folderPath = new Str("", 260);
        Bool retValue = new Bool();
        getPathFromIDList.invoke(retValue, idList, new Pointer(folderPath));
        if (!retValue.getValue()) {
            return "";
        }
        return folderPath.getValue();
    }

    public static String getSpecialFolderPath(int folderID, boolean create) {
        Function getSpecialFolderPath = Shell32.getInstance().getFunction(FUNCTION_GET_SPECIAL_FOLDER_PATH.toString());
        Bool result = new Bool();
        Str folderPath = new Str("", 260);
        getSpecialFolderPath.invoke(result, new Handle(), folderPath, new Int32(folderID), new Bool(create));
        return folderPath.getValue();
    }

    public static String getSpecialFolderPath(int folderID) {
        return ShellFolder.getSpecialFolderPath(folderID, false);
    }

    public static boolean isFunctionalityAvailable() {
        try {
            Shell32.getInstance().getFunction(FUNCTION_GET_SPECIAL_FOLDER_PATH.toString());
            return true;
        }
        catch (NoSuchFunctionException e2) {
            return false;
        }
    }
}

