/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell.events;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.LongInt;
import com.jniwrapper.NativeResource;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.MessageLoopThread;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.shell.events.SHChangeNotifyEntry;
import com.jniwrapper.win32.shell.events.ShellEvent;
import com.jniwrapper.win32.shell.events.ShellEventsListener;
import com.jniwrapper.win32.ui.WindowMessage;
import com.jniwrapper.win32.ui.WindowMessageListener;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.Wnd;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JWindow;

public class ShellEventsSubscriber {
    private static final String FUNCTION_SHChangeNotifyRegister = "SHChangeNotifyRegister";
    private static final String FUNCTION_SHChangeNotifyDeregister = "SHChangeNotifyDeregister";
    private static final int WM_NOTIFY = 1024;
    private static final int SHCNE_ALLEVENTS = Integer.MAX_VALUE;
    private static final int SHCNRF_ShellLevel = 2;
    private List _shellEventsListeners = Collections.synchronizedList(new LinkedList());
    private Handle _handle;
    private Wnd _wnd;
    private WindowProc _windowProc;
    private MessageLoopThread _messageLoopThread;

    public ShellEventsSubscriber() {
        this(new Handle(), false);
    }

    public ShellEventsSubscriber(Handle idList, boolean recursive) {
        JWindow hiddenWindow = new JWindow();
        hiddenWindow.setVisible(true);
        this._wnd = new Wnd(hiddenWindow);
        this._wnd.show(Wnd.ShowWindowCommand.HIDE);
        this._windowProc = new WindowProc(this._wnd);
        this._windowProc.substitute();
        this._windowProc.addMessageListener(new WindowMessageListener(){

            public boolean canHandle(WindowMessage windowMessage, boolean beforeWindowProc) {
                return windowMessage.getMsg() == 1024 && beforeWindowProc;
            }

            public int handle(WindowMessage windowMessage) {
                ShellEventsSubscriber.this.handleShellEvent(windowMessage.getLParam(), windowMessage.getWParam());
                return 0;
            }
        });
        this._messageLoopThread = new MessageLoopThread();
        this._messageLoopThread.doStart();
        this.subscribe(idList, recursive);
    }

    private void subscribe(final Handle idList, final boolean recursive) {
        try {
            this._messageLoopThread.doInvokeAndWait(new Runnable(){

                public void run() {
                    SHChangeNotifyEntry entry = new SHChangeNotifyEntry(idList, recursive);
                    ShellEventsSubscriber.this._handle = ShellEventsSubscriber.SHChangeNotifyRegister(ShellEventsSubscriber.this._wnd, 2, Integer.MAX_VALUE, 1024, entry);
                    NativeResourceCollector.getInstance().addNativeResource(ShellEventsSubscriber.this, new ShellResource(ShellEventsSubscriber.this._handle));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addShellEventsListener(ShellEventsListener listener) {
        this._shellEventsListeners.add(listener);
    }

    public void removeShellEventsListener(ShellEventsListener listener) {
        this._shellEventsListeners.remove(listener);
    }

    private void handleShellEvent(long lParam, long wParam) {
        ShellEvent event = new ShellEvent(this, lParam, wParam);
        Iterator i2 = this._shellEventsListeners.iterator();
        while (i2.hasNext()) {
            ShellEventsListener listener = (ShellEventsListener)i2.next();
            listener.processEvent(event);
        }
    }

    private static Handle SHChangeNotifyRegister(Wnd wnd, int flags, long events, int msg, SHChangeNotifyEntry entry) {
        Function SHChangeNotifyRegister = Shell32.getInstance().getFunction(FUNCTION_SHChangeNotifyRegister);
        Handle result = new Handle();
        UInt32 entries = new UInt32(1L);
        long errorCode = SHChangeNotifyRegister.invoke((Parameter)result, new Parameter[]{wnd, new UInt32(flags), new LongInt(events), new UInt(msg), entries, new Pointer(entry)});
        if (result.isNull()) {
            throw new LastErrorException(errorCode);
        }
        return result;
    }

    private static boolean SHChangeNotifyDeregister(Handle id) {
        Function SHChangeNotifyDeregister = Shell32.getInstance().getFunction(FUNCTION_SHChangeNotifyDeregister);
        Bool result = new Bool();
        SHChangeNotifyDeregister.invoke((Parameter)result, id);
        return result.getValue();
    }

    private static class ShellResource
    implements NativeResource {
        private Handle _handle;

        public ShellResource(Handle handle) {
            this._handle = new Handle(handle.getValue());
        }

        public void release() throws Throwable {
            if (!this._handle.isNull()) {
                ShellEventsSubscriber.SHChangeNotifyDeregister(this._handle);
            }
        }
    }
}

