/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.ULongInt;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.system.MemoryAllocationAttributes;

public class GlobalMemoryBlock
extends Handle {
    private static final String FUNCTION_GlobalAlloc = "GlobalAlloc";
    private static final String FUNCTION_GlobalFree = "GlobalFree";
    private static final String FUNCTION_GlobalSize = "GlobalSize";
    private static final String FUNCTION_GlobalLock = "GlobalLock";
    private static final String FUNCTION_GlobalUnlock = "GlobalUnlock";

    public GlobalMemoryBlock() {
    }

    public GlobalMemoryBlock(Handle handle) {
        super(handle.getValue());
    }

    public GlobalMemoryBlock(int size, MemoryAllocationAttributes attributes) {
        this.alloc(size, attributes);
    }

    public void free() {
        GlobalMemoryBlock result = new GlobalMemoryBlock();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GlobalFree);
        function.invoke((Parameter)result, this);
        if (!result.isNull()) {
            throw new RuntimeException("Can't free global memory block.");
        }
    }

    private void alloc(int size, MemoryAllocationAttributes attributes) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GlobalAlloc);
        function.invoke(this, new UInt(attributes.getValue()), new ULongInt(size));
    }

    public int size() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GlobalSize);
        ULongInt result = new ULongInt();
        function.invoke((Parameter)result, this);
        return (int)result.getValue();
    }

    public Handle lock() {
        Handle result = new Handle();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GlobalLock);
        function.invoke((Parameter)result, this);
        return result;
    }

    public int unlock() {
        Int result = new Int();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GlobalUnlock);
        function.invoke((Parameter)result, this);
        return (int)result.getValue();
    }
}

