/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.controls;

import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.shell.ShellIcon;
import com.jniwrapper.win32.ui.controls.AbstractChooserField;
import com.jniwrapper.win32.ui.dialogs.SelectIconDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ChooseIconField
extends AbstractChooserField {
    public static final String PROPERTY_ICON = "icon";
    private JLabel _lblIcon = new JLabel();
    private SelectIconDialog _dialog;

    public ChooseIconField() {
        this.remove(this.getTextField());
        JPanel bevel1 = new JPanel();
        bevel1.setBorder(BorderFactory.createEtchedBorder());
        bevel1.setLayout(new GridBagLayout());
        this.getSelectButton().setBorder(BorderFactory.createEtchedBorder());
        Dimension size = new Dimension(36, 38);
        this._lblIcon.setPreferredSize(size);
        this._lblIcon.setMinimumSize(size);
        this._lblIcon.setMaximumSize(size);
        bevel1.setBackground(Color.WHITE);
        this._lblIcon.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    ChooseIconField.this.actionPerformed(null);
                }
            }
        });
        bevel1.add((Component)this._lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.add((Component)bevel1, "Center");
    }

    public ChooseIconField(File iconFile) {
        this();
        if (iconFile.exists()) {
            this.setIconImage(new ShellIcon(iconFile));
            this.setIconFile(iconFile);
        }
    }

    public ChooseIconField(File iconFile, int iconIndex) {
        this();
        if (iconFile.exists()) {
            this.setIconImage(new ShellIcon(iconFile, iconIndex));
            this.setIconFile(iconFile);
            this.setIconIndex(iconIndex);
        }
    }

    public void actionPerformed(ActionEvent e2) {
        SelectIconDialog dialog = this.getDialog();
        if (dialog.getOwner() == null) {
            dialog.setOwner(SwingUtilities.getWindowAncestor(this));
        }
        String oldIcon = dialog.getIconFile().getAbsolutePath() + Integer.toString(dialog.getIconIndex());
        if (dialog.execute()) {
            this.setIconImage(dialog.getShellIcon());
            String newIcon = dialog.getIconFile().getAbsolutePath() + Integer.toString(dialog.getIconIndex());
            this.firePropertyChange(PROPERTY_ICON, oldIcon, newIcon);
        }
    }

    private void setIconImage(ShellIcon shellIcon) {
        try {
            ShellIcon icon = shellIcon;
            ImageIcon imageIcon = new ImageIcon(icon.toImage());
            this._lblIcon.setIcon(imageIcon);
        }
        catch (LastErrorException lastErrorException) {
            // empty catch block
        }
    }

    public void setIconImage(File iconFile, int iconIndex) {
        this.setIconFile(iconFile);
        this.setIconIndex(iconIndex);
        this.setIconImage(this.getShellIcon());
    }

    public SelectIconDialog getDialog() {
        if (this._dialog == null) {
            this._dialog = new SelectIconDialog();
        }
        return this._dialog;
    }

    public void setIconFile(File value) {
        this.getDialog().setIconFile(value);
    }

    public File getIconFile() {
        return this.getDialog().getIconFile();
    }

    public void setIconIndex(int value) {
        this.getDialog().setIconIndex(value);
    }

    public int getIconIndex() {
        return this.getDialog().getIconIndex();
    }

    public ShellIcon getShellIcon() {
        return this.getDialog().getShellIcon();
    }
}

