/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Bool;
import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.dialogs.ChooseColorStructure;
import com.jniwrapper.win32.ui.dialogs.ComDlg32;
import com.jniwrapper.win32.ui.dialogs.DefaultDialogCallback;
import com.jniwrapper.win32.ui.dialogs.DialogHelper;
import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class ChooseColorDialog {
    static final FunctionName FUNCTION_CHOOSE_COLOR = new FunctionName("ChooseColor");
    private Options _options = new Options();
    private Window _owner = null;
    private Color _color = null;
    private List _customColors = new ArrayList(16);
    private Callback _dialogCallback;

    public ChooseColorDialog() {
        this(null);
    }

    public ChooseColorDialog(Window owner) {
        this.setOwner(owner);
    }

    public Window getOwner() {
        return this._owner;
    }

    public void setOwner(Window owner) {
        this._owner = owner;
    }

    public Options getOptions() {
        return this._options;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public List getCustomColors() {
        return this._customColors;
    }

    private void setCustomColors(ChooseColorStructure colorStructure) {
        int count = this._customColors.size();
        int[] customColors = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            int color;
            customColors[i2] = color = ColorRef.toNativeColor((Color)this._customColors.get(i2));
        }
        colorStructure.setCustomColors(customColors);
    }

    private void getCustomColors(ChooseColorStructure colorStructure) {
        this._customColors.clear();
        int[] customColors = colorStructure.getCustomColors();
        for (int i2 = 0; i2 < customColors.length; ++i2) {
            int color = customColors[i2];
            this._customColors.add(ColorRef.fromNativeColor(color));
        }
    }

    protected Callback getDialogCallback() {
        if (this._dialogCallback == null) {
            this._dialogCallback = new DefaultDialogCallback(){

                public void callback() {
                    this._returnParam.setValue(0L);
                    long msg = this._msg.getValue();
                    if (msg == 272L && !this._wnd.isNull()) {
                        this._wnd.centerInDesktop();
                    }
                }
            };
        }
        return this._dialogCallback;
    }

    public boolean execute() {
        ChooseColorStructure colorStructure = new ChooseColorStructure(this.getDialogCallback());
        colorStructure.setInstance(Module.getCurrent());
        Window owner = this.getOwner();
        if (owner != null) {
            colorStructure.setOwner(new Wnd(owner));
        }
        if (this._color != null) {
            ColorRef colorRef = new ColorRef(this._color);
            colorStructure.setColor(colorRef);
        }
        this.setCustomColors(colorStructure);
        colorStructure.setFlags(this._options.getFlags() | 0x10L);
        Function function = ComDlg32.getInstance().getFunction(FUNCTION_CHOOSE_COLOR.toString());
        Bool result = new Bool();
        if (owner == null) {
            function.invoke((Parameter)result, new Pointer(colorStructure));
        } else {
            DialogHelper.invokeDialog(owner, function, result, new Parameter[]{new Pointer(colorStructure)});
        }
        if (result.getValue()) {
            ColorRef colorRef = colorStructure.getColor();
            this._color = colorRef.toColor();
            this.getCustomColors(colorStructure);
        }
        return result.getValue();
    }

    public class Options
    extends FlagSet {
        public static final int RGBINIT = 1;
        public static final int FULLOPEN = 2;
        public static final int PREVENTFULLOPEN = 4;
        public static final int SHOWHELP = 8;
        public static final int ENABLEHOOK = 16;
        public static final int ENABLETEMPLATE = 32;
        public static final int ENABLETEMPLATEHANDLE = 64;
        public static final int SOLIDCOLOR = 128;
        public static final int ANYCOLOR = 256;

        public Options() {
            this.reset();
        }

        public void reset() {
            this.clear();
            this.add(1L);
        }

        public void setFullOpen(boolean value) {
            if (value) {
                this.add(2L);
            } else {
                this.remove(2L);
            }
        }

        public void setPreventFullOpen(boolean value) {
            if (value) {
                this.add(4L);
            } else {
                this.remove(4L);
            }
        }

        public void setSolidColor(boolean value) {
            if (value) {
                this.add(128L);
            } else {
                this.remove(128L);
            }
        }

        public void setAnyColor(boolean value) {
            if (value) {
                this.add(256L);
            } else {
                this.remove(256L);
            }
        }
    }
}

