/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Bool;
import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.dialogs.ComDlg32;
import com.jniwrapper.win32.ui.dialogs.DefaultDialogCallback;
import com.jniwrapper.win32.ui.dialogs.DialogHelper;
import com.jniwrapper.win32.ui.dialogs.OFNStructure;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class OpenSaveFileDialog {
    public static final char DEFAULT_FILTER_SEPARATOR = '|';
    static final FunctionName FUNCTION_OPEN_FILENAME = new FunctionName("GetOpenFileName");
    static final FunctionName FUNCTION_SAVE_FILENAME = new FunctionName("GetSaveFileName");
    public static final int FES_EDIT = 0;
    public static final int FES_COMBOBOX = 1;
    static final int MAX_PATH = 260;
    static final int MULTI_SELECT_BUFFER_SIZE = 65520;
    static final char EXTENSION_SEPARATOR = '.';
    private OpenSaveFileDialogOptions _options = new OpenSaveFileDialogOptions();
    private OpenSaveFileDialogExtOptions _extOptions = new OpenSaveFileDialogExtOptions();
    private String _filter = "";
    private long _filterIndex = 1L;
    private long _currentFilterIndex = 1L;
    private String _initialDir;
    private String _title;
    private String _defaultExt = "";
    private String _fileName = "";
    private List _files = new ArrayList();
    private int _fileEditStyle = 0;
    private boolean _forceCurrentDirectory = true;
    private Window _owner = null;
    private long _errorCode = 0L;
    private char _filterSeparator = (char)124;
    private Callback _dialogCallback;

    public OpenSaveFileDialog(Window owner, String title, String initialDirectory) {
        this.setOwner(owner);
        this.setTitle(title);
        this.setInitialDir(initialDirectory);
    }

    public OpenSaveFileDialog() {
        this(null, "", "");
    }

    public OpenSaveFileDialog(String title) {
        this(null, title, "");
    }

    public OpenSaveFileDialog(Window owner) {
        this(owner, "");
    }

    public OpenSaveFileDialog(Window owner, String title) {
        this(owner, title, "");
    }

    public OpenSaveFileDialog(Window owner, String title, File initialDirectory) {
        this(owner, title, initialDirectory == null ? "" : initialDirectory.getAbsolutePath());
    }

    public OpenSaveFileDialog(String title, String initialDirectory) {
        this(null, title, initialDirectory);
    }

    public OpenSaveFileDialog(File initialDirectory) {
        this(null, "", initialDirectory);
    }

    public OpenSaveFileDialog(Window owner, File initialDirectory) {
        this(owner, "", initialDirectory);
    }

    public Window getOwner() {
        return this._owner;
    }

    public void setOwner(Window owner) {
        this._owner = owner;
    }

    public char getFilterSeparator() {
        return this._filterSeparator;
    }

    public void setFilterSeparator(char filterSeparator) {
        this._filterSeparator = filterSeparator;
    }

    public OpenSaveFileDialogOptions getOptions() {
        return this._options;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String filter) {
        this._filter = filter;
    }

    StringBuffer translateFilter(String filter) {
        StringBuffer newFilter = new StringBuffer(filter);
        if (filter.length() > 0) {
            newFilter.append('\u0000');
            newFilter.append('\u0000');
            for (int i2 = 0; i2 < filter.length(); ++i2) {
                char c2 = newFilter.charAt(i2);
                if (c2 != this._filterSeparator) continue;
                newFilter.setCharAt(i2, '\u0000');
            }
        }
        return newFilter;
    }

    public long getFilterIndex() {
        return this._filterIndex;
    }

    public void setFilterIndex(long filterIndex) {
        this._filterIndex = filterIndex;
    }

    public long getCurrentFilterIndex() {
        return this._currentFilterIndex;
    }

    public void setCurrentFilterIndex(long currentFilterIndex) {
        this._currentFilterIndex = currentFilterIndex;
    }

    public String getInitialDir() {
        return this._initialDir;
    }

    public void setInitialDir(String initialDir) {
        this._initialDir = initialDir;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getDefaultExt() {
        return this._defaultExt;
    }

    public void setDefaultExt(String defaultExt) {
        this._defaultExt = defaultExt;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public List getFiles() {
        return this._files;
    }

    public int getFileEditStyle() {
        return this._fileEditStyle;
    }

    public void setFileEditStyle(int fileEditStyle) {
        this._fileEditStyle = fileEditStyle;
    }

    protected OpenSaveFileDialogExtOptions getExtOptions() {
        return this._extOptions;
    }

    public boolean isForceCurrentDirectory() {
        return this._forceCurrentDirectory;
    }

    public void setForceCurrentDirectory(boolean forceCurrentDirectory) {
        this._forceCurrentDirectory = forceCurrentDirectory;
    }

    static String getFileExtension(String fileName) {
        int separatorIndex = fileName.lastIndexOf(46);
        int firstExtensionSymbolIndex = separatorIndex + 1;
        return fileName.substring(firstExtensionSymbolIndex);
    }

    protected Callback getDialogCallback() {
        if (this._dialogCallback == null) {
            this._dialogCallback = new DefaultDialogCallback(){

                public void callback() {
                    Wnd handle;
                    this._returnParam.setValue(0L);
                    long msg = this._msg.getValue();
                    if (msg == 272L && !(handle = new Wnd(this._wnd.getWindowLong(-8))).isNull()) {
                        handle.centerInDesktop();
                    }
                }
            };
        }
        return this._dialogCallback;
    }

    protected boolean doExecute(Function function) {
        if (function == null) {
            throw new IllegalArgumentException("Function is null");
        }
        String currentDirectory = Kernel32.getCurrentDirectory();
        this._files.clear();
        int maxFile = this._options.isMultiselectionAllowed() ? 65520 : 260;
        OFNStructure ofn = new OFNStructure(this.getDialogCallback(), maxFile);
        ofn.setFilterIndex(this._filterIndex);
        ofn.setFilter(this.translateFilter(this._filter));
        this._currentFilterIndex = this._filterIndex;
        ofn.setFile(this._fileName);
        if (this._initialDir.length() == 0 && this._forceCurrentDirectory) {
            ofn.setInitialDir(".");
        } else {
            ofn.setInitialDir(this._initialDir);
        }
        ofn.setTitle(this._title);
        long flags = 0x20L | this._options.getFlags();
        ofn.setFlagsEx(this._extOptions.getFlags());
        String extension = this._defaultExt;
        if (extension.length() == 0 && (flags & 0x80000L) == 0L) {
            extension = OpenSaveFileDialog.getFileExtension(this._fileName);
        }
        if (extension.length() > 0) {
            ofn.setDefExt(extension);
        }
        if (this._owner != null) {
            Wnd owner = new Wnd(this._owner);
            ofn.setOwner(owner);
        }
        if (this._options.isMultiselectionAllowed()) {
            flags |= 0x200L;
        }
        ofn.setFlags(flags);
        Bool result = new Bool();
        if (this._owner != null) {
            DialogHelper.invokeDialog(this._owner, function, result, new Parameter[]{new Pointer(ofn)});
        } else {
            function.invoke((Parameter)result, new Pointer(ofn));
        }
        if (result.getValue()) {
            this.getFiles(ofn);
            if ((ofn.getFlags() & 0x400L) != 0L) {
                this._options.add(1024L);
            } else {
                this._options.remove(1024L);
            }
            this._filterIndex = ofn.getFilterIndex();
        }
        this._errorCode = ComDlg32.getCommDlgExtendedError();
        Kernel32.setCurrentDirectory(currentDirectory);
        return result.getValue();
    }

    public long getErrorCode() {
        return this._errorCode;
    }

    protected void getFiles(OFNStructure ofnStructure) {
        String fileString = ofnStructure.getFile();
        if (!this._options.isShowExplorer() && this._options.isMultiselectionAllowed()) {
            fileString = fileString.replaceAll("\\.\t", "\t").replaceAll("\\.$", "").replaceAll("\t.*$", "").replaceAll("\\. ", "\t").replaceAll(" ", "\t");
        }
        StringTokenizer tokenizer = new StringTokenizer(fileString, String.valueOf('\t'));
        if (this._options.isMultiselectionAllowed()) {
            String folderName = tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                String fileName = tokenizer.nextToken();
                File file = new File(folderName, fileName);
                this._files.add(file);
            }
            if (this._files.isEmpty()) {
                this._files.add(new File(folderName));
            }
            this._fileName = this._files.get(0).toString();
        } else {
            this._fileName = tokenizer.nextToken();
            this._files.add(new File(this._fileName));
        }
    }

    public boolean getOpenFileName() {
        return this.doExecute(ComDlg32.getInstance().getFunction(FUNCTION_OPEN_FILENAME.toString()));
    }

    public boolean getSaveFileName() {
        return this.doExecute(ComDlg32.getInstance().getFunction(FUNCTION_SAVE_FILENAME.toString()));
    }

    public class OpenSaveFileDialogExtOptions
    extends FlagSet {
        public static final int OFN_EX_NOPLACESBAR = 1;

        public boolean isShowPlacebar() {
            return !this.contains(1L);
        }

        public void setShowPlacebar(boolean showPlacebar) {
            if (showPlacebar) {
                this.remove(1L);
            } else {
                this.add(1L);
            }
        }
    }

    public class OpenSaveFileDialogOptions
    extends FlagSet {
        public static final int READONLY = 1;
        public static final int OVERWRITEPROMPT = 2;
        public static final int HIDEREADONLY = 4;
        public static final int NOCHANGEDIR = 8;
        public static final int SHOWHELP = 16;
        public static final int ENABLEHOOK = 32;
        public static final int ENABLETEMPLATE = 64;
        public static final int ENABLETEMPLATEHANDLE = 128;
        public static final int NOVALIDATE = 256;
        public static final int ALLOWMULTISELECT = 512;
        public static final int EXTENSIONDIFFERENT = 1024;
        public static final int PATHMUSTEXIST = 2048;
        public static final int FILEMUSTEXIST = 4096;
        public static final int CREATEPROMPT = 8192;
        public static final int SHAREAWARE = 16384;
        public static final int NOREADONLYRETURN = 32768;
        public static final int NOTESTFILECREATE = 65536;
        public static final int NONETWORKBUTTON = 131072;
        public static final int NOLONGNAMES = 262144;
        public static final int EXPLORER = 524288;
        public static final int NODEREFERENCELINKS = 0x100000;
        public static final int LONGNAMES = 0x200000;
        public static final int ENABLEINCLUDENOTIFY = 0x400000;
        public static final int ENABLESIZING = 0x800000;
        public static final int DONTADDTORECENT = 0x2000000;
        public static final int FORCESHOWHIDDEN = 0x10000000;

        public OpenSaveFileDialogOptions() {
            this.reset();
        }

        public void reset() {
            this.clear();
            this.add(0x880004L);
        }

        public boolean isMultiselectionAllowed() {
            return this.contains(512L);
        }

        public void setMultiselectionAllowed(boolean multiselectionAllowed) {
            if (multiselectionAllowed) {
                this.add(512L);
            } else {
                this.remove(512L);
            }
        }

        public boolean isHideReadOnly() {
            return this.contains(4L);
        }

        public void setHideReadOnly(boolean hideReadOnly) {
            if (hideReadOnly) {
                this.add(4L);
            } else {
                this.remove(4L);
            }
        }

        public boolean isShowHiddenFiles() {
            return this.contains(0x10000000L);
        }

        public void setShowHiddenFiles(boolean showHiddenFiles) {
            if (showHiddenFiles) {
                this.add(0x10000000L);
            } else {
                this.remove(0x10000000L);
            }
        }

        public boolean isSizingEnabled() {
            return this.contains(0x800000L);
        }

        public void setSizingEnabled(boolean sizingEnabled) {
            if (sizingEnabled) {
                this.add(0x800000L);
            } else {
                this.remove(0x800000L);
            }
        }

        public boolean isShowOverwritePrompt() {
            return this.contains(2L);
        }

        public void setShowOverwritePrompt(boolean showOverwritePrompt) {
            if (showOverwritePrompt) {
                this.add(2L);
            } else {
                this.remove(2L);
            }
        }

        public boolean isShowExplorer() {
            return this.contains(524288L);
        }

        public void setShowExplorer(boolean showExplorer) {
            if (showExplorer) {
                this.add(524288L);
            } else {
                this.remove(524288L);
            }
        }

        public boolean isShowHelp() {
            return this.contains(16L);
        }

        public void setShowHelp(boolean showHelp) {
            if (showHelp) {
                this.add(16L);
            } else {
                this.remove(16L);
            }
        }
    }
}

