/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.transform;

import de.qfs.apps.qftest.qagent.QAgent;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;

public class SWTTransformer {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.transform.SWTTransformer");
    private static final Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    private ClassLoader loader;
    private ProtectionDomain domain;
    private JarFile libraryJar;
    private ThreadLocal<Stack<Object>> returnStack = new ThreadLocal(){

        protected Stack<Object> initialValue() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ThreadLocal.initialValue()", 69).log();
            }
            return new Stack<Object>();
        }
    };
    private int qfgtkClassesCount;
    private boolean moduleOpened;

    private SWTTransformer(ClassLoader classLoader, ProtectionDomain protectionDomain, JarFile jarFile) {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "SWTTransformer(ClassLoader,ProtectionDomain,JarFile)", 89).addDetail("loader", (Object)classLoader)).addDetail("domain", (Object)protectionDomain)).addDetail("libraryJar", (Object)jarFile)).log();
        }
        this.loader = classLoader;
        this.domain = protectionDomain;
        this.libraryJar = jarFile;
    }

    public static SWTTransformer createSWTTransformer(ClassLoader classLoader) {
        block17: {
            if (SWTTransformer.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "createSWTTransformer(ClassLoader)", 110).addDetail("loader", (Object)classLoader)).log();
            }
            try {
                String string;
                String string2;
                int n;
                int n2;
                Class<?> clazz;
                block16: {
                    if (SWTTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 113).add("pd", (Object)classLoader.getClass().getProtectionDomain())).log();
                    }
                    if (SWTTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 114).add("super", classLoader.getClass().getSuperclass())).add("pd", (Object)classLoader.getClass().getSuperclass().getProtectionDomain())).log();
                    }
                    clazz = classLoader.loadClass("org.eclipse.swt.internal.Library");
                    if (SWTTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 118).add("libraryClass", clazz)).log();
                    }
                    if (clazz.getClassLoader() != classLoader) {
                        if (SWTTransformer.logger.level >= 5) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "createSWTTransformer(ClassLoader)", 121).add("Different classLoader", (Object)clazz.getClassLoader())).log();
                        }
                        return null;
                    }
                    n2 = (Integer)SWTTransformer.getField(clazz, "MAJOR_VERSION");
                    n = (Integer)SWTTransformer.getField(clazz, "MINOR_VERSION");
                    if (SWTTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 128).add("major", n2)).add("minor", n)).log();
                    }
                    string2 = null;
                    string = null;
                    try {
                        string2 = (String)SWTTransformer.callMethod(clazz, "os", null, null, null);
                        string = (String)SWTTransformer.callMethod(clazz, "arch", null, null, null);
                        if (SWTTransformer.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 134).add("os", string2)).add("arch", string)).log();
                        }
                    }
                    catch (Throwable throwable) {
                        if (SWTTransformer.logger.level < 5) break block16;
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "createSWTTransformer(ClassLoader)", 136).add("ex", (Object)throwable)).log();
                    }
                }
                Class<?> clazz2 = classLoader.loadClass("org.eclipse.swt.internal.Platform");
                if (SWTTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 139).add("platformClass", clazz2)).log();
                }
                String string3 = (String)SWTTransformer.getField(clazz2, "PLATFORM");
                if (SWTTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 141).add("platform", string3)).log();
                }
                String string4 = SWTTransformer.locateJar(n2, n, string2, string, string3);
                if (SWTTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "createSWTTransformer(ClassLoader)", 143).add("libJar", string4)).log();
                }
                if (string4 != null) {
                    SWTTransformer sWTTransformer = new SWTTransformer(classLoader, clazz.getProtectionDomain(), new JarFile(string4));
                    return sWTTransformer;
                }
            }
            catch (Throwable throwable) {
                if (SWTTransformer.logger.level < 5) break block17;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "createSWTTransformer(ClassLoader)", 150).add("ex", (Object)throwable)).log();
            }
        }
        return null;
    }

    public byte[] transform(String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "transform(String,Class<?>,ProtectionDomain,byte[])", 172).addDetail("className", string)).addDetail("classBeingRedefined", clazz)).addDetail("protectionDomain", (Object)protectionDomain)).addDetail("classfileBuffer", (Object)byArray)).log();
        }
        byte[] byArray2 = this.readClass(string);
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(String,Class<?>,ProtectionDomain,byte[])", 176).add("ret", (Object)byArray2)).log();
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getField(Class clazz, String string) throws Exception {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getField(Class,String)", 197).addDetail("cl", (Object)clazz)).addDetail("name", string)).log();
        }
        Field field = clazz.getDeclaredField(string);
        boolean bl = field.isAccessible();
        try {
            if (!bl) {
                field.setAccessible(true);
            }
            Object object = field.get(null);
            return object;
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callMethod(Class clazz, String string, Object object, Class[] classArray, Object[] objectArray) throws Exception {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "callMethod(Class,String,Object,Class[],Object[])", 227).addDetail("cl", (Object)clazz)).addDetail("name", string)).addDetail("instance", object)).addDetail("signature", (Object)classArray)).addDetail("values", (Object)objectArray)).log();
        }
        while (clazz != Object.class) {
            Method method;
            try {
                method = clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = null;
            }
            if (SWTTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "callMethod(Class,String,Object,Class[],Object[])", 237).add("method", (Object)method)).log();
            }
            if (method != null) {
                boolean bl = method.isAccessible();
                if (SWTTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "callMethod(Class,String,Object,Class[],Object[])", 240).add("accessible", bl)).log();
                }
                try {
                    if (!bl) {
                        method.setAccessible(true);
                    }
                    Object object2 = method.invoke(object, objectArray);
                    return object2;
                }
                finally {
                    if (!bl) {
                        method.setAccessible(false);
                    }
                }
            }
            clazz = clazz.getSuperclass();
            if (SWTTransformer.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "callMethod(Class,String,Object,Class[],Object[])", 253).add("cl", clazz)).log();
        }
        return null;
    }

    private static String locateJar(int n, int n2, String string, String string2, String string3) {
        String string4;
        String string5;
        Object object;
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "locateJar(int,int,String,String,String)", 272).addDetail("majorVersion", n)).addDetail("minorVersion", n2)).addDetail("os", string)).addDetail("arch", string2)).addDetail("platform", string3)).log();
        }
        String string6 = QAgent.Environment.getEnv((String)"QFTEST_SWT_INSTRUMENT_JAR");
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(int,int,String,String,String)", 276).add("envJar", string6)).log();
        }
        if (string6 != null && !"".equals(string6)) {
            object = new File(string6);
            if (((File)object).exists()) {
                String string7;
                try {
                    string7 = ((File)object).getCanonicalPath();
                }
                catch (IOException iOException) {
                    if (SWTTransformer.logger.level >= 5) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "locateJar(int,int,String,String,String)", 284).add("ex", (Object)iOException)).log();
                    }
                    string7 = ((File)object).getAbsolutePath();
                }
                System.out.println("Using instrument.jar from environment QFTEST_SWT_INSTRUMENT_JAR: " + string7);
                return string7;
            }
            System.out.println("Could not find instrument.jar from environment QFTEST_SWT_INSTRUMENT_JAR: " + ((File)object).getAbsolutePath() + ", falling back to default.");
        }
        object = "" + n + "." + n2 / 100;
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(int,int,String,String,String)", 296).add("version", (String)object)).log();
        }
        Object object2 = null;
        if (n == 4 && n2 >= 922) {
            object2 = object;
            int n3 = n2;
            int n4 = 10;
            if (n3 > 962) {
                n4 += n3 - 962;
                n3 = 962;
            }
            n4 += (n3 - 922) / 2;
            if (n3 >= 940) {
                --n4;
            }
            object = "4." + n4;
        }
        if ((string5 = string) == null) {
            string5 = string3;
        }
        if ("linux".equals(string)) {
            string5 = string5 + "-" + string3;
        }
        if (string2 != null && string2.endsWith("64") || string2 == null && System.getProperty("os.arch") != null && System.getProperty("os.arch").indexOf("64") >= 0) {
            string5 = string5 + "-64";
        }
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(int,int,String,String,String)", 330).add("osdir", string5)).log();
        }
        if ((string4 = QAgent.Environment.getEnv((String)"QFTEST_VERSIONDIR")) != null) {
            File file;
            String string8 = new File(string4, "swt/" + string5).getPath();
            if (SWTTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(int,int,String,String,String)", 334).add("swtdir", string8)).log();
            }
            if ((file = SWTTransformer.locateJar(string8, (String)object, n, n2)) == null && object2 != null) {
                file = SWTTransformer.locateJar(string8, (String)object2, n, n2);
            }
            if (file != null) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    if (SWTTransformer.logger.level >= 5) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "locateJar(int,int,String,String,String)", 346).add("ex", (Object)iOException)).log();
                    }
                    return file.getAbsolutePath();
                }
            }
        }
        return null;
    }

    private static File locateJar(String string, String string2, int n, int n2) {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "locateJar(String,String,int,int)", 367).addDetail("swtdir", string)).addDetail("version", string2)).addDetail("majorVersion", n)).addDetail("minorVersion", n2)).log();
        }
        File file = new File(string + "/" + string2 + "/instrument-" + n + "." + n2 + ".jar");
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(String,String,int,int)", 371).add("exact version match jar", (Object)file)).log();
        }
        if (file.exists()) {
            return file;
        }
        file = new File(string + "/" + string2 + "/instrument-" + string2 + ".jar");
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(String,String,int,int)", 377).add("main version match jar", (Object)file)).log();
        }
        if (file.exists()) {
            return file;
        }
        file = new File(string + "/" + string2 + "/instrument.jar");
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(String,String,int,int)", 383).add("new-style generic instrument.jar", (Object)file)).log();
        }
        if (file.exists()) {
            return file;
        }
        file = new File(string + "/" + string2 + "/swt.jar");
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "locateJar(String,String,int,int)", 389).add("old-style swt.jar", (Object)file)).log();
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private byte[] readClass(String string) {
        byte[] byArray;
        block13: {
            if (SWTTransformer.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "readClass(String)", 407).addDetail("className", string)).log();
            }
            byArray = null;
            JarEntry jarEntry = this.libraryJar.getJarEntry(string + ".class");
            if (SWTTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "readClass(String)", 411).add("entry", (Object)jarEntry)).log();
            }
            if (jarEntry != null && (byArray = this.readClass(jarEntry)) != null && string.indexOf("$") < 0) {
                this.loadInnerClasses(string);
            }
            if (this.qfgtkClassesCount == 2) {
                Class clazz;
                block12: {
                    this.qfgtkClassesCount = -1;
                    try {
                        clazz = this.loadClassFromOurJar("de.qfs.apps.qftest.client.swt.qfgtk.QfGtk", true);
                        if (SWTTransformer.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "readClass(String)", 425).add("cl", (Object)clazz)).add("domain", (Object)clazz.getProtectionDomain())).log();
                        }
                    }
                    catch (Throwable throwable) {
                        if (SWTTransformer.logger.level < 5) break block12;
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "readClass(String)", 427).add("ex", (Object)throwable)).log();
                    }
                }
                try {
                    clazz = this.loadClassFromOurJar("de.qfs.apps.qftest.client.swt.qfgtk.QfGdk", true);
                    if (SWTTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "readClass(String)", 431).add("cl", (Object)clazz)).add("domain", (Object)clazz.getProtectionDomain())).log();
                    }
                }
                catch (Throwable throwable) {
                    if (SWTTransformer.logger.level < 5) break block13;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "readClass(String)", 433).add("ex", (Object)throwable)).log();
                }
            }
        }
        if (this.qfgtkClassesCount >= 0 && ("org/eclipse/swt/internal/gtk/GTK".equals(string) || "org/eclipse/swt/internal/gtk/GDK".equals(string))) {
            ++this.qfgtkClassesCount;
            if (SWTTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "readClass(String)", 440).add("qfgtkClassesCount", this.qfgtkClassesCount)).log();
            }
        }
        return byArray;
    }

    private byte[] readClass(JarEntry jarEntry) {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "readClass(JarEntry)", 456).addDetail("entry", (Object)jarEntry)).log();
        }
        int n = (int)jarEntry.getSize();
        byte[] byArray = new byte[n];
        try {
            int n2;
            InputStream inputStream = this.libraryJar.getInputStream(jarEntry);
            for (int i = 0; i < n; i += n2) {
                n2 = inputStream.read(byArray, i, n - i);
                if (SWTTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "readClass(JarEntry)", 465).add("got", n2)).log();
                }
                if (n2 >= 0) continue;
                if (SWTTransformer.logger.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "readClass(JarEntry)", 467).add("Incomplete read for ")).add((Object)jarEntry)).add(". Got only ")).add(i)).add(" of ")).add(n)).add(" bytes.")).log();
                }
                return null;
            }
            return byArray;
        }
        catch (IOException iOException) {
            if (SWTTransformer.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "readClass(JarEntry)", 475).add("ex", (Object)iOException)).log();
            }
            return null;
        }
    }

    private Class loadClassFromOurJar(String string, boolean bl) {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadClassFromOurJar(String,boolean)", 491).addDetail("className", string)).addDetail("resolve", bl)).log();
        }
        JarEntry jarEntry = this.libraryJar.getJarEntry(string.replace('.', '/') + ".class");
        if (SWTTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadClassFromOurJar(String,boolean)", 494).add("entry", (Object)jarEntry)).log();
        }
        if (jarEntry != null) {
            return this.loadClassFromOurJar(jarEntry, bl);
        }
        return null;
    }

    private Class loadClassFromOurJar(JarEntry jarEntry, boolean bl) {
        block15: {
            if (SWTTransformer.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadClassFromOurJar(JarEntry,boolean)", 512).addDetail("entry", (Object)jarEntry)).addDetail("resolve", bl)).log();
            }
            byte[] byArray = this.readClass(jarEntry);
            if (SWTTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadClassFromOurJar(JarEntry,boolean)", 515).add("bytes", (Object)byArray)).log();
            }
            if (byArray != null) {
                try {
                    Class clazz;
                    String string = jarEntry.getName();
                    string = string.substring(0, string.length() - 6).replace('/', '.');
                    if (SWTTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadClassFromOurJar(JarEntry,boolean)", 520).add("className", string)).log();
                    }
                    if (!this.moduleOpened) {
                        block14: {
                            try {
                                clazz = Class.forName("de.qfs.apps.qftest.instrument.ModuleHelper");
                                SWTTransformer.callMethod(clazz, "openModule", null, new Class[]{Class.class, Object.class}, new Object[]{ClassLoader.class, this.getClass()});
                                if (SWTTransformer.logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadClassFromOurJar(JarEntry,boolean)", 527).add("Module opened")).log();
                                }
                            }
                            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                                if (SWTTransformer.logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadClassFromOurJar(JarEntry,boolean)", 529).add("Module not opened, older JRE")).log();
                                }
                            }
                            catch (Throwable throwable) {
                                if (SWTTransformer.logger.level < 3) break block14;
                                ((LevelAwareLogBuilder)logger.lvlBuild(3, "loadClassFromOurJar(JarEntry,boolean)", 531).add("ex", (Object)throwable)).log();
                            }
                        }
                        this.moduleOpened = true;
                    }
                    clazz = (Class)SWTTransformer.callMethod(ClassLoader.class, "defineClass", this.loader, new Class[]{String.class, BYTE_ARRAY_CLASS, Integer.TYPE, Integer.TYPE, ProtectionDomain.class}, new Object[]{string, byArray, 0, byArray.length, this.domain});
                    if (SWTTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadClassFromOurJar(JarEntry,boolean)", 540).add("ret", (Object)clazz)).log();
                    }
                    if (bl) {
                        SWTTransformer.callMethod(ClassLoader.class, "resolveClass", this.loader, new Class[]{Class.class}, new Object[]{clazz});
                    }
                    return clazz;
                }
                catch (Throwable throwable) {
                    if (SWTTransformer.logger.level < 5) break block15;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "loadClassFromOurJar(JarEntry,boolean)", 547).add("ex", (Object)throwable)).log();
                }
            }
        }
        return null;
    }

    private void loadInnerClasses(String string) {
        if (SWTTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "loadInnerClasses(String)", 556).addDetail("className", string)).log();
        }
        String string2 = string.replace('.', '/') + "$";
        Enumeration<JarEntry> enumeration = this.libraryJar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().startsWith(string2)) continue;
            if (SWTTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadInnerClasses(String)", 562).add("entry", (Object)jarEntry)).log();
            }
            URL uRL = this.loader.getResource(jarEntry.getName());
            if (SWTTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadInnerClasses(String)", 569).add("orig", (Object)uRL)).log();
            }
            if (uRL != null) continue;
            try {
                this.loadClassFromOurJar(jarEntry, true);
            }
            catch (Throwable throwable) {
                if (SWTTransformer.logger.level < 5) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "loadInnerClasses(String)", 574).add("ex", (Object)throwable)).log();
            }
        }
    }
}

