/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.log.LogLevels;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class Logger {
    public int level;
    public static final int DEFAULT_LOG_LEVEL = 4;
    private static final int AVERAGE_MESSAGE_SIZE = 200;
    private static final int DEFAULT_NUMBER_OF_ELEMENTS_TO_LOG_IN_ARRAY = 30;
    private static final int DEFAULT_NUMBER_OF_ELEMENTS_TO_LOG_IN_MAP = 50;
    private String owner;
    private static final char[] nibbles = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static LogLevels levels = new LogLevels();
    private static ThreadLocal localBOS = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new ByteArrayOutputStream(1000);
        }
    };
    private static ThreadLocal localPW = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new PrintWriter((ByteArrayOutputStream)localBOS.get());
        }
    };
    private static Boolean is14;
    private static Method getStackTrace;
    private static Method getClassName;
    private static final Class[] noArgsArray;

    public Logger(String string) {
        this.owner = string;
        this.setLevel(Logger.getLogLevel(this));
    }

    public Logger(Object object) {
        this(object.getClass().getName());
    }

    public Logger(Class clazz) {
        this(clazz.getName());
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public static void setDefaultLogLevel(int n) {
        if (levels != null) {
            levels.setDefaultLogLevel(n);
        }
    }

    public static void setLogLevel(String string, int n) {
        if (levels != null) {
            levels.setLogLevel(string, n);
        }
    }

    public static void removeLogLevel(String string) {
        if (levels != null) {
            levels.removeLogLevel(string);
        }
    }

    public static int getLogLevel(Logger logger) {
        if (levels != null) {
            return levels.getLogLevel(logger);
        }
        return 4;
    }

    public static void setLogLevels(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("log-")) continue;
            try {
                int n = Integer.parseInt((String)hashtable.get(string));
                if (string.equals("log-default")) {
                    Logger.setDefaultLogLevel(n);
                    continue;
                }
                Logger.setLogLevel(string.substring(4), n);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public static void setLogLevels(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!string.startsWith("log-")) continue;
            try {
                int n = Integer.parseInt(resourceBundle.getString(string));
                if (string.equals("log-default")) {
                    Logger.setDefaultLogLevel(n);
                    continue;
                }
                Logger.setLogLevel(string.substring(4), n);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static void addLogLevelListener(LogLevelListener logLevelListener) {
        levels.addLogLevelListener(logLevelListener);
    }

    public static void removeLogLevelListener(LogLevelListener logLevelListener) {
        levels.removeLogLevelListener(logLevelListener);
    }

    public static Object[] getLogLevels() {
        return levels.getLogLevels();
    }

    public static void setLogLevel(LogLevelListener logLevelListener, String string, int n) {
        levels.setLogLevel(logLevelListener, string, n);
    }

    public static void removeLogLevel(LogLevelListener logLevelListener, String string) {
        levels.removeLogLevel(logLevelListener, string);
    }

    public void log(int n, String string, String string2) {
        Log.log(n, System.currentTimeMillis(), this.owner, string, string2);
    }

    public void log(String string, Throwable throwable) {
        Log.log(1, this.owner, string, throwable);
    }

    public void log(String string, Throwable throwable, String string2) {
        Log.log(1, this.owner, string, throwable, string2);
    }

    public void log(int n, String string, Throwable throwable) {
        Log.log(n, this.owner, string, throwable);
    }

    public void log(int n, String string, Throwable throwable, String string2) {
        Log.log(n, this.owner, string, throwable, string2);
    }

    public void dumpStack(int n, String string, String string2) {
        try {
            throw new Log.DumpStackException(string2);
        }
        catch (Exception exception) {
            this.log(n, string, exception);
            return;
        }
    }

    @Deprecated
    public Builder build(String string) {
        return new Builder(string);
    }

    public final void err(String string, String string2) {
        if (this.level >= 1) {
            Log.log(1, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void err(String string, Throwable throwable) {
        if (this.level >= 1) {
            Log.log(1, this.owner, string, throwable);
        }
    }

    public final void err(String string, Throwable throwable, String string2) {
        if (this.level >= 1) {
            Log.log(1, this.owner, string, throwable, string2);
        }
    }

    public final void wrn(String string, String string2) {
        if (this.level >= 3) {
            Log.log(3, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void wrn(String string, Throwable throwable) {
        if (this.level >= 3) {
            Log.log(3, this.owner, string, throwable);
        }
    }

    public final void wrn(String string, Throwable throwable, String string2) {
        if (this.level >= 3) {
            Log.log(3, this.owner, string, throwable, string2);
        }
    }

    public final void msg(String string, String string2) {
        if (this.level >= 5) {
            Log.log(5, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void msg(String string, Throwable throwable) {
        if (this.level >= 5) {
            Log.log(5, this.owner, string, throwable);
        }
    }

    public final void msg(String string, Throwable throwable, String string2) {
        if (this.level >= 5) {
            Log.log(5, this.owner, string, throwable, string2);
        }
    }

    public final void mtd(String string, String string2) {
        if (this.level >= 7) {
            Log.log(7, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void mtd(String string, Throwable throwable) {
        if (this.level >= 7) {
            Log.log(7, this.owner, string, throwable);
        }
    }

    public final void mtd(String string, Throwable throwable, String string2) {
        if (this.level >= 7) {
            Log.log(7, this.owner, string, throwable, string2);
        }
    }

    public final void dbg(String string, String string2) {
        if (this.level >= 9) {
            Log.log(9, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void dbg(String string, Throwable throwable) {
        if (this.level >= 9) {
            Log.log(9, this.owner, string, throwable);
        }
    }

    public final void dbg(String string, Throwable throwable, String string2) {
        if (this.level >= 9) {
            Log.log(9, this.owner, string, throwable, string2);
        }
    }

    public String getOwnerName() {
        return this.owner;
    }

    static {
        noArgsArray = new Class[0];
    }

    public class Builder {
        private StringBuilder sb;
        private String method;

        public Builder(String string) {
            this.method = string;
            this.sb = new StringBuilder(200);
        }

        public final Builder add(boolean bl) {
            this.sb.append(bl);
            return this;
        }

        public final Builder add(byte by) {
            this.sb.append(by);
            return this;
        }

        public final Builder add(char c) {
            this.sb.append(c);
            return this;
        }

        public final Builder add(int n) {
            this.sb.append(n);
            return this;
        }

        public final Builder addHex(int n) {
            this.sb.append("0x");
            this.sb.append(Integer.toHexString(n));
            return this;
        }

        public final Builder addHex(Integer n) {
            if (n != null) {
                return this.addHex((int)n);
            }
            this.sb.append("null");
            return this;
        }

        public final Builder add(long l) {
            this.sb.append(l);
            return this;
        }

        public final Builder addHex(long l) {
            this.sb.append("0x");
            this.sb.append(Long.toHexString(l));
            return this;
        }

        public final Builder addHex(Long l) {
            if (l != null) {
                return this.addHex((long)l);
            }
            this.sb.append("null");
            return this;
        }

        public final Builder add(double d) {
            this.sb.append(d);
            return this;
        }

        public Builder add(Object object) {
            if (object == null) {
                this.sb.append(object);
            } else {
                try {
                    if (object.getClass().isArray()) {
                        return this.addArray(object);
                    }
                    if (object instanceof Iterable) {
                        return this.addIterable((Iterable)object);
                    }
                    if (object instanceof Map) {
                        return this.addMap((Map)object);
                    }
                    this.sb.append(object);
                }
                catch (Throwable throwable) {
                    Log.log(3, Logger.this.owner, this.method, throwable);
                    this.sb.append("EXCEPTED");
                }
            }
            return this;
        }

        public final Builder add(String string) {
            this.sb.append(string);
            return this;
        }

        private Builder addArray(Object object) {
            assert (object != null);
            assert (object.getClass().isArray());
            int n = Array.getLength(object);
            int n2 = Math.max(0, n - 30);
            this.sb.append("[");
            for (int i = 0; i < n - n2; ++i) {
                Object object2;
                if (i > 0) {
                    this.sb.append(',');
                }
                this.add((object2 = Array.get(object, i)) == object ? "(this Array)" : object2);
            }
            if (n2 > 0) {
                this.sb.append(",... (").append(n2).append(" more)");
            }
            this.sb.append("]");
            return this;
        }

        private Builder addIterable(Iterable iterable) {
            if (iterable == null) {
                this.sb.append(iterable);
            } else {
                this.sb.append("[");
                int n = 0;
                try {
                    for (Object t : iterable) {
                        if (n > 0) {
                            this.sb.append(',');
                        }
                        if (++n > 30) {
                            this.sb.append("...");
                            if (iterable instanceof Collection) {
                                int n2 = ((Collection)iterable).size();
                                int n3 = n2 - 30;
                                this.sb.append(String.format(" (%d more)", n3));
                            }
                            break;
                        }
                        this.add((Object)(t == iterable ? "(this Iterable)" : t));
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    this.sb.append(" ConcurrentModification!");
                }
                this.sb.append("]");
            }
            return this;
        }

        private Builder addMap(Map map) {
            if (map == null) {
                this.sb.append(map);
            } else {
                this.sb.append("{");
                try {
                    int n = 0;
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        if (n > 0) {
                            this.sb.append(',');
                        }
                        if (++n > 50) {
                            this.sb.append("...");
                            int n2 = set.size();
                            int n3 = n2 - 50;
                            this.sb.append(String.format(" (%d more)", n3));
                            break;
                        }
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        this.add((Object)(k == map ? "(this Map)" : k));
                        this.sb.append("=");
                        this.add((Object)(v == map ? "(this Map)" : v));
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    this.sb.append(" ConcurrentModification!");
                }
                this.sb.append("}");
            }
            return this;
        }

        public final Builder addAll(Object object) {
            if (object instanceof Object[]) {
                return this.addAll((Object[])object);
            }
            if (object instanceof int[]) {
                return this.addAll((int[])object);
            }
            if (object instanceof long[]) {
                return this.addAll((long[])object);
            }
            this.sb.append(object);
            return this;
        }

        public final Builder addAll(Object[] objectArray) {
            if (objectArray == null) {
                this.sb.append((String)null);
            } else {
                this.sb.append("[");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        this.sb.append(',');
                    }
                    this.addAll(objectArray[i]);
                }
                this.sb.append("]");
            }
            return this;
        }

        public final Builder addAll(int[] nArray) {
            if (nArray == null) {
                this.sb.append((String)null);
            } else {
                this.sb.append("[");
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        this.sb.append(',');
                    }
                    this.sb.append(nArray[i]);
                }
                this.sb.append("]");
            }
            return this;
        }

        public final Builder addAll(long[] lArray) {
            if (lArray == null) {
                this.sb.append((String)null);
            } else {
                this.sb.append("[");
                for (int i = 0; i < lArray.length; ++i) {
                    if (i > 0) {
                        this.sb.append(',');
                    }
                    this.sb.append(lArray[i]);
                }
                this.sb.append("]");
            }
            return this;
        }

        public void log(int n) {
            Logger.this.log(n, this.method, this.sb.toString());
        }

        public void dumpStack(int n) {
            Logger.this.dumpStack(n, this.method, this.sb.toString());
        }
    }
}

