/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.webkit.GdkRectangle;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    long webView;
    long scrolledWindow;
    long webViewData;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    String postData;
    String[] headers;
    boolean ignoreDispose;
    boolean loadingText;
    boolean untrustedText;
    byte[] htmlBytes;
    BrowserFunction eventFunction;
    private static int nonBlockingEvaluate = 0;
    static int DisabledJSCount;
    static long ExternalClass;
    static long PostString;
    static long WebViewType;
    static boolean IsWebKit14orNewer;
    static boolean LibraryLoaded;
    static Map<LONG, LONG> WindowMappings;
    static final String ABOUT_BLANK = "about:blank";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String HEADER_CONTENTTYPE = "content-type";
    static final String MIMETYPE_FORMURLENCODED = "application/x-www-form-urlencoded";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final int SENTINEL_KEYPRESS = -1;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final int HOVERING_OVER_LINK = 1;
    static final int NOTIFY_PROGRESS = 2;
    static final int NAVIGATION_POLICY_DECISION_REQUESTED = 3;
    static final int NOTIFY_TITLE = 4;
    static final int POPULATE_POPUP = 5;
    static final int STATUS_BAR_TEXT_CHANGED = 6;
    static final int CREATE_WEB_VIEW = 7;
    static final int WEB_VIEW_READY = 8;
    static final int NOTIFY_LOAD_STATUS = 9;
    static final int RESOURCE_REQUEST_STARTING = 10;
    static final int DOWNLOAD_REQUESTED = 11;
    static final int MIME_TYPE_POLICY_DECISION_REQUESTED = 12;
    static final int CLOSE_WEB_VIEW = 13;
    static final int WINDOW_OBJECT_CLEARED = 14;
    static final int CONSOLE_MESSAGE = 15;
    static final int LOAD_CHANGED = 16;
    static final int DECIDE_POLICY = 17;
    static final int MOUSE_TARGET_CHANGED = 18;
    static final int CONTEXT_MENU = 19;
    static final int AUTHENTICATE = 20;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static final String SWT_WEBKITGTK_VERSION = "org.eclipse.swt.internal.webkitgtk.version";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback Proc6;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static Callback JSDOMEventProc;
    static boolean WEBKIT2;

    WebKit() {
    }

    @Override
    String getJavaCallDeclaration() {
        if (WEBKIT2) {
            return "if (!window.callJava) {\n\t\twindow.callJava = function callJava(index, token, args) {\n         window.webkit.messageHandlers.webkit2JavaCallProc.postMessage([index,token, args]);\n\t\t}\n};\n";
        }
        return super.getJavaCallDeclaration();
    }

    private static int[] internalGetWebkitVersion() {
        int[] nArray = new int[3];
        if (WEBKIT2) {
            nArray[0] = WebKitGTK.webkit_get_major_version();
            nArray[1] = WebKitGTK.webkit_get_minor_version();
            nArray[2] = WebKitGTK.webkit_get_micro_version();
        } else {
            nArray[0] = WebKitGTK.webkit_major_version();
            nArray[1] = WebKitGTK.webkit_minor_version();
            nArray[2] = WebKitGTK.webkit_micro_version();
        }
        return nArray;
    }

    static String getString(long l) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(byArray));
    }

    static Browser FindBrowser(long l) {
        if (l == 0L) {
            return null;
        }
        long l2 = OS.gtk_widget_get_parent(l);
        if (!WEBKIT2) {
            l2 = OS.gtk_widget_get_parent(l2);
        }
        return (Browser)Display.getCurrent().findWidget(l2);
    }

    static boolean IsInstalled() {
        if (!LibraryLoaded) {
            return false;
        }
        int[] nArray = WebKit.internalGetWebkitVersion();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        IsWebKit14orNewer = n > 1 || n == 1 && n2 > 4 || n == 1 && n2 == 4 && n3 >= 0;
        return n > MIN_VERSION[0] || n == MIN_VERSION[0] && n2 > MIN_VERSION[1] || n == MIN_VERSION[0] && n2 == MIN_VERSION[1] && n3 >= MIN_VERSION[2];
    }

    static long JSObjectCallAsFunctionProc(long l, long l2, long l3, long l4, long l5, long l6) {
        if (WEBKIT2) {
            System.err.println("Internal error: SWT JSObjectCallAsFunctionProc. This should never have been called on webkit2.");
            return 0L;
        }
        if (WebKitGTK.JSValueIsObjectOfClass(l, l3, ExternalClass) == 0) {
            return WebKitGTK.JSValueMakeUndefined(l);
        }
        long l7 = WebKitGTK.JSObjectGetPrivate(l3);
        long[] lArray = new long[1];
        C.memmove(lArray, l7, (long)C.PTR_SIZEOF);
        Browser browser = WebKit.FindBrowser(lArray[0]);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.callJava(l, l2, l3, l4, l5, l6);
    }

    static long JSObjectGetPropertyProc(long l, long l2, long l3, long l4) {
        if (WEBKIT2) {
            System.err.println("Internal error: SWT WebKit.java:JSObjectGetPropertyProc. This should never have been called on webkit2.");
            return 0L;
        }
        byte[] byArray = "callJava\u0000".getBytes(StandardCharsets.UTF_8);
        long l5 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        long l6 = WebKitGTK.JSObjectMakeFunctionWithCallback(l, l5, JSObjectCallAsFunctionProc.getAddress());
        WebKitGTK.JSStringRelease(l5);
        return l6;
    }

    static long JSObjectHasPropertyProc(long l, long l2, long l3) {
        if (WEBKIT2) {
            System.err.println("Internal error: SWT JSObjectHasPropertyProc. This should never have been called on webkit2.");
            return 0L;
        }
        byte[] byArray = "callJava\u0000".getBytes(StandardCharsets.UTF_8);
        return WebKitGTK.JSStringIsEqualToUTF8CString(l3, byArray);
    }

    static long JSDOMEventProc(long l, long l2, long l3) {
        block14: {
            block15: {
                Browser browser;
                block16: {
                    if (OS.GTK_IS_SCROLLED_WINDOW(l)) {
                        return l3;
                    }
                    if (!OS.G_TYPE_CHECK_INSTANCE_TYPE(l, WebViewType)) break block14;
                    if (DisabledJSCount <= 0 || (browser = WebKit.FindBrowser(l)) == null || browser.webBrowser.jsEnabled) break block15;
                    block0 : switch (OS.GDK_EVENT_TYPE(l2)) {
                        case 8: {
                            if (!browser.isFocusControl()) break;
                            GdkEventKey gdkEventKey = new GdkEventKey();
                            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
                            switch (gdkEventKey.keyval) {
                                case 65056: 
                                case 65289: {
                                    if ((gdkEventKey.state & 0xC) == 0) {
                                        browser.getDisplay().asyncExec(() -> {
                                            if (browser.isDisposed()) {
                                                return;
                                            }
                                            if (browser.getDisplay().getFocusControl() == null) {
                                                int n = (gdkEventKey.state & 1) != 0 ? 8 : 16;
                                                browser.traverse(n);
                                            }
                                        });
                                        break block0;
                                    }
                                    break block16;
                                }
                                case 65307: {
                                    Event event = new Event();
                                    event.widget = browser;
                                    event.type = 1;
                                    event.character = (char)27;
                                    event.keyCode = 27;
                                    if ((gdkEventKey.state & 8) != 0) {
                                        event.stateMask |= 0x10000;
                                    }
                                    if ((gdkEventKey.state & 1) != 0) {
                                        event.stateMask |= 0x20000;
                                    }
                                    if ((gdkEventKey.state & 4) != 0) {
                                        event.stateMask |= 0x40000;
                                    }
                                    browser.webBrowser.sendKeyEvent(event);
                                    return 1L;
                                }
                            }
                        }
                    }
                }
                OS.gtk_widget_event(browser.handle, l2);
            }
            return 0L;
        }
        LONG lONG = WindowMappings.get(new LONG(l));
        if (lONG == null) {
            return 0L;
        }
        Browser browser = WebKit.FindBrowser(lONG.value);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.handleDOMEvent(l2, (int)l3) ? 0L : 1L;
    }

    static long Proc(long l, long l2) {
        Browser browser = WebKit.FindBrowser(l);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2);
    }

    static long Proc(long l, long l2, long l3) {
        long l4;
        if (OS.G_TYPE_CHECK_INSTANCE_TYPE(l, WebKitGTK.webkit_web_view_get_type())) {
            l4 = l;
        } else if (OS.G_TYPE_CHECK_INSTANCE_TYPE(l, WebKitGTK.webkit_web_frame_get_type())) {
            l4 = WebKitGTK.webkit_web_frame_get_web_view(l);
        } else {
            return 0L;
        }
        Browser browser = WebKit.FindBrowser(l4);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (l4 == l) {
            return webKit.webViewProc(l, l2, l3);
        }
        return webKit.webFrameProc(l, l2, l3);
    }

    static long Proc(long l, long l2, long l3, long l4) {
        Browser browser = WebKit.FindBrowser(l);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2, l3, l4);
    }

    static long Proc(long l, long l2, long l3, long l4, long l5) {
        long l6 = !WEBKIT2 && OS.G_TYPE_CHECK_INSTANCE_TYPE(l, WebKitGTK.soup_session_get_type()) ? l5 : l;
        Browser browser = WebKit.FindBrowser(l6);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (!WEBKIT2 && l6 == l5) {
            return webKit.sessionProc(l, l2, l3, l4, l5);
        }
        return webKit.webViewProc(l, l2, l3, l4, l5);
    }

    static long Proc(long l, long l2, long l3, long l4, long l5, long l6) {
        Browser browser = WebKit.FindBrowser(l);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2, l3, l4, l5, l6);
    }

    long sessionProc(long l, long l2, long l3, long l4, long l5) {
        if (l4 == 0L) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0L;
        }
        long l6 = WebKitGTK.soup_message_get_uri(l2);
        long l7 = WebKitGTK.soup_uri_to_string(l6, 0);
        int n = C.strlen(l7);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l7, (long)n);
        OS.g_free(l7);
        String string = new String(Converter.mbcsToWcs(byArray));
        for (int i = 0; i < this.authenticationListeners.length; ++i) {
            AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
            authenticationEvent.location = string;
            this.authenticationListeners[i].authenticate(authenticationEvent);
            if (!authenticationEvent.doit) {
                OS.g_signal_stop_emission_by_name(l, WebKitGTK.authenticate);
                return 0L;
            }
            if (authenticationEvent.user == null || authenticationEvent.password == null) continue;
            byte[] byArray2 = Converter.wcsToMbcs(authenticationEvent.user, true);
            byte[] byArray3 = Converter.wcsToMbcs(authenticationEvent.password, true);
            WebKitGTK.soup_auth_authenticate(l3, byArray2, byArray3);
            OS.g_signal_stop_emission_by_name(l, WebKitGTK.authenticate);
            return 0L;
        }
        return 0L;
    }

    long webkit_authenticate(long l, long l2) {
        if (!WebKitGTK.webkit_authentication_request_is_retry(l2)) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0L;
        }
        String string = this.getUrl();
        for (int i = 0; i < this.authenticationListeners.length; ++i) {
            AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
            authenticationEvent.location = string;
            try {
                ++nonBlockingEvaluate;
                this.authenticationListeners[i].authenticate(authenticationEvent);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                --nonBlockingEvaluate;
            }
            if (!authenticationEvent.doit) {
                WebKitGTK.webkit_authentication_request_cancel(l2);
                return 0L;
            }
            if (authenticationEvent.user == null || authenticationEvent.password == null) continue;
            byte[] byArray = Converter.wcsToMbcs(authenticationEvent.user, true);
            byte[] byArray2 = Converter.wcsToMbcs(authenticationEvent.password, true);
            long l3 = WebKitGTK.webkit_credential_new(byArray, byArray2, 0);
            WebKitGTK.webkit_authentication_request_authenticate(l2, l3);
            WebKitGTK.webkit_credential_free(l3);
            return 0L;
        }
        return 0L;
    }

    long webFrameProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 9: {
                return this.webframe_notify_load_status(l, l2);
            }
            case 16: {
                return this.webkit_load_changed(l, (int)l2, l3);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2) {
        switch ((int)l2) {
            case 13: {
                return this.webkit_close_web_view(l);
            }
            case 8: {
                return this.webkit_web_view_ready(l);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 7: {
                return this.webkit_create_web_view(l, l2);
            }
            case 11: {
                return this.webkit_download_requested(l, l2);
            }
            case 9: {
                return this.webkit_notify_load_status(l, l2);
            }
            case 16: {
                return this.webkit_load_changed(l, (int)l2, l3);
            }
            case 2: {
                return this.webkit_notify_progress(l, l2);
            }
            case 4: {
                return this.webkit_notify_title(l, l2);
            }
            case 5: {
                return this.webkit_populate_popup(l, l2);
            }
            case 6: {
                return this.webkit_status_bar_text_changed(l, l2);
            }
            case 20: {
                return this.webkit_authenticate(l, l2);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4) {
        switch ((int)l4) {
            case 1: {
                return this.webkit_hovering_over_link(l, l2, l3);
            }
            case 18: {
                return this.webkit_mouse_target_changed(l, l2, l3);
            }
            case 17: {
                return this.webkit_decide_policy(l, l2, (int)l3, l4);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4, long l5) {
        switch ((int)l5) {
            case 15: {
                return this.webkit_console_message(l, l2, l3, l4);
            }
            case 14: {
                return this.webkit_window_object_cleared(l, l2, l3, l4);
            }
            case 19: {
                return this.webkit_context_menu(l, l2, l3, l4);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4, long l5, long l6) {
        switch ((int)l6) {
            case 12: {
                return this.webkit_mime_type_policy_decision_requested(l, l2, l3, l4, l5);
            }
            case 3: {
                return this.webkit_navigation_policy_decision_requested(l, l2, l3, l4, l5);
            }
            case 10: {
                return this.webkit_resource_request_starting(l, l2, l3, l4, l5);
            }
        }
        return 0L;
    }

    @Override
    public void create(Composite composite, int n) {
        Object object;
        if (ExternalClass == 0L) {
            long l;
            Object object2;
            int[] nArray = WebKit.internalGetWebkitVersion();
            System.setProperty(SWT_WEBKITGTK_VERSION, String.format("%s.%s.%s", nArray[0], nArray[1], nArray[2]));
            if (Device.DEBUG) {
                System.out.println(String.format("WebKit version %s.%s.%s", nArray[0], nArray[1], nArray[2]));
            }
            if (!WEBKIT2) {
                object2 = new JSClassDefinition();
                byte[] byArray = Converter.wcsToMbcs(CLASSNAME_EXTERNAL, true);
                ((JSClassDefinition)object2).className = C.malloc(byArray.length);
                OS.memmove(((JSClassDefinition)object2).className, byArray, (long)byArray.length);
                ((JSClassDefinition)object2).hasProperty = JSObjectHasPropertyProc.getAddress();
                ((JSClassDefinition)object2).getProperty = JSObjectGetPropertyProc.getAddress();
                long l2 = C.malloc(JSClassDefinition.sizeof);
                WebKitGTK.memmove(l2, (JSClassDefinition)object2, (long)JSClassDefinition.sizeof);
                ExternalClass = WebKitGTK.JSClassCreate(l2);
            }
            object2 = Converter.wcsToMbcs("POST", true);
            PostString = C.malloc(((Object)object2).length);
            C.memmove(PostString, (byte[])object2, (long)((Object)object2).length);
            if (!WEBKIT2 && (l = WebKitGTK.webkit_get_favicon_database()) != 0L) {
                WebKitGTK.webkit_favicon_database_set_path(l, 0L);
            }
        }
        if (!WEBKIT2) {
            this.scrolledWindow = OS.gtk_scrolled_window_new(0L, 0L);
            OS.gtk_scrolled_window_set_policy(this.scrolledWindow, 1, 1);
        }
        if (WEBKIT2) {
            long l = WebKitGTK.webkit_user_content_manager_new();
            this.webView = WebKitGTK.webkit_web_view_new_with_user_content_manager(l);
            Webkit2JavaCallback.connectSignal(l, this.webView);
        } else {
            this.webView = WebKitGTK.webkit_web_view_new();
        }
        if (!WEBKIT2) {
            this.webViewData = C.malloc(C.PTR_SIZEOF);
            C.memmove(this.webViewData, new long[]{this.webView}, (long)C.PTR_SIZEOF);
        }
        if (!WEBKIT2) {
            OS.gtk_container_add(this.scrolledWindow, this.webView);
            OS.gtk_container_add(this.browser.handle, this.scrolledWindow);
            OS.gtk_widget_show(this.scrolledWindow);
            OS.g_signal_connect(this.webView, WebKitGTK.close_web_view, Proc2.getAddress(), 13L);
            OS.g_signal_connect(this.webView, WebKitGTK.console_message, Proc5.getAddress(), 15L);
            OS.g_signal_connect(this.webView, WebKitGTK.create_web_view, Proc3.getAddress(), 7L);
            OS.g_signal_connect(this.webView, WebKitGTK.notify_load_status, Proc3.getAddress(), 9L);
            OS.g_signal_connect(this.webView, WebKitGTK.web_view_ready, Proc2.getAddress(), 8L);
            OS.g_signal_connect(this.webView, WebKitGTK.navigation_policy_decision_requested, Proc6.getAddress(), 3L);
            OS.g_signal_connect(this.webView, WebKitGTK.mime_type_policy_decision_requested, Proc6.getAddress(), 12L);
            OS.g_signal_connect(this.webView, WebKitGTK.resource_request_starting, Proc6.getAddress(), 10L);
            OS.g_signal_connect(this.webView, WebKitGTK.download_requested, Proc3.getAddress(), 11L);
            OS.g_signal_connect(this.webView, WebKitGTK.hovering_over_link, Proc4.getAddress(), 1L);
            OS.g_signal_connect(this.webView, WebKitGTK.populate_popup, Proc3.getAddress(), 5L);
            OS.g_signal_connect(this.webView, WebKitGTK.notify_progress, Proc3.getAddress(), 2L);
            OS.g_signal_connect(this.webView, WebKitGTK.window_object_cleared, Proc5.getAddress(), 14L);
            OS.g_signal_connect(this.webView, WebKitGTK.status_bar_text_changed, Proc3.getAddress(), 6L);
        } else {
            OS.gtk_container_add(this.browser.handle, this.webView);
            OS.g_signal_connect(this.webView, WebKitGTK.close, Proc2.getAddress(), 13L);
            OS.g_signal_connect(this.webView, WebKitGTK.create, Proc3.getAddress(), 7L);
            OS.g_signal_connect(this.webView, WebKitGTK.load_changed, Proc3.getAddress(), 16L);
            OS.g_signal_connect(this.webView, WebKitGTK.ready_to_show, Proc2.getAddress(), 8L);
            OS.g_signal_connect(this.webView, WebKitGTK.decide_policy, Proc4.getAddress(), 17L);
            OS.g_signal_connect(WebKitGTK.webkit_web_context_get_default(), WebKitGTK.download_started, Proc3.getAddress(), 11L);
            OS.g_signal_connect(this.webView, WebKitGTK.mouse_target_changed, Proc4.getAddress(), 18L);
            OS.g_signal_connect(this.webView, WebKitGTK.context_menu, Proc5.getAddress(), 19L);
            OS.g_signal_connect(this.webView, WebKitGTK.notify_estimated_load_progress, Proc3.getAddress(), 2L);
            OS.g_signal_connect(this.webView, WebKitGTK.authenticate, Proc3.getAddress(), 20L);
        }
        OS.gtk_widget_show(this.webView);
        OS.gtk_widget_show(this.browser.handle);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 4L);
        OS.g_signal_connect(this.webView, OS.button_press_event, JSDOMEventProc.getAddress(), 0L);
        OS.g_signal_connect(this.webView, OS.button_release_event, JSDOMEventProc.getAddress(), 0L);
        OS.g_signal_connect(this.webView, OS.key_press_event, JSDOMEventProc.getAddress(), 0L);
        OS.g_signal_connect(this.webView, OS.key_release_event, JSDOMEventProc.getAddress(), 0L);
        OS.g_signal_connect(this.webView, OS.scroll_event, JSDOMEventProc.getAddress(), 0L);
        OS.g_signal_connect(this.webView, OS.motion_notify_event, JSDOMEventProc.getAddress(), 0L);
        if (!WEBKIT2) {
            OS.g_signal_connect(this.scrolledWindow, OS.button_press_event, JSDOMEventProc.getAddress(), 1L);
            OS.g_signal_connect(this.scrolledWindow, OS.button_release_event, JSDOMEventProc.getAddress(), 1L);
            OS.g_signal_connect(this.scrolledWindow, OS.key_press_event, JSDOMEventProc.getAddress(), 1L);
            OS.g_signal_connect(this.scrolledWindow, OS.key_release_event, JSDOMEventProc.getAddress(), 1L);
            OS.g_signal_connect(this.scrolledWindow, OS.scroll_event, JSDOMEventProc.getAddress(), 1L);
            OS.g_signal_connect(this.scrolledWindow, OS.motion_notify_event, JSDOMEventProc.getAddress(), 1L);
        }
        byte[] byArray = Converter.wcsToMbcs("UTF-8", true);
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(l, WebKitGTK.javascript_can_open_windows_automatically, 1, 0L);
        OS.g_object_set(l, WebKitGTK.enable_webgl, 1, 0L);
        if (WEBKIT2) {
            OS.g_object_set(l, WebKitGTK.default_charset, byArray, 0L);
            OS.g_object_set(l, WebKitGTK.allow_universal_access_from_file_urls, 1, 0L);
        } else {
            OS.g_object_set(l, WebKitGTK.default_encoding, byArray, 0L);
            OS.g_object_set(l, WebKitGTK.enable_universal_access_from_file_uris, 1, 0L);
        }
        Listener listener = event -> {
            switch (event.type) {
                case 12: {
                    if (this.ignoreDispose) {
                        this.ignoreDispose = false;
                        break;
                    }
                    this.ignoreDispose = true;
                    this.browser.notifyListeners(event.type, event);
                    event.type = 0;
                    this.onDispose(event);
                    break;
                }
                case 15: {
                    OS.gtk_widget_grab_focus(this.webView);
                    break;
                }
                case 11: {
                    this.onResize(event);
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        if (!WEBKIT2) {
            long l3 = WebKitGTK.webkit_get_default_session();
            long l4 = WebKitGTK.soup_session_get_feature(l3, WebKitGTK.webkit_soup_auth_dialog_get_type());
            if (l4 != 0L) {
                WebKitGTK.soup_session_feature_detach(l4, l3);
            }
            OS.g_signal_connect(l3, WebKitGTK.authenticate, Proc5.getAddress(), this.webView);
            if (l4 != 0L) {
                WebKitGTK.soup_session_feature_attach(l4, l3);
            }
            object = System.getProperty(PROPERTY_PROXYHOST);
            String string = System.getProperty(PROPERTY_PROXYPORT);
            int n2 = -1;
            if (string != null) {
                try {
                    int n3 = Integer.valueOf(string);
                    if (0 <= n3 && n3 <= 65535) {
                        n2 = n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object != null || n2 != -1) {
                long l5;
                if (!((String)object).startsWith(PROTOCOL_HTTP)) {
                    object = PROTOCOL_HTTP + (String)object;
                }
                if ((l5 = WebKitGTK.soup_uri_new(byArray = Converter.wcsToMbcs((String)(object = (String)object + ":" + n2), true))) != 0L) {
                    OS.g_object_set(l3, WebKitGTK.SOUP_SESSION_PROXY_URI, l5, 0L);
                    WebKitGTK.soup_uri_free(l5);
                }
            }
        }
        if (!WEBKIT2) {
            this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

                @Override
                public Object function(Object[] objectArray) {
                    return WebKit.this.handleEventFromFunction(objectArray) ? Boolean.TRUE : Boolean.FALSE;
                }
            };
        }
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
        int[] nArray = WebKit.internalGetWebkitVersion();
        int n4 = nArray[0];
        int n5 = nArray[1];
        if (n4 == 1 && n5 >= 10) {
            Rectangle rectangle = this.browser.computeTrim(0, 0, 2, 2);
            object = this.browser.getSize();
            ((Point)object).x += rectangle.width;
            ((Point)object).y += rectangle.height;
            this.browser.setSize((Point)object);
            ((Point)object).x -= rectangle.width;
            ((Point)object).y -= rectangle.height;
            this.browser.setSize((Point)object);
        }
    }

    void addEventHandlers(long l, boolean bl) {
        if (!this.jsEnabled) {
            return;
        }
        if (bl && IsWebKit14orNewer) {
            long l2 = WebKitGTK.webkit_web_view_get_dom_document(l);
            if (l2 != 0L) {
                WindowMappings.put(new LONG(l2), new LONG(l));
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.dragstart, JSDOMEventProc.getAddress(), 0, 29L);
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.keydown, JSDOMEventProc.getAddress(), 0, 1L);
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.keypress, JSDOMEventProc.getAddress(), 0, -1L);
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.keyup, JSDOMEventProc.getAddress(), 0, 2L);
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.mousedown, JSDOMEventProc.getAddress(), 0, 3L);
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.mousemove, JSDOMEventProc.getAddress(), 0, 5L);
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.mouseup, JSDOMEventProc.getAddress(), 0, 4L);
                WebKitGTK.webkit_dom_event_target_add_event_listener(l2, WebKitGTK.mousewheel, JSDOMEventProc.getAddress(), 0, 37L);
            }
            return;
        }
        if (!WEBKIT2) {
            StringBuffer stringBuffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            this.execute(stringBuffer.toString());
            stringBuffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            this.execute(stringBuffer.toString());
            if (bl) {
                stringBuffer = new StringBuffer("document.addEventListener('keydown', SWTkeyhandler, true);");
                stringBuffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
                stringBuffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
                stringBuffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
                stringBuffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
                stringBuffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
                stringBuffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
                stringBuffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
                this.execute(stringBuffer.toString());
                return;
            }
            stringBuffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
            stringBuffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            stringBuffer.append('}');
            this.execute(stringBuffer.toString());
        }
    }

    @Override
    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    @Override
    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        Boolean bl2;
        if (!this.jsEnabled) {
            return true;
        }
        String string = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String string2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String string3 = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer stringBuffer = new StringBuffer("function ");
        stringBuffer.append(string3);
        stringBuffer.append("(win) {\n");
        stringBuffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuffer.append("if (str != null) { ");
            stringBuffer.append("var result = confirm('");
            stringBuffer.append(string);
            stringBuffer.append("\\n\\n'+str+'\\n\\n");
            stringBuffer.append(string2);
            stringBuffer.append("');");
            stringBuffer.append("if (!result) return false;}");
        }
        stringBuffer.append("} catch (e) {}}");
        stringBuffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuffer.append(string3);
        stringBuffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        if (!WEBKIT2) {
            bl2 = (Boolean)this.evaluate("return " + string3 + "(window);");
            if (bl2 == null) {
                return false;
            }
        } else {
            try {
                bl2 = (Boolean)this.evaluate("return " + string3 + "(window);");
                if (bl2 == null) {
                    return true;
                }
            }
            catch (SWTException sWTException) {
                return true;
            }
        }
        return bl2;
    }

    @Override
    public boolean execute(String string) {
        long l = 0L;
        if (WEBKIT2) {
            try {
                this.evaluate(string);
            }
            catch (SWTException sWTException) {
                return false;
            }
            return true;
        }
        byte[] byArray = (string + '\u0000').getBytes(StandardCharsets.UTF_8);
        long l2 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        byte[] byArray2 = (this.getUrl() + '\u0000').getBytes(StandardCharsets.UTF_8);
        long l3 = WebKitGTK.JSStringCreateWithUTF8CString(byArray2);
        long l4 = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        long l5 = WebKitGTK.webkit_web_frame_get_global_context(l4);
        l = WebKitGTK.JSEvaluateScript(l5, l2, 0L, l3, 0, null);
        WebKitGTK.JSStringRelease(l3);
        WebKitGTK.JSStringRelease(l2);
        return l != 0L;
    }

    @Override
    public Object evaluate(String string) throws SWTException {
        if (WEBKIT2) {
            if (this.webkit_settings_get(WebKitGTK.enable_javascript) == 0) {
                return null;
            }
            boolean bl = nonBlockingEvaluate > 0;
            return Webkit2JavascriptEvaluator.evaluate(string, this.browser, this.webView, bl);
        }
        return super.evaluate(string);
    }

    @Override
    public boolean forward() {
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    @Override
    public String getBrowserType() {
        return "webkit";
    }

    @Override
    public String getText() {
        long l = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        long l2 = WebKitGTK.webkit_web_frame_get_data_source(l);
        if (l2 == 0L) {
            return "";
        }
        long l3 = WebKitGTK.webkit_web_data_source_get_data(l2);
        if (l3 == 0L) {
            return "";
        }
        long l4 = WebKitGTK.webkit_web_data_source_get_encoding(l2);
        int n = OS.strlen(l4);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l4, (long)n);
        String string = new String(Converter.mbcsToWcs(byArray));
        n = OS.GString_len(l3);
        byArray = new byte[n];
        long l5 = OS.GString_str(l3);
        C.memmove(byArray, l5, (long)n);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(Converter.mbcsToWcs(byArray));
        }
    }

    @Override
    public String getUrl() {
        long l = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (l == 0L) {
            return ABOUT_BLANK;
        }
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        String string = new String(Converter.mbcsToWcs(byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        return string;
    }

    boolean handleDOMEvent(long l, int n) {
        String string = null;
        boolean bl = false;
        switch (n) {
            case 29: {
                string = DOMEVENT_DRAGSTART;
                bl = true;
                break;
            }
            case 3: {
                string = DOMEVENT_MOUSEDOWN;
                bl = true;
                break;
            }
            case 5: {
                string = DOMEVENT_MOUSEMOVE;
                bl = true;
                break;
            }
            case 4: {
                string = DOMEVENT_MOUSEUP;
                bl = true;
                break;
            }
            case 37: {
                string = DOMEVENT_MOUSEWHEEL;
                bl = true;
                break;
            }
            case 1: {
                string = DOMEVENT_KEYDOWN;
                break;
            }
            case 2: {
                string = DOMEVENT_KEYUP;
                break;
            }
            case -1: {
                string = DOMEVENT_KEYPRESS;
            }
        }
        if (bl) {
            int n2 = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_x(l);
            int n3 = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_y(l);
            int n4 = WebKitGTK.webkit_dom_mouse_event_get_button(l) + 1;
            boolean bl2 = WebKitGTK.webkit_dom_mouse_event_get_alt_key(l) != 0;
            boolean bl3 = WebKitGTK.webkit_dom_mouse_event_get_ctrl_key(l) != 0;
            boolean bl4 = WebKitGTK.webkit_dom_mouse_event_get_shift_key(l) != 0;
            boolean bl5 = WebKitGTK.webkit_dom_mouse_event_get_meta_key(l) != 0;
            int n5 = (int)WebKitGTK.webkit_dom_ui_event_get_detail(l);
            boolean bl6 = false;
            return this.handleMouseEvent(string, n2, n3, n5, n4, bl2, bl3, bl4, bl5, bl6);
        }
        int n6 = 0;
        long l2 = OS.gtk_get_current_event();
        if (l2 != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: 
                case 9: {
                    n6 = gdkEventKey.state;
                }
            }
            OS.gdk_event_free(l2);
        }
        int n7 = (int)WebKitGTK.webkit_dom_ui_event_get_key_code(l);
        int n8 = (int)WebKitGTK.webkit_dom_ui_event_get_char_code(l);
        boolean bl7 = (n6 & 8) != 0;
        boolean bl8 = (n6 & 4) != 0;
        boolean bl9 = (n6 & 1) != 0;
        return this.handleKeyEvent(string, n7, n8, bl7, bl8, bl9, false);
    }

    boolean handleEventFromFunction(Object[] objectArray) {
        String string = (String)objectArray[0];
        if (string.equals(DOMEVENT_KEYDOWN) || string.equals(DOMEVENT_KEYPRESS) || string.equals(DOMEVENT_KEYUP)) {
            return this.handleKeyEvent(string, ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue(), (Boolean)objectArray[3], (Boolean)objectArray[4], (Boolean)objectArray[5], (Boolean)objectArray[6]);
        }
        return this.handleMouseEvent(string, ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue(), ((Double)objectArray[3]).intValue(), (objectArray[4] != null ? ((Double)objectArray[4]).intValue() : 0) + 1, (Boolean)objectArray[5], (Boolean)objectArray[6], (Boolean)objectArray[7], (Boolean)objectArray[8], (Boolean)objectArray[9]);
    }

    boolean handleKeyEvent(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string.equals(DOMEVENT_KEYDOWN)) {
            this.lastKeyCode = n = this.translateKey(n);
            switch (n) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event event = new Event();
                    event.widget = this.browser;
                    event.type = string.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    event.keyCode = n;
                    switch (n) {
                        case 8: {
                            event.character = (char)8;
                            break;
                        }
                        case 127: {
                            event.character = (char)127;
                            break;
                        }
                        case 27: {
                            event.character = (char)27;
                            break;
                        }
                        case 9: {
                            event.character = (char)9;
                        }
                    }
                    this.lastCharCode = event.character;
                    event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
                    event.stateMask &= ~n;
                    int n3 = event.stateMask;
                    if (!this.sendKeyEvent(event) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || n != 9 || (n3 & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(() -> {
                        if (this.browser.isDisposed()) {
                            return;
                        }
                        if (this.browser.getDisplay().getFocusControl() == null) {
                            int n2 = (n3 & 0x20000) != 0 ? 8 : 16;
                            this.browser.traverse(n2);
                        }
                    });
                    break;
                }
            }
            return true;
        }
        if (string.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = n2;
            if (bl2 && 0 <= this.lastCharCode && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 1;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
            return this.sendKeyEvent(event) && !this.browser.isDisposed();
        }
        if ((n = this.translateKey(n)) == 0) {
            return true;
        }
        if (n != this.lastKeyCode) {
            this.lastKeyCode = n;
            this.lastCharCode = 0;
        }
        Event event = new Event();
        event.widget = this.browser;
        event.type = 2;
        event.keyCode = this.lastKeyCode;
        event.character = (char)this.lastCharCode;
        event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
        switch (this.lastKeyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: {
                event.stateMask |= this.lastKeyCode;
            }
        }
        this.browser.notifyListeners(event.type, event);
        this.lastCharCode = 0;
        this.lastKeyCode = 0;
        return event.doit && !this.browser.isDisposed();
    }

    boolean handleMouseEvent(String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n5;
        Point point = new Point(n, n2);
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = n5 = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
        if (string.equals(DOMEVENT_MOUSEDOWN)) {
            event.type = 3;
            event.count = n3;
            event.button = n4;
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (n3 == 2) {
                event = new Event();
                event.type = 8;
                event.widget = this.browser;
                event.x = point.x;
                event.y = point.y;
                event.stateMask = n5;
                event.count = n3;
                event.button = n4;
                this.browser.notifyListeners(event.type, event);
            }
            return true;
        }
        if (string.equals(DOMEVENT_MOUSEUP)) {
            event.type = 4;
            event.count = n3;
            event.button = n4;
        } else if (string.equals(DOMEVENT_MOUSEMOVE)) {
            event.type = 5;
        } else if (string.equals(DOMEVENT_MOUSEWHEEL)) {
            event.type = 37;
            event.count = n3;
        } else if (string.equals(DOMEVENT_DRAGSTART)) {
            event.type = 29;
            event.button = n4;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
            if (!IsWebKit14orNewer) {
                this.browser.notifyListeners(event.type, event);
                return false;
            }
        }
        this.browser.notifyListeners(event.type, event);
        return true;
    }

    long handleLoadCommitted(long l, boolean bl) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        String string = new String(Converter.mbcsToWcs(byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        if (!WEBKIT2 && bl && string.startsWith(ABOUT_BLANK) && this.htmlBytes != null) {
            return 0L;
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.top = bl;
        Runnable runnable = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            for (int i = 0; i < this.locationListeners.length; ++i) {
                this.locationListeners[i].changed(locationEvent);
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
        return 0L;
    }

    private void fireNewTitleEvent(String string) {
        if (!WEBKIT2) {
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            for (int i = 0; i < this.titleListeners.length; ++i) {
                this.titleListeners[i].changed(titleEvent);
            }
        }
    }

    private void fireProgressCompletedEvent() {
        Runnable runnable = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            ProgressEvent progressEvent = new ProgressEvent(this.browser);
            progressEvent.display = this.browser.getDisplay();
            progressEvent.widget = this.browser;
            progressEvent.current = 100;
            progressEvent.total = 100;
            for (int i = 0; i < this.progressListeners.length; ++i) {
                this.progressListeners[i].completed(progressEvent);
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    long handleLoadFinished(long l, boolean bl) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        String string = new String(Converter.mbcsToWcs(byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        if (bl && this.htmlBytes != null && string.startsWith(ABOUT_BLANK)) {
            this.loadingText = true;
            byte[] byArray2 = Converter.wcsToMbcs("text/html", true);
            byte[] byArray3 = Converter.wcsToMbcs(StandardCharsets.UTF_8.displayName(), true);
            byte[] byArray4 = this.untrustedText ? Converter.wcsToMbcs(ABOUT_BLANK, true) : Converter.wcsToMbcs(URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_string(this.webView, this.htmlBytes, byArray2, byArray3, byArray4);
            this.htmlBytes = null;
        }
        if (!this.loadingText) {
            long l2;
            long l3;
            if (bl && (l3 = WebKitGTK.webkit_web_frame_get_title(l2 = WebKitGTK.webkit_web_view_get_main_frame(this.webView))) == 0L) {
                this.fireNewTitleEvent(string);
                if (this.browser.isDisposed()) {
                    return 0L;
                }
            }
            this.fireProgressCompletedEvent();
        }
        this.loadingText = false;
        return 0L;
    }

    @Override
    public boolean isBackEnabled() {
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    @Override
    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event event) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            ((BrowserFunction)iterator.next()).dispose(false);
        }
        this.functions = null;
        if (!WEBKIT2) {
            if (this.eventFunction != null) {
                this.eventFunction.dispose(false);
                this.eventFunction = null;
            }
            C.free(this.webViewData);
        }
        this.postData = null;
        this.headers = null;
        this.htmlBytes = null;
    }

    void onResize(Event event) {
        Rectangle rectangle = DPIUtil.autoScaleUp(this.browser.getClientArea());
        if (WEBKIT2) {
            OS.gtk_widget_set_size_request(this.webView, rectangle.width, rectangle.height);
        } else {
            OS.gtk_widget_set_size_request(this.scrolledWindow, rectangle.width, rectangle.height);
        }
    }

    void openDownloadWindow(final long l) {
        final Shell shell = new Shell();
        String string = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        long l2 = WebKitGTK.webkit_download_get_suggested_filename(l);
        int n = OS.strlen(l2);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        String string2 = new String(Converter.mbcsToWcs(byArray));
        long l3 = WebKitGTK.webkit_download_get_uri(l);
        n = OS.strlen(l3);
        byArray = new byte[n];
        OS.memmove(byArray, l3, (long)n);
        String string3 = new String(Converter.mbcsToWcs(byArray));
        string = Compatibility.getMessage("SWT_Download_Location", new Object[]{string2, string3});
        Label label = new Label(shell, 64);
        label.setText(string);
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n2 = monitor.getBounds().width / 2;
        int n3 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n3, n2);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        final Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        final Listener listener = event -> WebKitGTK.webkit_download_cancel(l);
        button.addListener(13, listener);
        OS.g_object_ref(l);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                int n = WebKitGTK.webkit_download_get_status(l);
                if (shell.isDisposed() || n == 3 || n == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(l);
                    return;
                }
                if (n == -1) {
                    label2.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(l);
                    button.removeListener(13, listener);
                    button.addListener(13, event -> shell.dispose());
                    return;
                }
                long l3 = WebKitGTK.webkit_download_get_current_size(l) / 1024L;
                long l2 = WebKitGTK.webkit_download_get_total_size(l) / 1024L;
                String string = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(l3), new Long(l2)});
                label2.setText(string);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    @Override
    public void refresh() {
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    @Override
    public boolean setText(String string, boolean bl) {
        byte[] byArray = (string + '\u0000').getBytes(StandardCharsets.UTF_8);
        boolean bl2 = this.htmlBytes != null;
        this.htmlBytes = byArray;
        boolean bl3 = this.untrustedText = !bl;
        if (WEBKIT2) {
            byte[] byArray2 = this.untrustedText ? Converter.wcsToMbcs(ABOUT_BLANK, true) : Converter.wcsToMbcs(URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_html(this.webView, this.htmlBytes, byArray2);
        } else {
            if (bl2) {
                return true;
            }
            byte[] byArray3 = Converter.wcsToMbcs(ABOUT_BLANK, true);
            WebKitGTK.webkit_web_view_load_uri(this.webView, byArray3);
        }
        return true;
    }

    @Override
    public boolean setUrl(String string, String string2, String[] stringArray) {
        this.postData = string2;
        this.headers = stringArray;
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = null;
            string3 = string.charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + string : PROTOCOL_HTTP + string;
            try {
                new URL(string3);
                string = string3;
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string4 = stringArray[i];
                if (string4 == null || (n = string4.indexOf(58)) == -1) continue;
                String string5 = string4.substring(0, n).trim();
                String string6 = string4.substring(n + 1).trim();
                if (string5.length() <= 0 || string6.length() <= 0 || !string5.equalsIgnoreCase(USER_AGENT)) continue;
                byte[] byArray = Converter.wcsToMbcs(string6, true);
                OS.g_object_set(l, WebKitGTK.user_agent, byArray, 0L);
            }
        }
        byte[] byArray = Converter.wcsToMbcs(string, true);
        if (WEBKIT2 && stringArray != null) {
            long l2 = WebKitGTK.webkit_uri_request_new(byArray);
            long l3 = WebKitGTK.webkit_uri_request_get_http_headers(l2);
            if (l3 != 0L) {
                this.addRequestHeaders(l3, stringArray);
            }
            WebKitGTK.webkit_web_view_load_request(this.webView, l2);
            return true;
        }
        WebKitGTK.webkit_web_view_load_uri(this.webView, byArray);
        OS.g_object_set(l, WebKitGTK.user_agent, 0, 0L);
        return true;
    }

    @Override
    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    long webframe_notify_load_status(long l, long l2) {
        int n = WebKitGTK.webkit_web_frame_get_load_status(l);
        switch (n) {
            case 1: {
                long l3 = WebKitGTK.webkit_web_frame_get_uri(l);
                return this.handleLoadCommitted(l3, false);
            }
            case 2: {
                long l4 = WebKitGTK.webkit_web_frame_get_parent(l);
                if (WebKitGTK.webkit_web_frame_get_load_status(l4) != 2) break;
                long l5 = WebKitGTK.webkit_web_frame_get_uri(l);
                return this.handleLoadFinished(l5, false);
            }
        }
        return 0L;
    }

    long webkit_close_web_view(long l) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        Runnable runnable = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            for (int i = 0; i < this.closeWindowListeners.length; ++i) {
                this.closeWindowListeners[i].close(windowEvent);
            }
            this.browser.dispose();
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
        return 0L;
    }

    long webkit_console_message(long l, long l2, long l3, long l4) {
        return 1L;
    }

    long webkit_create_web_view(long l, long l2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        Runnable runnable = () -> {
            if (this.openWindowListeners != null) {
                for (int i = 0; i < this.openWindowListeners.length; ++i) {
                    this.openWindowListeners[i].open(windowEvent);
                }
            }
        };
        if (WEBKIT2) {
            try {
                ++nonBlockingEvaluate;
                runnable.run();
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                --nonBlockingEvaluate;
            }
        } else {
            runnable.run();
        }
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            return ((WebKit)((Browser)widget).webBrowser).webView;
        }
        return 0L;
    }

    long webkit_download_requested(long l, long l2) {
        long l3 = WebKitGTK.webkit_download_get_suggested_filename(l2);
        int n = OS.strlen(l3);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l3, (long)n);
        String string = new String(Converter.mbcsToWcs(byArray));
        long l4 = WebKitGTK.webkit_download_get_network_request(l2);
        OS.g_object_ref(l4);
        this.browser.getDisplay().asyncExec(() -> {
            if (!this.browser.isDisposed()) {
                FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
                fileDialog.setFileName(string);
                String string2 = Compatibility.getMessage("SWT_FileDownload");
                fileDialog.setText(string2);
                String string3 = fileDialog.open();
                if (string3 != null) {
                    string3 = URI_FILEROOT + string3;
                    long l2 = WebKitGTK.webkit_download_new(l4);
                    byte[] byArray = Converter.wcsToMbcs(string3, true);
                    WebKitGTK.webkit_download_set_destination_uri(l2, byArray);
                    this.openDownloadWindow(l2);
                    WebKitGTK.webkit_download_start(l2);
                    OS.g_object_unref(l2);
                }
            }
            OS.g_object_unref(l4);
        });
        return 1L;
    }

    long webkit_mouse_target_changed(long l, long l2, long l3) {
        if (WebKitGTK.webkit_hit_test_result_context_is_link(l2)) {
            long l4 = WebKitGTK.webkit_hit_test_result_get_link_uri(l2);
            long l5 = WebKitGTK.webkit_hit_test_result_get_link_title(l2);
            return this.webkit_hovering_over_link(l, l5, l4);
        }
        return 0L;
    }

    long webkit_hovering_over_link(long l, long l2, long l3) {
        if (l3 != 0L) {
            int n = OS.strlen(l3);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            String string = new String(Converter.mbcsToWcs(byArray));
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            Runnable runnable = () -> {
                if (this.browser.isDisposed() || this.statusTextListeners == null) {
                    return;
                }
                for (int i = 0; i < this.statusTextListeners.length; ++i) {
                    this.statusTextListeners[i].changed(statusTextEvent);
                }
            };
            if (WEBKIT2) {
                this.browser.getDisplay().asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
        return 0L;
    }

    long webkit_mime_type_policy_decision_requested(long l, long l2, long l3, long l4, long l5) {
        boolean bl;
        boolean bl2 = bl = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, l4) != 0;
        if (!bl) {
            WebKitGTK.webkit_web_policy_decision_download(l5);
            return 1L;
        }
        return 0L;
    }

    long webkit_navigation_policy_decision_requested(long l, long l2, long l3, long l4, long l5) {
        assert (!WEBKIT2) : "Webkit1 only code was ran by webkit2";
        if (this.loadingText) {
            return 0L;
        }
        long l6 = WebKitGTK.webkit_network_request_get_uri(l3);
        int n = OS.strlen(l6);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l6, (long)n);
        String string = new String(Converter.mbcsToWcs(byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        if (this.locationListeners != null) {
            for (int i = 0; i < this.locationListeners.length; ++i) {
                this.locationListeners[i].changing(locationEvent);
            }
        }
        if (locationEvent.doit && !this.browser.isDisposed()) {
            int n2;
            long l7;
            if (this.jsEnabled != this.jsEnabledOnNextPage) {
                this.jsEnabled = this.jsEnabledOnNextPage;
                DisabledJSCount += !this.jsEnabled ? 1 : -1;
                this.webkit_settings_set(WebKitGTK.enable_scripts, this.jsEnabled ? 1 : 0);
            }
            if (l2 != (l7 = WebKitGTK.webkit_web_view_get_main_frame(this.webView)) && (n2 = OS.g_signal_handler_find(l2, 24, 0, 0, 0L, Proc3.getAddress(), 9L)) == 0) {
                OS.g_signal_connect(l2, WebKitGTK.notify_load_status, Proc3.getAddress(), 9L);
            }
        } else {
            WebKitGTK.webkit_web_policy_decision_ignore(l5);
        }
        return 0L;
    }

    long webkit_decide_policy(long l, long l2, int n, long l3) {
        assert (WEBKIT2) : "Webkit2 only code was ran by webkit1";
        switch (n) {
            case 0: {
                long l4 = WebKitGTK.webkit_navigation_policy_decision_get_request(l2);
                if (l4 == 0L) {
                    return 0L;
                }
                long l5 = WebKitGTK.webkit_uri_request_get_uri(l4);
                String string = WebKit.getString(l5);
                if (string.equals(URI_FILEROOT)) {
                    string = ABOUT_BLANK;
                } else {
                    int n2 = URI_FILEROOT.length();
                    if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                        string = ABOUT_BLANK + string.substring(n2);
                    }
                }
                LocationEvent locationEvent = new LocationEvent(this.browser);
                locationEvent.display = this.browser.getDisplay();
                locationEvent.widget = this.browser;
                locationEvent.location = string;
                locationEvent.doit = true;
                try {
                    ++nonBlockingEvaluate;
                    if (this.locationListeners != null) {
                        for (int i = 0; i < this.locationListeners.length; ++i) {
                            this.locationListeners[i].changing(locationEvent);
                        }
                    }
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    --nonBlockingEvaluate;
                }
                if (locationEvent.doit && !this.browser.isDisposed() && this.jsEnabled != this.jsEnabledOnNextPage) {
                    this.jsEnabled = this.jsEnabledOnNextPage;
                    DisabledJSCount += !this.jsEnabled ? 1 : -1;
                    this.webkit_settings_set(WebKitGTK.enable_javascript, this.jsEnabled ? 1 : 0);
                }
                if (locationEvent.doit) break;
                WebKitGTK.webkit_policy_decision_ignore(l2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                boolean bl;
                long l6 = WebKitGTK.webkit_response_policy_decision_get_response(l2);
                long l7 = WebKitGTK.webkit_uri_response_get_mime_type(l6);
                boolean bl2 = bl = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, l7) != 0;
                if (bl) break;
                WebKitGTK.webkit_policy_decision_download(l2);
                return 1L;
            }
            default: {
                return 0L;
            }
        }
        return 0L;
    }

    long webkit_notify_load_status(long l, long l2) {
        int n = WebKitGTK.webkit_web_view_get_load_status(this.webView);
        switch (n) {
            case 1: {
                long l3 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(l3, true);
            }
            case 2: {
                long l4 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadFinished(l4, true);
            }
        }
        return 0L;
    }

    long webkit_load_changed(long l, int n, long l2) {
        switch (n) {
            case 2: {
                long l3 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(l3, true);
            }
            case 3: {
                this.registerBrowserFunctions();
                this.addEventHandlers(l, true);
                long l4 = WebKitGTK.webkit_web_view_get_title(this.webView);
                if (l4 == 0L) {
                    long l5 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                    this.fireNewTitleEvent(WebKit.getString(l5));
                }
                this.fireProgressCompletedEvent();
                return 0L;
            }
        }
        return 0L;
    }

    long webkit_notify_progress(long l, long l2) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        double d = 0.0;
        d = WEBKIT2 ? WebKitGTK.webkit_web_view_get_estimated_load_progress(this.webView) : WebKitGTK.webkit_web_view_get_progress(this.webView);
        progressEvent.current = (int)(d * 100.0);
        progressEvent.total = 100;
        Runnable runnable = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            for (int i = 0; i < this.progressListeners.length; ++i) {
                this.progressListeners[i].changed(progressEvent);
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
        return 0L;
    }

    long webkit_notify_title(long l, long l2) {
        Object object;
        String string;
        long l3 = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (l3 == 0L) {
            string = "";
        } else {
            int n = OS.strlen(l3);
            object = new byte[n];
            OS.memmove((byte[])object, l3, (long)n);
            string = new String(Converter.mbcsToWcs((byte[])object));
        }
        TitleEvent titleEvent = new TitleEvent(this.browser);
        titleEvent.display = this.browser.getDisplay();
        titleEvent.widget = this.browser;
        titleEvent.title = string;
        object = () -> {
            for (int i = 0; i < this.titleListeners.length; ++i) {
                this.titleListeners[i].changed(titleEvent);
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec((Runnable)object);
        } else {
            object.run();
        }
        return 0L;
    }

    long webkit_context_menu(long l, long l2, long l3, long l4) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            return 1L;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (point.x != event.x || point.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 1L;
        }
        return 0L;
    }

    long webkit_populate_popup(long l, long l2) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            long l3;
            long l4 = l3 = OS.gtk_container_get_children(l2);
            while (l4 != 0L) {
                long l5 = OS.g_list_data(l4);
                OS.gtk_container_remove(l2, l5);
                l4 = OS.g_list_next(l4);
            }
            OS.g_list_free(l3);
            return 0L;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            long l6;
            if (point.x != event.x || point.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            long l7 = l6 = OS.gtk_container_get_children(l2);
            while (l7 != 0L) {
                long l8 = OS.g_list_data(l7);
                OS.gtk_container_remove(l2, l8);
                l7 = OS.g_list_next(l7);
            }
            OS.g_list_free(l6);
        }
        return 0L;
    }

    private void addRequestHeaders(long l, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (string == null || (n = string.indexOf(58)) == -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            if (string2.length() <= 0 || string3.length() <= 0) continue;
            byte[] byArray = Converter.wcsToMbcs(string2, true);
            byte[] byArray2 = Converter.wcsToMbcs(string3, true);
            WebKitGTK.soup_message_headers_append(l, byArray, byArray2);
        }
    }

    long webkit_resource_request_starting(long l, long l2, long l3, long l4, long l5) {
        if (this.postData != null || this.headers != null) {
            long l6 = WebKitGTK.webkit_network_request_get_message(l4);
            if (l6 == 0L) {
                this.headers = null;
                this.postData = null;
            } else {
                long l7;
                if (this.postData != null) {
                    WebKitGTK.SoupMessage_method(l6, PostString);
                    l7 = WebKitGTK.SoupMessage_request_body(l6);
                    byte[] byArray = Converter.wcsToMbcs(this.postData, false);
                    long l8 = C.malloc(byArray.length);
                    C.memmove(l8, byArray, (long)byArray.length);
                    WebKitGTK.soup_message_body_append(l7, 1, l8, byArray.length);
                    WebKitGTK.soup_message_body_flatten(l7);
                    if (this.headers == null) {
                        this.headers = new String[0];
                    }
                    boolean bl = false;
                    for (int i = 0; i < this.headers.length; ++i) {
                        String string;
                        int n = this.headers[i].indexOf(58);
                        if (n == -1 || !(string = this.headers[i].substring(0, n).trim().toLowerCase()).equals(HEADER_CONTENTTYPE)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        String[] stringArray = new String[this.headers.length + 1];
                        System.arraycopy(this.headers, 0, stringArray, 0, this.headers.length);
                        stringArray[this.headers.length] = "content-type:application/x-www-form-urlencoded";
                        this.headers = stringArray;
                    }
                    this.postData = null;
                }
                l7 = WebKitGTK.SoupMessage_request_headers(l6);
                this.addRequestHeaders(l7, this.headers);
                this.headers = null;
            }
        }
        return 0L;
    }

    long webkit_status_bar_text_changed(long l, long l2) {
        int n = OS.strlen(l2);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = new String(Converter.mbcsToWcs(byArray));
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            this.statusTextListeners[i].changed(statusTextEvent);
        }
        return 0L;
    }

    long webkit_web_view_ready(long l) {
        long l2;
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (!WEBKIT2) {
            l2 = WebKitGTK.webkit_web_view_get_window_features(this.webView);
            windowEvent.addressBar = this.webkit_settings_get(l2, WebKitGTK.locationbar_visible) != 0;
            windowEvent.menuBar = this.webkit_settings_get(l2, WebKitGTK.menubar_visible) != 0;
            windowEvent.statusBar = this.webkit_settings_get(l2, WebKitGTK.statusbar_visible) != 0;
            windowEvent.addressBar = this.webkit_settings_get(l2, WebKitGTK.toolbar_visible) != 0;
            int n = this.webkit_settings_get(l2, WebKitGTK.x);
            int n2 = this.webkit_settings_get(l2, WebKitGTK.y);
            int n3 = this.webkit_settings_get(l2, WebKitGTK.width);
            int n4 = this.webkit_settings_get(l2, WebKitGTK.height);
            if (n != -1 && n2 != -1) {
                windowEvent.location = new Point(n, n2);
            }
            if (n3 != -1 && n4 != -1) {
                windowEvent.size = new Point(n3, n4);
            }
        } else {
            l2 = WebKitGTK.webkit_web_view_get_window_properties(this.webView);
            windowEvent.addressBar = this.webkit_settings_get(l2, WebKitGTK.locationbar_visible) != 0;
            windowEvent.menuBar = this.webkit_settings_get(l2, WebKitGTK.menubar_visible) != 0;
            windowEvent.statusBar = this.webkit_settings_get(l2, WebKitGTK.statusbar_visible) != 0;
            windowEvent.toolBar = this.webkit_settings_get(l2, WebKitGTK.toolbar_visible) != 0;
            GdkRectangle gdkRectangle = new GdkRectangle();
            WebKitGTK.webkit_window_properties_get_geometry(l2, gdkRectangle);
            windowEvent.location = new Point(Math.max(0, gdkRectangle.x), Math.max(0, gdkRectangle.y));
            int n = gdkRectangle.width;
            int n5 = gdkRectangle.height;
            if (n5 == 100 && n == 100) {
                Rectangle rectangle = this.browser.getDisplay().getPrimaryMonitor().getBounds();
                n5 = (int)((double)rectangle.height * 0.66);
                n = (int)((double)rectangle.width * 0.66);
            }
            windowEvent.size = new Point(n, n5);
        }
        Runnable runnable = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            for (int i = 0; i < this.visibilityWindowListeners.length; ++i) {
                this.visibilityWindowListeners[i].show(windowEvent);
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
        return 0L;
    }

    long webkit_window_object_cleared(long l, long l2, long l3, long l4) {
        long l5 = WebKitGTK.JSContextGetGlobalObject(l3);
        long l6 = WebKitGTK.JSObjectMake(l3, ExternalClass, this.webViewData);
        byte[] byArray = "external\u0000".getBytes(StandardCharsets.UTF_8);
        long l7 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        WebKitGTK.JSObjectSetProperty(l3, l5, l7, l6, 0, null);
        WebKitGTK.JSStringRelease(l7);
        this.registerBrowserFunctions();
        long l8 = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        boolean bl = l8 == l2;
        this.addEventHandlers(l, bl);
        return 0L;
    }

    private int webkit_settings_get(byte[] byArray) {
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        return this.webkit_settings_get(l, byArray);
    }

    private int webkit_settings_get(long l, byte[] byArray) {
        int[] nArray = new int[1];
        OS.g_object_get(l, byArray, nArray, 0L);
        return nArray[0];
    }

    private void webkit_settings_set(byte[] byArray, int n) {
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(l, byArray, n, 0L);
    }

    private void registerBrowserFunctions() {
        for (BrowserFunction browserFunction : this.functions.values()) {
            this.execute(browserFunction.functionString);
        }
    }

    long callJava(long l, long l2, long l3, long l4, long l5, long l6) {
        Object object = null;
        if (l4 == 3L) {
            long[] lArray = new long[1];
            C.memmove(lArray, l5, (long)C.PTR_SIZEOF);
            int n = WebKitGTK.JSValueGetType(l, lArray[0]);
            if (n == 3) {
                int n2 = ((Double)WebKit.convertToJava(l, lArray[0])).intValue();
                lArray[0] = 0L;
                Integer n3 = new Integer(n2);
                C.memmove(lArray, l5 + (long)C.PTR_SIZEOF, (long)C.PTR_SIZEOF);
                n = WebKitGTK.JSValueGetType(l, lArray[0]);
                if (n == 4) {
                    String string = (String)WebKit.convertToJava(l, lArray[0]);
                    BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n3);
                    if (browserFunction != null && string.equals(browserFunction.token)) {
                        try {
                            C.memmove(lArray, l5 + (long)(2 * C.PTR_SIZEOF), (long)C.PTR_SIZEOF);
                            Object object2 = WebKit.convertToJava(l, lArray[0]);
                            if (object2 instanceof Object[]) {
                                Object[] objectArray = (Object[])object2;
                                try {
                                    object = browserFunction.function(objectArray);
                                }
                                catch (Exception exception) {
                                    object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                                }
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (browserFunction.isEvaluate) {
                                browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                            }
                            object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        return this.convertToJS(l, object);
    }

    long convertToJS(long l, Object object) {
        if (object == null) {
            return WebKitGTK.JSValueMakeUndefined(l);
        }
        if (object instanceof String) {
            byte[] byArray = ((String)object + '\u0000').getBytes(StandardCharsets.UTF_8);
            long l2 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
            long l3 = WebKitGTK.JSValueMakeString(l, l2);
            WebKitGTK.JSStringRelease(l2);
            return l3;
        }
        if (object instanceof Boolean) {
            return WebKitGTK.JSValueMakeBoolean(l, (Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Number) {
            return WebKitGTK.JSValueMakeNumber(l, ((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                long l4;
                Object object2 = objectArray[i];
                lArray[i] = l4 = this.convertToJS(l, object2);
            }
            return WebKitGTK.JSObjectMakeArray(l, n, lArray, null);
        }
        SWT.error(51);
        return 0L;
    }

    static Object convertToJava(long l, long l2) {
        int n = WebKitGTK.JSValueGetType(l, l2);
        switch (n) {
            case 2: {
                int n2 = (int)WebKitGTK.JSValueToNumber(l, l2, null);
                return new Boolean(n2 != 0);
            }
            case 3: {
                double d = WebKitGTK.JSValueToNumber(l, l2, null);
                return new Double(d);
            }
            case 4: {
                long l3 = WebKitGTK.JSValueToStringCopy(l, l2, null);
                if (l3 == 0L) {
                    return "";
                }
                long l4 = WebKitGTK.JSStringGetMaximumUTF8CStringSize(l3);
                byte[] byArray = new byte[(int)l4];
                l4 = WebKitGTK.JSStringGetUTF8CString(l3, byArray, l4);
                WebKitGTK.JSStringRelease(l3);
                return new String(byArray, 0, (int)l4 - 1, StandardCharsets.UTF_8);
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] byArray = "length\u0000".getBytes(StandardCharsets.UTF_8);
                long l5 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
                long l6 = WebKitGTK.JSObjectGetProperty(l, l2, l5, null);
                WebKitGTK.JSStringRelease(l5);
                n = WebKitGTK.JSValueGetType(l, l6);
                if (n != 3) break;
                int n3 = (int)WebKitGTK.JSValueToNumber(l, l6, null);
                Object[] objectArray = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    long l7 = WebKitGTK.JSObjectGetPropertyAtIndex(l, l2, i, null);
                    if (l7 == 0L) continue;
                    objectArray[i] = WebKit.convertToJava(l, l7);
                }
                return objectArray;
            }
        }
        SWT.error(5);
        return null;
    }

    static {
        WindowMappings = new HashMap<LONG, LONG>();
        MIN_VERSION = new int[]{1, 2, 0};
        SEPARATOR_FILE = System.getProperty("file.separator").charAt(0);
        try {
            Library.loadLibrary("swt-webkit");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (LibraryLoaded) {
            String string = System.getenv("SWT_WEBKIT2");
            int n = WebKitGTK.webkit_get_major_version();
            if (n != 0) {
                string = "1";
            }
            WEBKIT2 = string != null && string.equals("1") && OS.GTK3;
            WebViewType = WebKitGTK.webkit_web_view_get_type();
            Proc2 = new Callback(WebKit.class, "Proc", 2);
            if (Proc2.getAddress() == 0L) {
                SWT.error(3);
            }
            if ((Proc3 = new Callback(WebKit.class, "Proc", 3)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((Proc4 = new Callback(WebKit.class, "Proc", 4)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((Proc5 = new Callback(WebKit.class, "Proc", 5)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((Proc6 = new Callback(WebKit.class, "Proc", 6)).getAddress() == 0L) {
                SWT.error(3);
            }
            if (WEBKIT2) {
                new Webkit2JavascriptEvaluator();
            }
            if (WEBKIT2) {
                new Webkit2JavaCallback();
            } else {
                JSObjectHasPropertyProc = new Callback(WebKit.class, "JSObjectHasPropertyProc", 3);
                if (JSObjectHasPropertyProc.getAddress() == 0L) {
                    SWT.error(3);
                }
                if ((JSObjectGetPropertyProc = new Callback(WebKit.class, "JSObjectGetPropertyProc", 4)).getAddress() == 0L) {
                    SWT.error(3);
                }
                if ((JSObjectCallAsFunctionProc = new Callback(WebKit.class, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0L) {
                    SWT.error(3);
                }
            }
            JSDOMEventProc = new Callback(WebKit.class, "JSDOMEventProc", 3);
            if (JSDOMEventProc.getAddress() == 0L) {
                SWT.error(3);
            }
            NativeClearSessions = () -> {
                long l;
                if (!LibraryLoaded) {
                    return;
                }
                long l2 = WebKitGTK.webkit_get_default_session();
                long l3 = WebKitGTK.soup_session_get_feature(l2, l = WebKitGTK.soup_cookie_jar_get_type());
                if (l3 == 0L) {
                    return;
                }
                long l4 = WebKitGTK.soup_cookie_jar_all_cookies(l3);
                int n = OS.g_slist_length(l4);
                long l5 = l4;
                for (int i = 0; i < n; ++i) {
                    long l6 = OS.g_slist_data(l5);
                    long l7 = WebKitGTK.SoupCookie_expires(l6);
                    if (l7 == 0L) {
                        WebKitGTK.soup_cookie_jar_delete_cookie(l3, l6);
                    }
                    WebKitGTK.soup_cookie_free(l6);
                    l5 = OS.g_slist_next(l5);
                }
                OS.g_slist_free(l4);
            };
            NativeGetCookie = () -> {
                long l;
                if (!LibraryLoaded) {
                    return;
                }
                long l2 = WebKitGTK.webkit_get_default_session();
                long l3 = WebKitGTK.soup_session_get_feature(l2, l = WebKitGTK.soup_cookie_jar_get_type());
                if (l3 == 0L) {
                    return;
                }
                byte[] byArray = Converter.wcsToMbcs(CookieUrl, true);
                long l4 = WebKitGTK.soup_uri_new(byArray);
                if (l4 == 0L) {
                    return;
                }
                long l5 = WebKitGTK.soup_cookie_jar_get_cookies(l3, l4, 0);
                WebKitGTK.soup_uri_free(l4);
                if (l5 == 0L) {
                    return;
                }
                int n = OS.strlen(l5);
                byArray = new byte[n];
                C.memmove(byArray, l5, (long)n);
                OS.g_free(l5);
                String string = new String(Converter.mbcsToWcs(byArray));
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2;
                    String string3 = stringTokenizer.nextToken();
                    int n2 = string3.indexOf(61);
                    if (n2 == -1 || !(string2 = string3.substring(0, n2).trim()).equals(CookieName)) continue;
                    CookieValue = string3.substring(n2 + 1).trim();
                    return;
                }
            };
            NativeSetCookie = () -> {
                long l;
                if (!LibraryLoaded) {
                    return;
                }
                long l2 = WebKitGTK.webkit_get_default_session();
                long l3 = WebKitGTK.soup_session_get_feature(l2, l = WebKitGTK.soup_cookie_jar_get_type());
                if (l3 == 0L) {
                    WebKitGTK.soup_session_add_feature_by_type(l2, l);
                    l3 = WebKitGTK.soup_session_get_feature(l2, l);
                }
                if (l3 == 0L) {
                    return;
                }
                byte[] byArray = Converter.wcsToMbcs(CookieUrl, true);
                long l4 = WebKitGTK.soup_uri_new(byArray);
                if (l4 == 0L) {
                    return;
                }
                byArray = Converter.wcsToMbcs(CookieValue, true);
                long l5 = WebKitGTK.soup_cookie_parse(byArray, l4);
                if (l5 != 0L) {
                    WebKitGTK.soup_cookie_jar_add_cookie(l3, l5);
                    CookieResult = true;
                }
                WebKitGTK.soup_uri_free(l4);
            };
            if (NativePendingCookies != null) {
                WebKit.SetPendingCookies(NativePendingCookies);
                NativePendingCookies = null;
            }
        }
    }

    private static class Webkit2JavascriptEvaluator {
        private static Callback callback = new Callback(Webkit2JavascriptEvaluator.class, "javascriptExecutionFinishedProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});

        private Webkit2JavascriptEvaluator() {
        }

        static Object evaluate(String string, Browser browser, long l, boolean bl) {
            String string2 = string.length() > 7 && string.substring(0, 7).equals("return ") ? string.substring(7) : string;
            if (bl) {
                WebKitGTK.webkit_web_view_run_javascript(l, Converter.wcsToMbcs(string2, true), 0L, 0L, 0L);
                return null;
            }
            Webkit2EvalReturnObj webkit2EvalReturnObj = new Webkit2EvalReturnObj();
            int n = CallBackMap.putObject(webkit2EvalReturnObj);
            WebKitGTK.webkit_web_view_run_javascript(l, Converter.wcsToMbcs(string2, true), 0L, callback.getAddress(), n);
            Shell shell = browser.getShell();
            Display display = browser.getDisplay();
            while (!shell.isDisposed()) {
                boolean bl2 = OS.g_main_context_iteration(0L, false);
                if (webkit2EvalReturnObj.callbackFinished) break;
                if (bl2) continue;
                display.sleep();
            }
            CallBackMap.removeObject(n);
            if (webkit2EvalReturnObj.errorNum != 0) {
                throw new SWTException(webkit2EvalReturnObj.errorNum, webkit2EvalReturnObj.errorMsg);
            }
            return webkit2EvalReturnObj.returnValue;
        }

        private static void javascriptExecutionFinishedProc(long l, long l2, long l3) {
            int n = (int)l3;
            Webkit2EvalReturnObj webkit2EvalReturnObj = CallBackMap.getObj(n);
            long[] lArray = new long[1];
            long l4 = WebKitGTK.webkit_web_view_run_javascript_finish(l, l2, lArray);
            if (l4 == 0L) {
                long l5 = OS.g_error_get_message(lArray[0]);
                String string = Converter.cCharPtrToJavaString(l5, false);
                OS.g_error_free(lArray[0]);
                webkit2EvalReturnObj.errorNum = 50;
                webkit2EvalReturnObj.errorMsg = string != null ? string : "";
            } else {
                long l6 = WebKitGTK.webkit_javascript_result_get_global_context(l4);
                long l7 = WebKitGTK.webkit_javascript_result_get_value(l4);
                try {
                    webkit2EvalReturnObj.returnValue = WebKit.convertToJava(l6, l7);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    webkit2EvalReturnObj.errorNum = 51;
                    webkit2EvalReturnObj.errorMsg = "Type of return value not is not valid. For supported types see: Browser.evaluate() JavaDoc";
                }
                WebKitGTK.webkit_javascript_result_unref(l4);
            }
            webkit2EvalReturnObj.callbackFinished = true;
            Display.getCurrent().wake();
        }

        static {
            if (callback.getAddress() == 0L) {
                SWT.error(3);
            }
        }

        private static class CallBackMap {
            private static HashMap<Integer, Webkit2EvalReturnObj> callbackMap = new HashMap();
            private static int nextCallbackId = 1;
            private static HashSet<Integer> usedCallbackIds = new HashSet();

            private CallBackMap() {
            }

            static int putObject(Webkit2EvalReturnObj webkit2EvalReturnObj) {
                int n = CallBackMap.getNextId();
                callbackMap.put(n, webkit2EvalReturnObj);
                return n;
            }

            static Webkit2EvalReturnObj getObj(int n) {
                return callbackMap.get(n);
            }

            static void removeObject(int n) {
                callbackMap.remove(n);
                CallBackMap.removeId(n);
            }

            private static int getNextId() {
                int n = 0;
                boolean bl = false;
                while (!bl) {
                    n = nextCallbackId;
                    boolean bl2 = bl = !usedCallbackIds.contains(n);
                    if (nextCallbackId != Integer.MAX_VALUE) {
                        ++nextCallbackId;
                        continue;
                    }
                    nextCallbackId = 1;
                }
                usedCallbackIds.add(n);
                return n;
            }

            private static void removeId(int n) {
                usedCallbackIds.remove(n);
            }
        }

        private static class Webkit2EvalReturnObj {
            boolean callbackFinished = false;
            Object returnValue;
            int errorNum = 0;
            String errorMsg;

            private Webkit2EvalReturnObj() {
            }
        }
    }

    static class Webkit2JavaCallback {
        private static final String JavaScriptFunctionName = "webkit2JavaCallProc";
        private static final String Signal = "script-message-received::webkit2JavaCallProc";
        static final String JavaScriptFunctionDeclaration = "if (!window.callJava) {\n\t\twindow.callJava = function callJava(index, token, args) {\n         window.webkit.messageHandlers.webkit2JavaCallProc.postMessage([index,token, args]);\n\t\t}\n};\n";
        private static Callback callback = new Callback(Webkit2JavaCallback.class, "webkit2JavaCallProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});

        Webkit2JavaCallback() {
        }

        private static void webkit2JavaCallProc(long l, long l2, long l3) {
            try {
                long l4 = WebKitGTK.webkit_javascript_result_get_global_context(l2);
                long l5 = WebKitGTK.webkit_javascript_result_get_value(l2);
                Object[] objectArray = (Object[])WebKit.convertToJava(l4, l5);
                if (objectArray.length != 3) {
                    throw new IllegalArgumentException("Expected 3 args. Received: " + objectArray.length);
                }
                Double d = (Double)objectArray[0];
                String string = (String)objectArray[1];
                Browser browser = WebKit.FindBrowser(l3);
                if (browser == null) {
                    throw new NullPointerException("Could not find assosiated browser instance for handle: " + l3);
                }
                BrowserFunction browserFunction = browser.webBrowser.functions.get(d.intValue());
                if (browserFunction == null) {
                    throw new NullPointerException("Could not find function with index: " + d);
                }
                if (!string.equals(browserFunction.token)) {
                    throw new IllegalStateException("Function token missmatch. Expected:" + browserFunction.token + " actual:" + string);
                }
                if (!(objectArray[2] instanceof Object[])) {
                    throw new IllegalArgumentException("Javascript did not provide any arguments. An empty callback [like call()] should still provide an empty array");
                }
                try {
                    browserFunction.function((Object[])objectArray[2]);
                }
                catch (Exception exception) {}
            }
            catch (RuntimeException runtimeException) {
                System.err.println("\nSWT Webkit2 internal error: Javascript callback from Webkit to Java encountered an error while processing the callback:");
                System.err.println("Please report this via: https://bugs.eclipse.org/bugs/enter_bug.cgi?alias=&assigned_to=platform-swt-inbox%40eclipse.org&attach_text=&blocked=&bug_file_loc=http%3A%2F%2F&bug_severity=normal&bug_status=NEW&comment=&component=SWT&contenttypeentry=&contenttypemethod=autodetect&contenttypeselection=text%2Fplain&data=&defined_groups=1&dependson=&description=&flag_type-1=X&flag_type-11=X&flag_type-12=X&flag_type-13=X&flag_type-14=X&flag_type-15=X&flag_type-16=X&flag_type-2=X&flag_type-4=X&flag_type-6=X&flag_type-7=X&flag_type-8=X&form_name=enter_bug&keywords=&maketemplate=Remember%20values%20as%20bookmarkable%20template&op_sys=Linux&product=Platform&qa_contact=&rep_platform=PC&requestee_type-1=&requestee_type-2=&short_desc=&version=4.7");
                runtimeException.printStackTrace();
            }
        }

        static void connectSignal(long l, long l2) {
            OS.g_signal_connect(l, Converter.wcsToMbcs(Signal, true), callback.getAddress(), l2);
            WebKitGTK.webkit_user_content_manager_register_script_message_handler(l, Converter.wcsToMbcs(JavaScriptFunctionName, true));
        }

        static {
            if (callback.getAddress() == 0L) {
                SWT.error(3);
            }
        }
    }
}

