/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public final class Cursor
extends Resource {
    public long handle;
    static final byte[] APPSTARTING_SRC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 12, 0, 0, 0, 28, 0, 0, 0, 60, 0, 0, 0, 124, 0, 0, 0, -4, 0, 0, 0, -4, 1, 0, 0, -4, 59, 0, 0, 124, 56, 0, 0, 108, 84, 0, 0, -60, -36, 0, 0, -64, 68, 0, 0, -128, 57, 0, 0, -128, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] APPSTARTING_MASK = new byte[]{0, 0, 0, 0, 6, 0, 0, 0, 14, 0, 0, 0, 30, 0, 0, 0, 62, 0, 0, 0, 126, 0, 0, 0, -2, 0, 0, 0, -2, 1, 0, 0, -2, 59, 0, 0, -2, 127, 0, 0, -2, 127, 0, 0, -2, -2, 0, 0, -18, -1, 1, 0, -28, -1, 0, 0, -64, 127, 0, 0, -64, 127, 0, 0, -128, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int n) {
        super(device);
        int n2 = 0;
        byte[] byArray = null;
        switch (n) {
            case 3: {
                byArray = Converter.wcsToMbcs("progress", true);
                break;
            }
            case 0: {
                n2 = 68;
                break;
            }
            case 1: {
                n2 = 150;
                break;
            }
            case 2: {
                n2 = 30;
                break;
            }
            case 21: {
                n2 = 60;
                break;
            }
            case 4: {
                n2 = 92;
                break;
            }
            case 5: {
                n2 = 52;
                break;
            }
            case 6: {
                n2 = 120;
                break;
            }
            case 7: {
                n2 = 42;
                break;
            }
            case 8: {
                n2 = 120;
                break;
            }
            case 9: {
                n2 = 108;
                break;
            }
            case 10: {
                n2 = 138;
                break;
            }
            case 11: {
                n2 = 16;
                break;
            }
            case 12: {
                n2 = 96;
                break;
            }
            case 13: {
                n2 = 70;
                break;
            }
            case 14: {
                n2 = 136;
                break;
            }
            case 15: {
                n2 = 14;
                break;
            }
            case 16: {
                n2 = 12;
                break;
            }
            case 17: {
                n2 = 134;
                break;
            }
            case 18: {
                n2 = 114;
                break;
            }
            case 19: {
                n2 = 152;
                break;
            }
            case 20: {
                n2 = 0;
                byArray = Converter.wcsToMbcs("not-allowed", true);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (byArray != null) {
            this.handle = OS.gdk_cursor_new_from_name(OS.gdk_display_get_default(), byArray);
        }
        if (this.handle == 0L) {
            if (n2 == 0 && n == 3) {
                byte[] byArray2 = new byte[APPSTARTING_SRC.length];
                System.arraycopy(APPSTARTING_SRC, 0, byArray2, 0, byArray2.length);
                byte[] byArray3 = new byte[APPSTARTING_MASK.length];
                System.arraycopy(APPSTARTING_MASK, 0, byArray3, 0, byArray3.length);
                this.handle = this.createCursor(byArray2, byArray3, 32, 32, 2, 2, true);
            } else {
                this.handle = OS.gdk_cursor_new_for_display(OS.gdk_display_get_default(), n2);
            }
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n, int n2) {
        super(device);
        byte by;
        int n3;
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        imageData = ImageData.convertMask(imageData);
        imageData2 = ImageData.convertMask(imageData2);
        byte[] byArray = new byte[imageData.data.length];
        byte[] byArray2 = new byte[imageData2.data.length];
        byte[] byArray3 = imageData.data;
        for (n3 = 0; n3 < byArray3.length; ++n3) {
            by = byArray3[n3];
            byArray[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray[n3] = ~byArray[n3];
        }
        byArray = ImageData.convertPad(byArray, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 1);
        byArray3 = imageData2.data;
        for (n3 = 0; n3 < byArray3.length; ++n3) {
            by = byArray3[n3];
            byArray2[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray2[n3] = ~byArray2[n3];
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        this.handle = this.createCursor(byArray2, byArray, imageData.width, imageData.height, n, n2, true);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData object, int n, int n2) {
        super(device);
        if (object == null) {
            SWT.error(4);
        }
        if (n >= ((ImageData)object).width || n < 0 || n2 >= ((ImageData)object).height || n2 < 0) {
            SWT.error(5);
        }
        long l = 0L;
        l = OS.gdk_display_get_default();
        if (OS.gdk_display_supports_cursor_color(l)) {
            int n3 = ((ImageData)object).width;
            int n4 = ((ImageData)object).height;
            PaletteData paletteData = ((ImageData)object).palette;
            long l2 = OS.gdk_pixbuf_new(0, true, 8, n3, n4);
            if (l2 == 0L) {
                SWT.error(2);
            }
            int n5 = OS.gdk_pixbuf_get_rowstride(l2);
            long l3 = OS.gdk_pixbuf_get_pixels(l2);
            byte[] byArray = ((ImageData)object).data;
            if (!paletteData.isDirect || ((ImageData)object).depth != 24 || n5 != ((ImageData)object).bytesPerLine || paletteData.redMask != -16777216 || paletteData.greenMask != 0xFF0000 || paletteData.blueMask != 65280) {
                int n6;
                int n7;
                Object object2;
                byArray = new byte[((ImageData)object).width * ((ImageData)object).height * 4];
                if (paletteData.isDirect) {
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 32, ((ImageData)object).width * 4, 1, 0, 0, ((ImageData)object).width, ((ImageData)object).height, -16777216, 0xFF0000, 65280, false, false);
                } else {
                    object2 = paletteData.getRGBs();
                    n7 = ((RGB[])object2).length;
                    byte[] byArray2 = new byte[n7];
                    byte[] byArray3 = new byte[n7];
                    byte[] byArray4 = new byte[n7];
                    for (n6 = 0; n6 < ((RGB[])object2).length; ++n6) {
                        RGB rGB = object2[n6];
                        if (rGB == null) continue;
                        byArray2[n6] = (byte)rGB.red;
                        byArray3[n6] = (byte)rGB.green;
                        byArray4[n6] = (byte)rGB.blue;
                    }
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, 32, ((ImageData)object).width * 4, 1, 0, 0, ((ImageData)object).width, ((ImageData)object).height, -16777216, 0xFF0000, 65280, false, false);
                }
                if (((ImageData)object).maskData != null || ((ImageData)object).transparentPixel != -1) {
                    object2 = ((ImageData)object).getTransparencyMask();
                    byte[] byArray5 = object2.data;
                    int n8 = object2.bytesPerLine;
                    int n9 = 3;
                    int n10 = 0;
                    for (n6 = 0; n6 < ((ImageData)object).height; ++n6) {
                        for (int i = 0; i < ((ImageData)object).width; ++i) {
                            byArray[n9] = (byArray5[n10 + (i >> 3)] & 1 << 7 - (i & 7)) != 0 ? -1 : 0;
                            n9 += 4;
                        }
                        n10 += n8;
                    }
                } else if (((ImageData)object).alpha != -1) {
                    byte by = (byte)((ImageData)object).alpha;
                    for (n7 = 3; n7 < byArray.length; n7 += 4) {
                        byArray[n7] = by;
                    }
                } else if (((ImageData)object).alphaData != null) {
                    object2 = ((ImageData)object).alphaData;
                    for (n7 = 3; n7 < byArray.length; n7 += 4) {
                        byArray[n7] = (byte)object2[n7 / 4];
                    }
                }
            }
            OS.memmove(l3, byArray, (long)(n5 * n4));
            this.handle = OS.gdk_cursor_new_from_pixbuf(l, l2, n, n2);
            OS.g_object_unref(l2);
        } else {
            int n11;
            byte[] byArray;
            byte[] byArray6;
            Object object3;
            ImageData imageData = ((ImageData)object).getTransparencyMask();
            if (((ImageData)object).depth > 1) {
                object3 = new ImageData(((ImageData)object).width, ((ImageData)object).height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, 0, 0, 0, 0, 0);
                byArray6 = new byte[]{0, -1};
                byArray = byArray6;
                byte[] byArray7 = byArray6;
                PaletteData paletteData = ((ImageData)object).palette;
                if (paletteData.isDirect) {
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object3).getByteOrder(), 0, 0, ((ImageData)object3).width, ((ImageData)object3).height, byArray6, byArray, byArray7, false, false);
                } else {
                    RGB[] rGBArray = paletteData.getRGBs();
                    int n12 = rGBArray.length;
                    byte[] byArray8 = new byte[n12];
                    byte[] byArray9 = new byte[n12];
                    byte[] byArray10 = new byte[n12];
                    for (int i = 0; i < rGBArray.length; ++i) {
                        RGB rGB = rGBArray[i];
                        if (rGB == null) continue;
                        byArray8[i] = (byte)rGB.red;
                        byArray9[i] = (byte)rGB.green;
                        byArray10[i] = (byte)rGB.blue;
                    }
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, byArray8, byArray9, byArray10, 255, null, 0, 0, 0, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object3).getByteOrder(), 0, 0, ((ImageData)object3).width, ((ImageData)object3).height, byArray6, byArray, byArray7, false, false);
                }
                object = object3;
            }
            object3 = new byte[((ImageData)object).data.length];
            byArray6 = new byte[imageData.data.length];
            byArray = ((ImageData)object).data;
            for (n11 = 0; n11 < byArray.length; ++n11) {
                byte by = byArray[n11];
                object3[n11] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            }
            object3 = ImageData.convertPad((byte[])object3, ((ImageData)object).width, ((ImageData)object).height, ((ImageData)object).depth, ((ImageData)object).scanlinePad, 1);
            byArray = imageData.data;
            for (n11 = 0; n11 < byArray.length; ++n11) {
                byte by = byArray[n11];
                byArray6[n11] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            }
            byArray6 = ImageData.convertPad(byArray6, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 1);
            this.handle = this.createCursor((byte[])object3, byArray6, ((ImageData)object).width, ((ImageData)object).height, n, n2, false);
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    long createCursor(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, boolean bl) {
        if (OS.GTK3) {
            int n5;
            byte by;
            int n6;
            for (n6 = 0; n6 < byArray.length; ++n6) {
                by = byArray[n6];
                byArray[n6] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
                byArray[n6] = ~byArray[n6];
            }
            for (n6 = 0; n6 < byArray2.length; ++n6) {
                by = byArray2[n6];
                byArray2[n6] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
                byArray2[n6] = ~byArray2[n6];
            }
            PaletteData paletteData = new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255));
            ImageData imageData = new ImageData(n, n2, 1, paletteData, 1, byArray);
            ImageData imageData2 = new ImageData(n, n2, 1, paletteData, 1, byArray2);
            byte[] byArray3 = new byte[imageData.width * imageData.height * 4];
            for (int i = 0; i < imageData.height; ++i) {
                int n7 = i * imageData.width * 4;
                for (n5 = 0; n5 < imageData.width; ++n5) {
                    int n8 = imageData.getPixel(n5, i);
                    int n9 = imageData2.getPixel(n5, i);
                    if (n8 == 0 && n9 == 0) {
                        byArray3[n7 + 3] = -1;
                    } else if (n8 == 0 && n9 == 1) {
                        byArray3[n7 + 3] = -1;
                        byArray3[n7 + 2] = -1;
                        byArray3[n7 + 1] = -1;
                        byArray3[n7] = -1;
                    } else if (n8 != 1 || n9 == 0) {
                        // empty if block
                    }
                    n7 += 4;
                }
            }
            long l = OS.gdk_pixbuf_new(0, true, 8, n, n2);
            if (l == 0L) {
                SWT.error(2);
            }
            n5 = OS.gdk_pixbuf_get_rowstride(l);
            long l2 = OS.gdk_pixbuf_get_pixels(l);
            OS.memmove(l2, byArray3, (long)(n5 * n2));
            long l3 = OS.gdk_cursor_new_from_pixbuf(OS.gdk_display_get_default(), l, n3, n4);
            OS.g_object_unref(l);
            return l3;
        }
        long l = OS.gdk_bitmap_create_from_data(0L, byArray, n, n2);
        long l4 = OS.gdk_bitmap_create_from_data(0L, byArray2, n, n2);
        long l5 = 0L;
        if (l != 0L && l4 != 0L) {
            GdkColor gdkColor = new GdkColor();
            if (!bl) {
                gdkColor.blue = (short)-1;
                gdkColor.green = (short)-1;
                gdkColor.red = (short)-1;
            }
            GdkColor gdkColor2 = new GdkColor();
            if (bl) {
                gdkColor2.blue = (short)-1;
                gdkColor2.green = (short)-1;
                gdkColor2.red = (short)-1;
            }
            l5 = OS.gdk_cursor_new_from_pixmap(l, l4, gdkColor, gdkColor2, n3, n4);
        }
        if (l != 0L) {
            OS.g_object_unref(l);
        }
        if (l4 != 0L) {
            OS.g_object_unref(l4);
        }
        return l5;
    }

    @Override
    void destroy() {
        this.gdk_cursor_unref(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public static Cursor gtk_new(Device device, long l) {
        Cursor cursor = new Cursor(device);
        cursor.handle = l;
        return cursor;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    void gdk_cursor_unref(long l) {
        if (OS.GTK3) {
            OS.g_object_unref(l);
        } else {
            OS.gdk_cursor_unref(l);
        }
    }
}

