/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.gtk;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;

public class ListDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;
    private List dragList;

    public ListDragSourceEffect(List list) {
        super(list);
        this.dragList = list;
    }

    @Override
    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    @Override
    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        long[] lArray;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        if (this.dragList.isListening(40) || this.dragList.isListening(42)) {
            return null;
        }
        long l = this.dragList.handle;
        long l2 = OS.gtk_tree_view_get_selection(l);
        long l3 = OS.gtk_tree_selection_get_selected_rows(l2, lArray = null);
        if (l3 == 0L) {
            return null;
        }
        int n = Math.min(10, OS.g_list_length(l3));
        long l4 = l3;
        Display display = this.dragList.getDisplay();
        if (n == 1) {
            long l5 = OS.g_list_nth_data(l3, 0);
            long l6 = OS.gtk_tree_view_create_row_drag_icon(l, l5);
            this.dragSourceImage = Image.gtk_new(display, 1, l6, 0L);
            OS.gtk_tree_path_free(l5);
        } else {
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            long[] lArray2 = new long[n];
            GdkRectangle gdkRectangle = new GdkRectangle();
            for (int i = 0; i < n; ++i) {
                long l7 = OS.g_list_data(l3);
                OS.gtk_tree_view_get_cell_area(l, l7, 0L, gdkRectangle);
                lArray2[i] = OS.gtk_tree_view_create_row_drag_icon(l, l7);
                if (OS.GTK3) {
                    switch (Cairo.cairo_surface_get_type(lArray2[i])) {
                        case 0: {
                            nArray[0] = Cairo.cairo_image_surface_get_width(lArray2[i]);
                            nArray2[0] = Cairo.cairo_image_surface_get_height(lArray2[i]);
                            break;
                        }
                        case 3: {
                            nArray[0] = Cairo.cairo_xlib_surface_get_width(lArray2[i]);
                            nArray2[0] = Cairo.cairo_xlib_surface_get_height(lArray2[i]);
                        }
                    }
                } else {
                    OS.gdk_pixmap_get_size(lArray2[i], nArray, nArray2);
                }
                n2 = Math.max(n2, nArray[0]);
                n3 = gdkRectangle.y + nArray2[0] - nArray3[0];
                nArray3[i] = gdkRectangle.y;
                nArray4[i] = nArray2[0];
                l3 = OS.g_list_next(l3);
                OS.gtk_tree_path_free(l7);
            }
            if (OS.GTK3) {
                long l8;
                long l9 = Cairo.cairo_image_surface_create(0, n2, n3);
                if (l9 == 0L) {
                    SWT.error(2);
                }
                if ((l8 = Cairo.cairo_create(l9)) == 0L) {
                    SWT.error(2);
                }
                Cairo.cairo_set_operator(l8, 1);
                for (int i = 0; i < n; ++i) {
                    Cairo.cairo_set_source_surface(l8, lArray2[i], 2.0, nArray3[i] - nArray3[0] + 2);
                    Cairo.cairo_rectangle(l8, 0.0, nArray3[i] - nArray3[0], n2, nArray4[i]);
                    Cairo.cairo_fill(l8);
                    Cairo.cairo_surface_destroy(lArray2[i]);
                }
                Cairo.cairo_destroy(l8);
                this.dragSourceImage = Image.gtk_new(display, 1, l9, 0L);
            } else {
                long l10 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n2, n3, -1);
                long l11 = OS.gdk_gc_new(l10);
                long l12 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n2, n3, 1);
                long l13 = OS.gdk_gc_new(l12);
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = 0;
                OS.gdk_gc_set_foreground(l13, gdkColor);
                OS.gdk_draw_rectangle(l12, l13, 1, 0, 0, n2, n3);
                gdkColor.pixel = 1;
                OS.gdk_gc_set_foreground(l13, gdkColor);
                for (int i = 0; i < n; ++i) {
                    OS.gdk_draw_drawable(l10, l11, lArray2[i], 0, 0, 0, nArray3[i] - nArray3[0], -1, -1);
                    OS.gdk_draw_rectangle(l12, l13, 1, 0, nArray3[i] - nArray3[0], n2, nArray4[i]);
                    OS.g_object_unref(lArray2[i]);
                }
                OS.g_object_unref(l11);
                OS.g_object_unref(l13);
                this.dragSourceImage = Image.gtk_new(display, 1, l10, l12);
            }
        }
        OS.g_list_free(l4);
        return this.dragSourceImage;
    }
}

