/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.instrument;

import de.qfs.lib.log.Logger;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ModuleHelper {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.instrument.ModuleHelper");
    private static final boolean DEBUG = false;
    private static final boolean DEBUGCACHE = false;
    private static final Set emptySet = new HashSet();
    private static final Map emptyMap = new HashMap();
    private static final Map<OpenedPackage, Object> openedPackageCache = new ConcurrentHashMap<OpenedPackage, Object>();
    private static Instrumentation instrumentation;

    public static final void setInstrumentation(Instrumentation instrumentation) {
        if (ModuleHelper.logger.level >= 7) {
            Logger.Builder builder = logger.build("setInstrumentation(Instrumentation)");
            (ModuleHelper.logger.level < 8 ? builder : builder.add("_instrumentation: ").add(instrumentation)).log(7);
        }
        ModuleHelper.instrumentation = instrumentation;
    }

    public static void openModule(Class clazz, Object object) {
        if (object instanceof Module) {
            ModuleHelper.openModule(clazz.getModule(), clazz.getPackage().getName(), (Module)object);
        } else if (object instanceof ClassLoader) {
            ModuleHelper.openModule(clazz.getModule(), clazz.getPackage().getName(), ((ClassLoader)object).getUnnamedModule());
        } else if (object instanceof Class) {
            ModuleHelper.openModule(clazz, (Class)object, true);
        } else if (object != null) {
            ModuleHelper.openModule(clazz, object.getClass(), true);
        }
    }

    public static void openModule(String string, String string2, Object object) {
        Object object2;
        if (ModuleHelper.logger.level >= 7) {
            object2 = logger.build("openModule(String,String,Object)");
            ((Logger.Builder)(ModuleHelper.logger.level < 8 ? object2 : ((Logger.Builder)object2).add("moduleName: ").add(string).add(", packageName: ").add(string2).add(", caller: ").add(object))).dumpStack(7);
        }
        if ((object2 = ModuleHelper.findModule(string)) == null && ModuleHelper.logger.level >= 3) {
            logger.log(3, "openModule(String,String,Object)", "Cannot determine target module for " + string);
            return;
        }
        if (object instanceof Module) {
            ModuleHelper.openModule((Module)object2, string2, (Module)object);
        } else if (object instanceof ClassLoader) {
            ModuleHelper.openModule((Module)object2, string2, ((ClassLoader)object).getUnnamedModule());
        } else if (object instanceof Class) {
            ModuleHelper.openModule((Module)object2, string2, ((Class)object).getModule());
        } else if (object != null) {
            ModuleHelper.openModule((Module)object2, string2, object.getClass().getModule());
        }
    }

    public static void openModule(Class<?> clazz, String string, Class<?> clazz2) {
        ModuleHelper.openModule(clazz.getModule(), string, clazz2.getModule());
    }

    private static void openModule(Class clazz, Class clazz2, boolean bl) {
        block15: {
            if (clazz == null && ModuleHelper.logger.level >= 3) {
                logger.log(3, "openModule(Class,Class,boolean)", "Null targetClass");
                return;
            }
            if (!clazz.getModule().isNamed()) {
                if (ModuleHelper.logger.level >= 9) {
                    logger.log(9, "openModule(Class,Class,boolean)", "targetClass from unnamed module " + clazz.getModule());
                    if (!bl) {
                        return;
                    }
                }
            } else {
                if (clazz.getPackage() != null) {
                    ModuleHelper.openModule(clazz.getModule(), clazz.getPackage().getName(), clazz2.getModule());
                }
                if (clazz.isArray()) {
                    ModuleHelper.openModule(clazz.getComponentType(), clazz2, bl);
                }
            }
            if (bl) {
                Class<Object> clazz3;
                block14: {
                    try {
                        clazz3 = clazz.getSuperclass();
                        if (clazz3 != null) {
                            ModuleHelper.openModule(clazz3, clazz2, bl);
                        }
                    }
                    catch (Throwable throwable) {
                        if (ModuleHelper.logger.level < 5) break block14;
                        logger.log(5, "openModule(Class,Class,boolean)", throwable);
                    }
                }
                try {
                    clazz3 = clazz.getEnclosingClass();
                    if (clazz3 != null) {
                        ModuleHelper.openModule(clazz3, clazz2, bl);
                    }
                }
                catch (Throwable throwable) {
                    if (ModuleHelper.logger.level < 5) break block15;
                    logger.log(5, "openModule(Class,Class,boolean)", throwable);
                }
            }
        }
    }

    private static void openModule(Module module, String string, Module module2) {
        block6: {
            Object object;
            if (ModuleHelper.logger.level >= 7) {
                object = logger.build("openModule(Module,String,Module)");
                ((Logger.Builder)(ModuleHelper.logger.level < 8 ? object : ((Logger.Builder)object).add("targetModule: ").add(module).add(", packageName: ").add(string).add(", callingModule: ").add(module2))).dumpStack(7);
            }
            try {
                object = new OpenedPackage(string, module2);
                if (openedPackageCache.putIfAbsent((OpenedPackage)object, Boolean.TRUE) != null) {
                    if (ModuleHelper.logger.level >= 9) {
                        logger.build("openModule(Module,String,Module)").add("cache hit for ").add(object).log(9);
                    }
                    return;
                }
                HashSet<Module> hashSet = new HashSet<Module>();
                hashSet.add(module2);
                HashMap<String, Set<Module>> hashMap = new HashMap<String, Set<Module>>();
                hashMap.put(string, hashSet);
                instrumentation.redefineModule(module, emptySet, emptyMap, hashMap, emptySet, emptyMap);
                if (ModuleHelper.logger.level >= 5) {
                    logger.build("openModule(Module,String,Module)").add("module opened for ").add(object).dumpStack(5);
                }
            }
            catch (Throwable throwable) {
                if (ModuleHelper.logger.level < 3) break block6;
                logger.log(3, "openModule(Module,String,Module)", throwable);
            }
        }
    }

    private static Module findModule(String string) {
        if (instrumentation == null) {
            return null;
        }
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            Module module = clazz.getModule();
            if (!module.isNamed() || !string.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    static class OpenedPackage {
        private final String packageName;
        private final WeakReference<Module> openedFor;
        private final String repr;
        private final int hash;

        public OpenedPackage(String string, Module module) {
            this.hash = Objects.hash(string, module);
            this.packageName = string;
            this.openedFor = new WeakReference<Module>(module);
            this.repr = string + " - " + module;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OpenedPackage)) {
                return false;
            }
            if (this.openedFor.get() != ((OpenedPackage)object).openedFor.get()) {
                return false;
            }
            return this.packageName.equals(((OpenedPackage)object).packageName);
        }

        public String toString() {
            return this.repr;
        }
    }
}

