/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.instrument;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<WeakIdentityHashMapKey<K>, V> map;
    private final transient ReferenceQueue<K> queue = new ReferenceQueue();

    public WeakIdentityHashMap() {
        this.map = new HashMap<WeakIdentityHashMapKey<K>, V>(16);
    }

    public WeakIdentityHashMap(int n) {
        this.map = new HashMap<WeakIdentityHashMapKey<K>, V>(n);
    }

    @Override
    public int size() {
        return this.getCleanedMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getCleanedMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getCleanedMap().containsKey(new WeakIdentityHashMapKey<Object>(object, null));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.getCleanedMap().containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.getCleanedMap().get(new WeakIdentityHashMapKey<Object>(object, null));
    }

    @Override
    public V put(K k, V v) {
        return this.getCleanedMap().put(new WeakIdentityHashMapKey<K>(k, this.queue), v);
    }

    @Override
    public V remove(Object object) {
        return this.getCleanedMap().remove(new WeakIdentityHashMapKey<Object>(object, null));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.getCleanedMap().clear();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private K next;
                    final Iterator<WeakIdentityHashMapKey<K>> iterator;
                    {
                        this.iterator = WeakIdentityHashMap.this.getCleanedMap().keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iterator.hasNext()) {
                            this.next = this.iterator.next().get();
                            boolean bl = this.next == null;
                            if (bl) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public K next() {
                        if (this.next == null && !this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object k = this.next;
                        this.next = null;
                        return k;
                    }
                };
            }

            @Override
            public int size() {
                return WeakIdentityHashMap.this.getCleanedMap().keySet().size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return this.getCleanedMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private Map.Entry<WeakIdentityHashMapKey<K>, V> nextEntry;
                    final Iterator<Map.Entry<WeakIdentityHashMapKey<K>, V>> iterator;
                    {
                        this.iterator = WeakIdentityHashMap.this.getCleanedMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iterator.hasNext()) {
                            this.nextEntry = this.iterator.next();
                            boolean bl = this.nextEntry.getKey().get() == null;
                            if (bl) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.nextEntry == null && !this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        final Map.Entry entry = this.nextEntry;
                        this.nextEntry = null;
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return ((WeakIdentityHashMapKey)entry.getKey()).get();
                            }

                            @Override
                            public V getValue() {
                                return entry.getValue();
                            }

                            @Override
                            public V setValue(V v) {
                                return null;
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return WeakIdentityHashMap.this.getCleanedMap().entrySet().size();
            }
        };
    }

    private Map<WeakIdentityHashMapKey<K>, V> getCleanedMap() {
        Reference<K> reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(reference);
        }
        return this.map;
    }

    private static class WeakIdentityHashMapKey<K>
    extends WeakReference<K> {
        private final int hash;

        WeakIdentityHashMapKey(K k, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
            this.hash = System.identityHashCode(k);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof WeakIdentityHashMapKey) {
                return this.get() == ((WeakIdentityHashMapKey)object).get();
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

