/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogObjectDumper;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLoggerInterface;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class QFLogger
extends Logger
implements QFLoggerInterface {
    private boolean initialized = true;
    protected volatile List<LogObjectDumper> objectDumpers;

    public QFLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public QFLogger(Object object) {
        this(object.getClass().getName());
    }

    public QFLogger(String string) {
        super(string);
    }

    public LevelAwareLogBuilder lvlBuild(int n, String string) {
        return this.lvlBuild(n, string, 0);
    }

    public LevelAwareLogBuilder lvlBuild(int n, String string, int n2) {
        return new LevelAwareLogBuilder(this, n, string, n2, this.objectDumpers);
    }

    void addObjectDumper(LogObjectDumper logObjectDumper) {
        if (logObjectDumper == null) {
            return;
        }
        if (this.objectDumpers == null) {
            this.objectDumpers = new LinkedList<LogObjectDumper>();
        }
        this.objectDumpers.add(logObjectDumper);
    }

    @Override
    public void setLevel(int n) {
        super.setLevel(n);
        if (!this.initialized) {
            return;
        }
        String string = this.getOwnerName() + "_mtd.";
        boolean bl = false;
        Object[] objectArray = QFLogger.getLogLevels();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!string.equals(objectArray[i])) continue;
            bl = true;
            break;
        }
    }

    @Deprecated
    public QFLogger setMethodLevel(String string, int n) {
        return this;
    }

    public static void bridgeJavaLogger(String string) {
        QFLogger.bridgeJavaLogger(string, false, 0);
    }

    public static void bridgeJavaLogger(String string, boolean bl) {
        QFLogger.bridgeJavaLogger(string, bl, 0);
    }

    public static void bridgeJavaLogger(String string, boolean bl, int n) {
        try {
            new BridgingFilter(string, bl, n).bridge();
        }
        catch (Throwable throwable) {
            Log.log(5, string, "<setupLogger>", throwable);
        }
    }

    public static int javaLoggerLevelToQFLogLevel(Level level) {
        if (Level.SEVERE.equals(level)) {
            return 1;
        }
        if (Level.WARNING.equals(level)) {
            return 3;
        }
        if (Level.INFO.equals(level)) {
            return 5;
        }
        if (Level.CONFIG.equals(level)) {
            return 7;
        }
        return 9;
    }

    public static Level qfLoggerLevelToJavaLogLevel(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return Level.SEVERE;
            }
            case 3: 
            case 4: {
                return Level.WARNING;
            }
            case 5: 
            case 6: {
                return Level.INFO;
            }
            case 7: 
            case 8: {
                return Level.CONFIG;
            }
        }
        return Level.FINEST;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void log(int n, long l, String string, String string2) {
        Log.log(n, l, this.getOwnerName(), string, string2);
    }

    static {
        ClassLoader classLoader = QFLogger.class.getClassLoader();
        if (classLoader != null) {
            block4: for (String string : new String[]{"DefaultLogFormat", "FileLogWriter", "FlushBuffer", "GenericLevelAwareLogBuilder", "LevelAwareLogBuilder", "LevelFilter", "Log", "Log$DumpStackException", "LogEntry", "LogFilter", "LogFormat", "Logger$Builder", "Logger", "LogLevelCallback", "LogLevelEvent", "LogLevelListener", "LogLevels", "LogLevels$LogLevelThread", "LogLevels$Node", "Log$LogThread", "LogQueue", "LogSource", "LogStream", "LogUser", "LogWriter", "ProguardMap", "ProguardMapPossessor", "QFLogger$BridgingFilter", "QFLogger$BridgingLogger", "QFLogger", "QFLoggerInterface", "RingFileLogWriter", "StreamFilter", "StreamLogWriter", "TreeFilter"}) {
                try {
                    classLoader.loadClass("de.qfs.lib.log." + string);
                    for (int i = 1; i < 10; ++i) {
                        try {
                            classLoader.loadClass("de.qfs.lib.log." + string + "$" + i);
                            continue;
                        }
                        catch (Throwable throwable) {
                            continue block4;
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    break;
                }
            }
        }
    }

    private static class BridgingFilter
    implements Filter {
        final String classToLog;
        final boolean passThrough;
        final java.util.logging.Logger javalogger;
        final BridgingLogger qfLogger;
        final int levelOffset;

        public BridgingFilter(String string, boolean bl, int n) {
            this.classToLog = string;
            this.passThrough = bl;
            this.levelOffset = n;
            this.javalogger = java.util.logging.Logger.getLogger(string);
            this.qfLogger = new BridgingLogger(this.javalogger, string);
            this.qfLogger.setJavaLoggerLevel();
        }

        public BridgingFilter bridge() {
            this.javalogger.setFilter(this);
            return this;
        }

        @Override
        public boolean isLoggable(LogRecord logRecord) {
            int n = QFLogger.javaLoggerLevelToQFLogLevel(logRecord.getLevel()) + this.levelOffset;
            if (this.qfLogger.level >= n) {
                ((LevelAwareLogBuilder)this.qfLogger.lvlBuild(n, logRecord.getSourceMethodName()).add(logRecord.getMessage())).logAt(logRecord.getMillis());
            }
            return this.passThrough;
        }
    }

    private static class BridgingLogger
    extends QFLogger {
        final java.util.logging.Logger javalogger;

        public BridgingLogger(java.util.logging.Logger logger, String string) {
            super(string);
            this.javalogger = logger;
        }

        @Override
        public void setLevel(int n) {
            super.setLevel(n);
            this.setJavaLoggerLevel();
        }

        public void setJavaLoggerLevel() {
            if (this.javalogger != null) {
                this.javalogger.setLevel(BridgingLogger.qfLoggerLevelToJavaLogLevel(this.level));
            }
        }
    }
}

