/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.ThreadGroupTreeAdapter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public abstract class SystemInfo {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.SystemInfo");

    public SystemInfo() {
        if (SystemInfo.a.level >= 7) {
            a.lvlBuild(7, "SystemInfo.SystemInfo()", 44).log();
        }
    }

    public static String dumpThreads() {
        Object object;
        Object object2;
        HashMap hashMap;
        block9: {
            if (SystemInfo.a.level >= 7) {
                a.lvlBuild(7, "dumpThreads()", 56).log();
            }
            hashMap = new HashMap();
            try {
                object2 = new ThreadGroupTreeAdapter();
                object = TreeUtil.getRoot((TreeAdapter)object2, (Object)Thread.currentThread());
                if (SystemInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThreads()", 62).add("root", object)).log();
                }
                TreeUtil.visitTree((TreeAdapter)object2, (Object)new a(hashMap), (Object)object);
                if (SystemInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThreads()", 64).add("threadMap", hashMap)).log();
                }
            }
            catch (Throwable throwable) {
                if (SystemInfo.a.level < 3) break block9;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "dumpThreads()", 66).add("ex", (Object)throwable)).log();
            }
        }
        object2 = new StringBuilder();
        object = ManagementFactory.getThreadMXBean();
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThreads()", 70).add("tmb", object)).log();
        }
        ThreadInfo[] threadInfoArray = object.dumpAllThreads(true, true);
        Arrays.sort(threadInfoArray, Comparator.comparing(ThreadInfo::getThreadName));
        for (ThreadInfo threadInfo : threadInfoArray) {
            SystemInfo.a(threadInfo, (StringBuilder)object2, hashMap);
        }
        long[] lArray = object.findDeadlockedThreads();
        if (lArray != null) {
            ((StringBuilder)object2).append("\nDeadlock detected:\n");
            threadInfoArray = object.getThreadInfo(lArray, true, true);
            Arrays.sort(threadInfoArray, Comparator.comparing(ThreadInfo::getThreadName));
            for (ThreadInfo threadInfo : threadInfoArray) {
                SystemInfo.a(threadInfo, (StringBuilder)object2, hashMap);
            }
        }
        return ((StringBuilder)object2).toString();
    }

    public static String dumpMemoryInfo() {
        if (SystemInfo.a.level >= 7) {
            a.lvlBuild(7, "dumpMemoryInfo()", 96).log();
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpMemoryInfo()", 99).add("mmb", (Object)memoryMXBean)).log();
        }
        StringBuilder stringBuilder = new StringBuilder(5000);
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        stringBuilder.append("Heap memory usage: ");
        stringBuilder.append(memoryUsage.getUsed() / 0x100000L);
        stringBuilder.append(" / ");
        stringBuilder.append(memoryUsage.getMax() / 0x100000L);
        stringBuilder.append(" MB\n");
        memoryUsage = memoryMXBean.getNonHeapMemoryUsage();
        stringBuilder.append("Non-heap memory usage: ");
        stringBuilder.append(memoryUsage.getUsed() / 0x100000L);
        stringBuilder.append(" / ");
        if (memoryUsage.getMax() <= 0L) {
            stringBuilder.append("?");
        } else {
            stringBuilder.append(memoryUsage.getMax() / 0x100000L);
        }
        stringBuilder.append(" MB\n");
        return stringBuilder.toString();
    }

    public static String dumpSystemLoad() {
        if (SystemInfo.a.level >= 7) {
            a.lvlBuild(7, "dumpSystemLoad()", 128).log();
        }
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpSystemLoad()", 131).add("osmb", (Object)operatingSystemMXBean)).log();
        }
        double d2 = operatingSystemMXBean.getSystemLoadAverage();
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpSystemLoad()", 133).add("load", d2)).log();
        }
        if (d2 < 0.0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(5000);
        stringBuilder.append("Average system load for the last minute: ");
        stringBuilder.append(d2);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static String getProcessId() {
        if (SystemInfo.a.level >= 7) {
            a.lvlBuild(7, "getProcessId()", 152).log();
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getProcessId()", 155).add("rb", (Object)runtimeMXBean)).log();
        }
        try {
            return runtimeMXBean.getName().split("@")[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void a(ThreadInfo threadInfo, StringBuilder stringBuilder, Map map) {
        if (SystemInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "dumpThread(ThreadInfo,StringBuilder,Map<Long, Thread>)", 177).addDetail("thread", (Object)threadInfo)).addDetail("ret", (Object)stringBuilder)).addDetail("threadMap", (Object)map)).log();
        }
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThread(ThreadInfo,StringBuilder,Map<Long, Thread>)", 179).add("thread", (Object)threadInfo)).add("thread.getClass().getName()", threadInfo.getClass().getName())).log();
        }
        stringBuilder.append('\"');
        stringBuilder.append(threadInfo.getThreadName());
        stringBuilder.append("\" #");
        long l2 = threadInfo.getThreadId();
        stringBuilder.append(l2);
        Thread thread = (Thread)map.get(l2);
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThread(ThreadInfo,StringBuilder,Map<Long, Thread>)", 188).add("th", (Object)thread)).log();
        }
        if (thread != null) {
            if (thread.isDaemon()) {
                stringBuilder.append(" daemon");
            }
            stringBuilder.append(" prio=");
            stringBuilder.append(thread.getPriority());
        }
        stringBuilder.append(" tid=");
        stringBuilder.append(l2);
        stringBuilder.append(" nid=1");
        Thread.State state = threadInfo.getThreadState();
        stringBuilder.append(" ");
        if (Thread.State.WAITING.equals((Object)state)) {
            stringBuilder.append("in Object.wait()");
        } else {
            stringBuilder.append(state.name().toLowerCase());
        }
        stringBuilder.append("\n   java.lang.Thread.State: ");
        if (Thread.State.WAITING.equals((Object)state)) {
            stringBuilder.append("WAITING (on object monitor)");
        } else {
            stringBuilder.append((Object)state);
        }
        LockInfo lockInfo = threadInfo.getLockInfo();
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThread(ThreadInfo,StringBuilder,Map<Long, Thread>)", 216).add("lock", (Object)lockInfo)).add(" is monitor: ", lockInfo instanceof MonitorInfo)).log();
        }
        stringBuilder.append("\n");
        if (threadInfo.getLockOwnerName() != null) {
            stringBuilder.append(" owned by ");
            stringBuilder.append(threadInfo.getLockOwnerName());
            stringBuilder.append(" id=");
            stringBuilder.append(threadInfo.getLockOwnerId());
            stringBuilder.append("\n");
        }
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        if (SystemInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThread(ThreadInfo,StringBuilder,Map<Long, Thread>)", 250).add("monitors", (Object)monitorInfoArray)).log();
        }
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            LockInfo[] lockInfoArray = stackTraceElementArray[i2];
            stringBuilder.append("\tat ");
            stringBuilder.append(lockInfoArray);
            if (i2 == 0) {
                if (SystemInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "dumpThread(ThreadInfo,StringBuilder,Map<Long, Thread>)", 260).add("lock", (Object)lockInfo)).log();
                }
                if (lockInfo != null) {
                    stringBuilder.append("\n\t- waiting ");
                    if (state == Thread.State.BLOCKED) {
                        stringBuilder.append("to lock");
                    } else {
                        stringBuilder.append("on");
                    }
                    stringBuilder.append(" <0x");
                    stringBuilder.append(Integer.toHexString(lockInfo.getIdentityHashCode()));
                    stringBuilder.append("> (a ");
                    stringBuilder.append(lockInfo.getClassName());
                    stringBuilder.append(")");
                    if (threadInfo.getLockOwnerName() != null) {
                        stringBuilder.append(" owned by \"");
                        stringBuilder.append(threadInfo.getLockOwnerName());
                        stringBuilder.append("\" #");
                        stringBuilder.append(threadInfo.getLockOwnerId());
                    }
                }
            }
            stringBuilder.append("\n");
            MonitorInfo[] monitorInfoArray2 = monitorInfoArray;
            int n2 = monitorInfoArray2.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                MonitorInfo monitorInfo = monitorInfoArray2[i3];
                if (monitorInfo.getLockedStackDepth() != i2) continue;
                stringBuilder.append("\t- locked <0x");
                stringBuilder.append(Integer.toHexString(monitorInfo.getIdentityHashCode()));
                stringBuilder.append("> (a ");
                stringBuilder.append(monitorInfo.getClassName());
                stringBuilder.append(")\n");
            }
        }
        stringBuilder.append("\n");
        LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
        if (lockInfoArray.length > 0) {
            stringBuilder.append("   Locked ownable synchronizers:\n");
            for (LockInfo lockInfo2 : lockInfoArray) {
                stringBuilder.append("\t- <0x");
                stringBuilder.append(Integer.toHexString(lockInfo2.getIdentityHashCode()));
                stringBuilder.append("> (a ");
                stringBuilder.append(lockInfo2.getClassName());
                stringBuilder.append(")\n");
            }
            stringBuilder.append("\n");
        }
    }

    public static class a {
        private Map a;

        public a(Map map) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "ThreadGroupVisitor.ThreadGroupVisitor(Map<Long, Thread>)", 326).addDetail("threadMap", (Object)map)).log();
            }
            this.a = map;
        }

        public Object visit(ThreadGroup threadGroup) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "ThreadGroupVisitor.visit(ThreadGroup)", 333).addDetail("tg", (Object)threadGroup)).log();
            }
            return null;
        }

        public Object visit(Thread thread) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "ThreadGroupVisitor.visit(Thread)", 339).addDetail("thread", (Object)thread)).log();
            }
            this.a.put(thread.getId(), thread);
            return null;
        }
    }
}

