/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt;

import de.qfs.apps.qftest.client.awt.EventRecorder;
import de.qfs.apps.qftest.client.awt.ex;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class PopupHelper {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.PopupHelper");
    private EventRecorder b;
    private Component c;
    private PopupHelperWindow d;
    private Dimension e;

    public PopupHelper(EventRecorder eventRecorder) {
        if (PopupHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "PopupHelper(EventRecorder)", 97).addDetail("recorder", (Object)eventRecorder)).log();
        }
        this.b = eventRecorder;
    }

    public Component a() {
        return this.c;
    }

    public void a(Component component) {
        if (PopupHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setPopup(Component)", 128).addDetail("popup", (Object)component)).log();
        }
        this.c = component;
    }

    public void b() {
        if (this.d != null) {
            block3: {
                this.d.getContentPane().remove(this.c);
                try {
                    SwingUtil.deactivateInputContexts((Window)this.d);
                    this.d.dispose();
                }
                catch (IllegalStateException illegalStateException) {
                    if (PopupHelper.a.level < 1) break block3;
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "cancelPopup()", 149).add("ex", (Object)illegalStateException)).log();
                }
            }
            this.d = null;
        }
        this.b.e(false);
    }

    public void a(Component component, int n2, int n3) {
        MenuElement[] menuElementArray;
        Rectangle rectangle;
        GraphicsConfiguration graphicsConfiguration;
        Dimension dimension;
        Component component2;
        if (PopupHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "show(Component,int,int)", 166).addDetail("com", (Object)component)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        this.b.e(true);
        if (this.c == null) {
            this.c = new JLabel("Internal error");
        }
        if (this.d != null) {
            if (PopupHelper.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "show(Component,int,int)", 175).add("Window already showing")).log();
            }
            this.b();
        }
        for (component2 = component; component2 != null && !(component2 instanceof Window); component2 = component2.getParent()) {
            if (PopupHelper.a.level < 9) continue;
            ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 180).add("tmp", (Object)component2)).log();
        }
        if (PopupHelper.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 184).add("tmp", (Object)component2)).log();
        }
        this.d = component2 == null ? new PopupHelperWindow() : new PopupHelperWindow((Window)component2);
        this.d.setName("PopupHelper");
        this.d.setAlwaysOnTop(true);
        if (PopupHelper.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 188).add("window", (Object)this.d)).log();
        }
        this.d.getContentPane().add(this.c);
        Reflector.safeCall((Object)this.d, (String)"setFocusableWindowState", Boolean.TYPE, (Object)Boolean.FALSE);
        this.d.addWindowListener(new ex(this));
        SwingUtil.closeOnEscape((Window)this.d);
        this.d.pack();
        if (PopupHelper.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 243).add("window", (Object)this.d)).log();
        }
        Point point = component.getLocationOnScreen();
        point.x += n2;
        point.y += n3;
        if (PopupHelper.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 247).add("pos", (Object)point)).log();
        }
        this.e = dimension = this.d.getSize();
        if (PopupHelper.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 254).add("size", (Object)dimension)).log();
        }
        if ((graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration((int)point.x, (int)point.y)) != null) {
            rectangle = graphicsConfiguration.getBounds();
            menuElementArray = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            if (PopupHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 261).add("insets", (Object)menuElementArray)).log();
            }
            rectangle.x += menuElementArray.left;
            rectangle.y += menuElementArray.top;
            rectangle.width -= menuElementArray.left + menuElementArray.right;
            rectangle.height -= menuElementArray.top + menuElementArray.bottom;
        } else {
            menuElementArray = component.getToolkit().getScreenSize();
            rectangle = new Rectangle(0, 0, menuElementArray.width, menuElementArray.height);
            if (Misc.OS_IS_WINDOWS) {
                rectangle.height -= 30;
            }
        }
        menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray != null) {
            Dimension dimension2;
            Point point2;
            int n4;
            boolean bl2 = false;
            for (n4 = menuElementArray.length - 1; n4 >= 0; --n4) {
                if (!(menuElementArray[n4] instanceof JPopupMenu)) continue;
                if (PopupHelper.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 280).add("sel[" + n4 + "]", (Object)menuElementArray[n4])).log();
                }
                point2 = ((JPopupMenu)menuElementArray[n4]).getLocationOnScreen();
                if (PopupHelper.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 282).add("ppos", (Object)point2)).log();
                }
                dimension2 = ((JPopupMenu)menuElementArray[n4]).getSize();
                if (PopupHelper.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 284).add("psize", (Object)dimension2)).log();
                }
                if (point.x < point2.x + dimension2.width) {
                    if (point.x < point2.x || rectangle.x + rectangle.width < point2.x + dimension2.width + dimension.width) break;
                    point.x = point2.x + dimension2.width;
                    bl2 = true;
                    break;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                for (n4 = 0; n4 < menuElementArray.length; ++n4) {
                    if (!(menuElementArray[n4] instanceof JPopupMenu)) continue;
                    if (PopupHelper.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 303).add("sel[" + n4 + "]", (Object)menuElementArray[n4])).log();
                    }
                    point2 = ((JPopupMenu)menuElementArray[n4]).getLocationOnScreen();
                    if (PopupHelper.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 305).add("ppos", (Object)point2)).log();
                    }
                    dimension2 = ((JPopupMenu)menuElementArray[n4]).getSize();
                    if (PopupHelper.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "show(Component,int,int)", 307).add("psize", (Object)dimension2)).log();
                    }
                    if (point.x >= point2.x + dimension2.width || point.x + dimension.width <= point2.x || point2.x - rectangle.x < dimension.width) break;
                    point.x = point2.x - dimension.width;
                    break;
                }
            }
        }
        if (point.x + dimension.width > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width - dimension.width;
        }
        if (point.y + dimension.height > rectangle.y + rectangle.height) {
            point.y = rectangle.y + rectangle.height - dimension.height;
        }
        this.d.setLocation(point);
        this.d.show();
        if (this.d != null) {
            this.d.setSize(dimension);
        }
    }

    public boolean a(MouseEvent mouseEvent) {
        boolean bl2;
        if (PopupHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isInsidePopup(MouseEvent)", 345).addDetail("event", (Object)mouseEvent)).log();
        }
        if (!(mouseEvent.getSource() instanceof Component)) {
            return false;
        }
        Component component = (Component)mouseEvent.getSource();
        Component component2 = this.c;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Dimension dimension = component2.getSize();
        boolean bl3 = Options.cached_OPT_RECORD_AWT_VIA_TRACKER;
        while (component2 != null && component != null && component2 != component) {
            Point point;
            if (PopupHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "isInsidePopup(MouseEvent)", 357).add("menu", (Object)component2)).add("com", (Object)component)).log();
            }
            if (bl3) {
                point = component.getLocation();
                n2 += point.x;
                n3 += point.y;
                component = component.getParent();
                continue;
            }
            point = component2.getLocation();
            n2 -= point.x;
            n3 -= point.y;
            component2 = component2.getParent();
        }
        if (PopupHelper.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "isInsidePopup(MouseEvent)", 372).add("menu", (Object)component2)).add("com", (Object)component)).add("x", n2)).add("y", n3)).log();
        }
        boolean bl4 = bl2 = component2 == component && n2 >= 0 && n3 >= 0 && n2 < dimension.width && n3 < dimension.height;
        if (PopupHelper.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "isInsidePopup(MouseEvent)", 377).add("result", bl2)).log();
        }
        return bl2;
    }

    public boolean b(Component component) {
        return component == this.d;
    }

    public JButton a(String string) {
        JButton jButton;
        block7: {
            Object object;
            block6: {
                jButton = new JButton(string){

                    @Override
                    public boolean isFocusTraversable() {
                        return false;
                    }
                };
                jButton.setRequestFocusEnabled(false);
                jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 0, 0)));
                jButton.setHorizontalAlignment(2);
                String string2 = Options.cached_OPT_SWING_CHECK_MENU_FONT_COLOR;
                if (string2 != null) {
                    try {
                        object = string2.split(",");
                        jButton.setForeground(new Color(Integer.parseInt(object[0].trim()), Integer.parseInt(object[1].trim()), Integer.parseInt(object[2].trim())));
                    }
                    catch (Throwable throwable) {
                        if (PopupHelper.a.level < 3) break block6;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "makeButton(String)", 431).add("ex", (Object)throwable)).log();
                    }
                }
            }
            try {
                object = Reflector.get(BasicComboBoxUI.class, (String)"HIDE_POPUP_KEY", (boolean)true);
                if (object != null) {
                    jButton.putClientProperty("doNotCancelPopup", object);
                }
            }
            catch (Throwable throwable) {
                if (PopupHelper.a.level < 3) break block7;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "makeButton(String)", 441).add("ex", (Object)throwable)).log();
            }
        }
        return jButton;
    }

    public Component a(String string, JButton[] jButtonArray) {
        int n2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(3, 5, 5, 5)));
        JLabel jLabel = new JLabel(string);
        jLabel.setName("popup.title");
        jLabel.setForeground(UIManager.getColor("textInactiveText"));
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(3));
        int n3 = jLabel.getPreferredSize().width;
        for (n2 = 0; n2 < jButtonArray.length; ++n2) {
            n3 = Math.max(n3, jButtonArray[n2].getPreferredSize().width);
        }
        for (n2 = 0; n2 < jButtonArray.length; ++n2) {
            jButtonArray[n2].setMaximumSize(new Dimension(n3, jButtonArray[n2].getPreferredSize().height));
            jPanel.add(jButtonArray[n2]);
        }
        return jPanel;
    }

    private class PopupHelperWindow
    extends JWindow {
        protected PopupHelperWindow() {
            if (a.level >= 7) {
                a.lvlBuild(7, "PopupHelperWindow.PopupHelperWindow()", 500).log();
            }
        }

        public PopupHelperWindow(Window window) {
            super(window);
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "PopupHelperWindow.PopupHelperWindow(Window)", 507).addDetail("win", (Object)window)).log();
            }
        }
    }
}

