/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.awt.check.BaseChecker;
import de.qfs.apps.qftest.client.awt.data.h;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.client.awt.ui.ComponentHelper;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.data.ElementInfo;
import de.qfs.apps.qftest.shared.data.SmartInfo;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.GeometryCheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.rmi.qftest.RemoteRunContext;
import de.qfs.apps.qftest.shared.rmi.qftest.RemoteRunContextWrapper;
import de.qfs.apps.qftest.shared.rmi.sut.RemotePlayback;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.rmi.RemoteException;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ComponentChecker
extends BaseChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.check.ComponentChecker");
    private CheckType[] b = new CheckType[]{CheckType.VISIBLE, CheckType.ENABLED, CheckType.FOCUSED, CheckType.IMAGE, CheckType.GEOMETRY};
    protected s engine;

    public ComponentChecker(s s2) {
        if (ComponentChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "ComponentChecker(AWTEngine)", 87).addDetail("engine", (Object)s2)).log();
        }
        this.engine = s2;
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (ComponentChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 104).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        return this.b;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (ComponentChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 122).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.FOCUSED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.FOCUSED.getIdentifier(), ((Component)object).hasFocus());
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.VISIBLE.getIdentifier(), ((Component)object).isShowing());
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.ENABLED.getIdentifier(), ((Component)object).isEnabled());
        }
        if (checkType.getDataType() == CheckDataType.IMAGE && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()))) {
            if (((Component)object).getParent() instanceof JViewport && (((Component)object).getSize().width <= 0 || ((Component)object).getSize().height <= 0)) {
                object = ((Component)object).getParent();
            }
            ImageRep imageRep = this.grabImage((Component)object);
            return new ImageCheckData("default", imageRep, -1, -1, -1, -1, -1, -1, false);
        }
        if (checkType.getDataType() == CheckDataType.GEOMETRY && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.GEOMETRY.getIdentifier().equals(checkType.getIdentifier()))) {
            Point point = new Point(0, 0);
            if (ComponentHelper.instance().isToplevel((Component)object)) {
                point = ((Component)object).getLocation();
            } else {
                ComponentHelper.instance().getToplevelParent((Component)object, point);
            }
            Dimension dimension = ((Component)object).getSize();
            return new GeometryCheckData("default", point.x, point.y, dimension.width, dimension.height);
        }
        return null;
    }

    protected ImageRep grabImage(Component component) throws TestException {
        if (ComponentChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Component)", 173).addDetail("target", (Object)component)).log();
        }
        ImageRep imageRep = null;
        String string = Options.cached_OPT_JIB_REPLAY_SWING_IMAGE_CHECK_AS;
        if (!"local".equalsIgnoreCase(string) && !"swing".equalsIgnoreCase(string)) {
            Dimension dimension = component.getSize();
            imageRep = this.grabForeignImage(component, 0, 0, dimension.width, dimension.height);
        }
        if (imageRep == null) {
            imageRep = BaseImageHandler.instance((Object)this.engine).grabImage((Object)component);
        }
        return imageRep;
    }

    protected ImageRep grabImage(Component component, int n2, int n3, int n4, int n5) throws TestException {
        if (ComponentChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Component,int,int,int,int)", 192).addDetail("target", (Object)component)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
        }
        ImageRep imageRep = null;
        String string = Options.cached_OPT_JIB_REPLAY_SWING_IMAGE_CHECK_AS;
        if (!"local".equalsIgnoreCase(string) && !"swing".equalsIgnoreCase(string)) {
            imageRep = this.grabForeignImage(component, n2, n3, n4, n5);
        }
        if (imageRep == null) {
            imageRep = BaseImageHandler.instance((Object)this.engine).grabImage((Object)component, n2, n3, n4, n5);
        }
        return imageRep;
    }

    protected ImageRep grabImage(Component component, Object object) throws TestException {
        if (ComponentChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Component,Object)", 210).addDetail("target", (Object)component)).addDetail("item", object)).log();
        }
        ImageRep imageRep = null;
        String string = Options.cached_OPT_JIB_REPLAY_SWING_IMAGE_CHECK_AS;
        if (!"local".equalsIgnoreCase(string) && !"swing".equalsIgnoreCase(string)) {
            int[] nArray = ItemRegistry.instance().getItemLocation(component, object);
            int[] nArray2 = ItemRegistry.instance().getItemSize(component, object);
            imageRep = this.grabForeignImage(component, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        }
        if (imageRep == null) {
            imageRep = h.a(component, object);
        }
        return imageRep;
    }

    protected ImageRep grabForeignImage(Component component, int n2, int n3, int n4, int n5) throws TestException {
        block8: {
            RemotePlayback remotePlayback;
            if (ComponentChecker.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabForeignImage(Component,int,int,int,int)", 230).addDetail("target", (Object)component)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
            }
            if ((remotePlayback = Client.instance().getForeignPlayback()) != null) {
                RemoteRunContext remoteRunContext = Client.instance().getRunContext();
                if (ComponentChecker.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "grabForeignImage(Component,int,int,int,int)", 236).add("rrc", (Object)remoteRunContext)).log();
                }
                RemoteRunContext remoteRunContext2 = null;
                try {
                    if (remoteRunContext instanceof RemoteRunContextWrapper) {
                        remoteRunContext2 = ((RemoteRunContextWrapper)remoteRunContext).getDelegate();
                    }
                    SmartInfo smartInfo = new SmartInfo("#HTML:");
                    Point point = new Point();
                    SwingUtilities.convertPointToScreen(point, component);
                    if (ComponentChecker.a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "grabForeignImage(Component,int,int,int,int)", 245).add("fetching image from foreign playback for")).add("pos", (Object)point)).log();
                    }
                    ImageRep imageRep = remotePlayback.grabImage(remoteRunContext2, (ElementInfo)smartInfo, point.x + n2, point.y + n3, n4, n5, (long)Options.cached_OPT_PLAY_TIMEOUT_DEADLOCK * 1000L, -1L);
                    if (ComponentChecker.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "grabForeignImage(Component,int,int,int,int)", 248).add("redirect complete")).log();
                    }
                    return imageRep;
                }
                catch (RemoteException remoteException) {
                    if (ComponentChecker.a.level < 3) break block8;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "grabForeignImage(Component,int,int,int,int)", 251).add("ex", (Object)remoteException)).log();
                }
            }
        }
        return null;
    }
}

